/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.xades.XAdESTimestampParameters;
import eu.europa.esig.dss.xades.signature.XAdESLevelC;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XAdESLevelX
extends XAdESLevelC {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESLevelX.class);

    public XAdESLevelX(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    @Override
    protected void extendSignatures(List<AdvancedSignature> signatures) {
        super.extendSignatures(signatures);
        for (AdvancedSignature signature : signatures) {
            this.initializeSignatureBuilder((XAdESSignature)signature);
            if (!this.xLevelExtensionRequired(this.params.getSignatureLevel())) continue;
            this.assertExtendSignatureToXPossible();
            this.removeOldTimestamps();
            Element levelCUnsignedProperties = (Element)this.unsignedSignaturePropertiesDom.cloneNode(true);
            XAdESTimestampParameters signatureTimestampParameters = this.params.getSignatureTimestampParameters();
            String canonicalizationMethod = signatureTimestampParameters.getCanonicalizationMethod();
            byte[] timestampX1Data = this.xadesSignature.getTimestampSource().getTimestampX1Data(canonicalizationMethod, this.params.isEn319132());
            DigestAlgorithm timestampDigestAlgorithm = signatureTimestampParameters.getDigestAlgorithm();
            byte[] digestValue = DSSUtils.digest((DigestAlgorithm)timestampDigestAlgorithm, (byte[])timestampX1Data);
            this.createXAdESTimeStampType(TimestampType.VALIDATION_DATA_TIMESTAMP, canonicalizationMethod, digestValue);
            this.unsignedSignaturePropertiesDom = this.indentIfPrettyPrint(this.unsignedSignaturePropertiesDom, levelCUnsignedProperties);
        }
    }

    private boolean xLevelExtensionRequired(SignatureLevel signatureLevel) {
        return SignatureLevel.XAdES_X.equals((Object)signatureLevel) || SignatureLevel.XAdES_XL.equals((Object)signatureLevel) || !this.xadesSignature.hasXProfile();
    }

    private void removeOldTimestamps() {
        NodeList sigAndRefsTimeStampList = this.xadesSignature.getSigAndRefsTimeStamp();
        if (sigAndRefsTimeStampList != null && sigAndRefsTimeStampList.getLength() > 0) {
            LOG.warn("An existing SigAndRefsTimeStamp found! The entry will be removed in order to extend the signature with the updated data.");
        }
        this.removeNodes(sigAndRefsTimeStampList);
        NodeList refsOnlyTimestampTimeStamp = this.xadesSignature.getRefsOnlyTimestampTimeStamp();
        if (refsOnlyTimestampTimeStamp != null && refsOnlyTimestampTimeStamp.getLength() > 0) {
            LOG.warn("An existing RefsOnlyTimeStamp found! The entry will be removed in order to extend the signature with the updated data.");
        }
        this.removeNodes(refsOnlyTimestampTimeStamp);
    }

    private void assertExtendSignatureToXPossible() {
        SignatureLevel signatureLevel = this.params.getSignatureLevel();
        if (SignatureLevel.XAdES_X.equals((Object)signatureLevel) && (this.xadesSignature.hasAProfile() || this.xadesSignature.hasXLProfile() && !this.xadesSignature.areAllSelfSignedCertificates()) || SignatureLevel.XAdES_XL.equals((Object)signatureLevel) && this.xadesSignature.hasAProfile()) {
            throw new IllegalInputException(String.format("Cannot extend signature to '%s'. The signature is already extended with higher level.", signatureLevel));
        }
    }
}

