/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.AbstractSignatureParameters;
import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.definition.DSSElement;
import eu.europa.esig.dss.definition.DSSNamespace;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigAttribute;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigElement;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigPaths;
import eu.europa.esig.dss.enumerations.CommitmentType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.MaskGenerationFunction;
import eu.europa.esig.dss.enumerations.ObjectIdentifierQualifier;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.CommonCommitmentType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.MimeType;
import eu.europa.esig.dss.model.Policy;
import eu.europa.esig.dss.model.SignerLocation;
import eu.europa.esig.dss.model.SpDocSpecification;
import eu.europa.esig.dss.model.UserNotice;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.signature.BaselineBCertificateSelector;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.timestamp.TimestampInclude;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.xades.DSSObject;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.SignatureBuilder;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.definition.xades132.XAdES132Attribute;
import eu.europa.esig.dss.xades.reference.DSSReference;
import eu.europa.esig.dss.xades.reference.ReferenceBuilder;
import eu.europa.esig.dss.xades.reference.ReferenceProcessor;
import eu.europa.esig.dss.xades.reference.ReferenceVerifier;
import eu.europa.esig.dss.xades.signature.DetachedSignatureBuilder;
import eu.europa.esig.dss.xades.signature.EnvelopedSignatureBuilder;
import eu.europa.esig.dss.xades.signature.EnvelopingSignatureBuilder;
import eu.europa.esig.dss.xades.signature.InternallyDetachedSignatureBuilder;
import eu.europa.esig.dss.xades.signature.XAdESBuilder;
import eu.europa.esig.dss.xades.signature.XmlPolicyWithTransforms;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class XAdESSignatureBuilder
extends XAdESBuilder
implements SignatureBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESSignatureBuilder.class);
    protected boolean built = false;
    protected DSSDocument document;
    protected String keyInfoCanonicalizationMethod;
    protected String signedInfoCanonicalizationMethod;
    protected String signedPropertiesCanonicalizationMethod;
    protected final String deterministicId;
    protected Element signatureDom;
    protected Element keyInfoDom;
    protected Element signedInfoDom;
    protected Element signatureValueDom;
    protected Element qualifyingPropertiesDom;
    protected Element signedPropertiesDom;
    protected Element signedSignaturePropertiesDom;
    protected Element signedDataObjectPropertiesDom;
    protected Element unsignedSignaturePropertiesDom;
    protected static final String KEYINFO_SUFFIX = "keyInfo-";
    protected static final String TIMESTAMP_SUFFIX = "TS-";
    protected static final String VALUE_SUFFIX = "value-";
    protected static final String XADES_SUFFIX = "xades-";

    public static XAdESSignatureBuilder getSignatureBuilder(XAdESSignatureParameters params, DSSDocument document, CertificateVerifier certificateVerifier) {
        Objects.requireNonNull(params.getSignaturePackaging(), "Cannot create a SignatureBuilder. SignaturePackaging is not defined!");
        switch (params.getSignaturePackaging()) {
            case ENVELOPED: {
                return new EnvelopedSignatureBuilder(params, document, certificateVerifier);
            }
            case ENVELOPING: {
                return new EnvelopingSignatureBuilder(params, document, certificateVerifier);
            }
            case DETACHED: {
                return new DetachedSignatureBuilder(params, document, certificateVerifier);
            }
            case INTERNALLY_DETACHED: {
                return new InternallyDetachedSignatureBuilder(params, document, certificateVerifier);
            }
        }
        throw new DSSException("Unsupported packaging " + params.getSignaturePackaging());
    }

    protected XAdESSignatureBuilder(XAdESSignatureParameters params, DSSDocument document, CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
        this.params = params;
        this.document = document;
        this.deterministicId = params.getDeterministicId();
        this.setCanonicalizationMethods(params);
    }

    private void setCanonicalizationMethods(XAdESSignatureParameters params) {
        this.keyInfoCanonicalizationMethod = params.getKeyInfoCanonicalizationMethod();
        this.signedInfoCanonicalizationMethod = params.getSignedInfoCanonicalizationMethod();
        this.signedPropertiesCanonicalizationMethod = params.getSignedPropertiesCanonicalizationMethod();
    }

    public byte[] build() throws DSSException {
        this.assertSignaturePossible();
        this.ensureConfigurationValidity();
        this.xadesPaths = this.getCurrentXAdESPaths();
        this.documentDom = this.buildRootDocumentDom();
        this.incorporateFiles();
        this.incorporateSignatureDom();
        this.incorporateSignedInfo();
        this.incorporateSignatureValue();
        this.incorporateKeyInfo();
        this.incorporateObjects();
        if (Utils.isArrayEmpty((byte[])this.params.getSignedData())) {
            this.incorporateReferences();
            this.incorporateReferenceSignedProperties();
            this.incorporateReferenceKeyInfo();
        }
        byte[] canonicalizedSignedInfo = DSSXMLUtils.canonicalizeSubtree(this.signedInfoCanonicalizationMethod, this.getNodeToCanonicalize(this.signedInfoDom));
        if (LOG.isTraceEnabled()) {
            LOG.trace("Canonicalized SignedInfo         --> {}", (Object)new String(canonicalizedSignedInfo));
            byte[] digest = DSSUtils.digest((DigestAlgorithm)DigestAlgorithm.SHA256, (byte[])canonicalizedSignedInfo);
            LOG.trace("Canonicalized SignedInfo SHA256  --> {}", (Object)Utils.toBase64((byte[])digest));
        }
        this.built = true;
        return canonicalizedSignedInfo;
    }

    private void assertSignaturePossible() {
        Document dom;
        NodeList signatureNodeList;
        if (DomUtils.isDOM((DSSDocument)this.document) && (signatureNodeList = DSSXMLUtils.getAllSignaturesExceptCounterSignatures(dom = DomUtils.buildDOM((DSSDocument)this.document))) != null && signatureNodeList.getLength() > 0) {
            for (int ii = 0; ii < signatureNodeList.getLength(); ++ii) {
                Node signatureNode = signatureNodeList.item(ii);
                this.assertDoesNotContainEnvelopedTransform(signatureNode);
            }
        }
    }

    private void assertDoesNotContainEnvelopedTransform(Node signatureNode) {
        NodeList referenceNodeList = DSSXMLUtils.getReferenceNodeList(signatureNode);
        if (referenceNodeList != null && referenceNodeList.getLength() > 0) {
            for (int ii = 0; ii < referenceNodeList.getLength(); ++ii) {
                Node referenceNode = referenceNodeList.item(ii);
                NodeList transformList = DomUtils.getNodeList((Node)referenceNode, (String)XMLDSigPaths.TRANSFORMS_TRANSFORM_PATH);
                if (transformList == null || transformList.getLength() <= 0) continue;
                for (int jj = 0; jj < transformList.getLength(); ++jj) {
                    Element transformElement = (Element)transformList.item(jj);
                    String transformAlgorithm = transformElement.getAttribute(XMLDSigAttribute.ALGORITHM.getAttributeName());
                    if (!"http://www.w3.org/2000/09/xmldsig#enveloped-signature".equals(transformAlgorithm)) continue;
                    throw new IllegalInputException(String.format("The parallel signature is not possible! The provided file contains a signature with an '%s' transform.", "http://www.w3.org/2000/09/xmldsig#enveloped-signature"));
                }
            }
        }
    }

    private void ensureConfigurationValidity() {
        this.checkSignaturePackagingValidity();
        List<DSSReference> references = this.params.getReferences();
        if (Utils.isCollectionEmpty(references)) {
            ReferenceBuilder referenceBuilder = this.initReferenceBuilder();
            List<DSSReference> defaultReferences = referenceBuilder.build();
            this.params.getContext().setReferences(defaultReferences);
        } else {
            ReferenceVerifier referenceVerifier = new ReferenceVerifier(this.params);
            referenceVerifier.checkReferencesValidity();
        }
    }

    private ReferenceBuilder initReferenceBuilder() {
        List<DSSDocument> detachedContent = Utils.isCollectionNotEmpty((Collection)this.params.getDetachedContents()) ? this.params.getDetachedContents() : Arrays.asList(this.document);
        return new ReferenceBuilder(detachedContent, this.params);
    }

    private void checkSignaturePackagingValidity() {
        if (!SignaturePackaging.ENVELOPING.equals((Object)this.params.getSignaturePackaging())) {
            if (this.params.isManifestSignature()) {
                throw new IllegalArgumentException(String.format("The signature packaging %s is not compatible with manifestSignature(true) configuration!", this.params.getSignaturePackaging()));
            }
            if (this.params.isEmbedXML()) {
                throw new IllegalArgumentException(String.format("The signature packaging %s is not compatible with embedXML(true) configuration!", this.params.getSignaturePackaging()));
            }
        }
    }

    protected void incorporateFiles() {
    }

    protected Document buildRootDocumentDom() {
        return DomUtils.buildDOM();
    }

    public void incorporateSignatureDom() {
        this.signatureDom = DomUtils.createElementNS((Document)this.documentDom, (DSSNamespace)this.getXmldsigNamespace(), (DSSElement)XMLDSigElement.SIGNATURE);
        DomUtils.addNamespaceAttribute((Element)this.signatureDom, (DSSNamespace)this.getXmldsigNamespace());
        this.signatureDom.setAttribute(XMLDSigAttribute.ID.getAttributeName(), this.deterministicId);
        Node parentNodeOfSignature = this.getParentNodeOfSignature();
        this.incorporateSignatureDom(parentNodeOfSignature);
    }

    protected Node getParentNodeOfSignature() {
        return this.documentDom;
    }

    protected void incorporateSignatureDom(Node parentNodeOfSignature) {
        parentNodeOfSignature.appendChild(this.signatureDom);
    }

    public void incorporateSignedInfo() {
        if (Utils.isArrayNotEmpty((byte[])this.params.getSignedData())) {
            LOG.debug("Using explicit SignedInfo from parameter");
            this.signedInfoDom = DomUtils.buildDOM((byte[])this.params.getSignedData()).getDocumentElement();
            this.signedInfoDom = (Element)this.documentDom.importNode(this.signedInfoDom, true);
            this.signatureDom.appendChild(this.signedInfoDom);
            return;
        }
        this.signedInfoDom = DomUtils.createElementNS((Document)this.documentDom, (DSSNamespace)this.getXmldsigNamespace(), (DSSElement)XMLDSigElement.SIGNED_INFO);
        this.signatureDom.appendChild(this.signedInfoDom);
        this.incorporateCanonicalizationMethod(this.signedInfoDom, this.signedInfoCanonicalizationMethod);
        Element signatureMethod = DomUtils.createElementNS((Document)this.documentDom, (DSSNamespace)this.getXmldsigNamespace(), (DSSElement)XMLDSigElement.SIGNATURE_METHOD);
        this.signedInfoDom.appendChild(signatureMethod);
        EncryptionAlgorithm encryptionAlgorithm = this.params.getEncryptionAlgorithm();
        DigestAlgorithm digestAlgorithm = this.params.getDigestAlgorithm();
        MaskGenerationFunction mgf = this.params.getMaskGenerationFunction();
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.getAlgorithm((EncryptionAlgorithm)encryptionAlgorithm, (DigestAlgorithm)digestAlgorithm, (MaskGenerationFunction)mgf);
        String signatureAlgorithmXMLId = signatureAlgorithm.getUri();
        if (Utils.isStringBlank((String)signatureAlgorithmXMLId)) {
            throw new UnsupportedOperationException("Unsupported signature algorithm " + signatureAlgorithm);
        }
        signatureMethod.setAttribute(XMLDSigAttribute.ALGORITHM.getAttributeName(), signatureAlgorithmXMLId);
    }

    private void incorporateCanonicalizationMethod(Element parentDom, String signedInfoCanonicalizationMethod) {
        Element canonicalizationMethodDom = DomUtils.createElementNS((Document)this.documentDom, (DSSNamespace)this.getXmldsigNamespace(), (DSSElement)XMLDSigElement.CANONICALIZATION_METHOD);
        parentDom.appendChild(canonicalizationMethodDom);
        canonicalizationMethodDom.setAttribute(XMLDSigAttribute.ALGORITHM.getAttributeName(), signedInfoCanonicalizationMethod);
    }

    private void incorporateReferences() {
        ReferenceProcessor referenceProcessor = new ReferenceProcessor(this.params);
        referenceProcessor.incorporateReferences(this.signedInfoDom, this.params.getReferences(), this.getXmldsigNamespace());
    }

    protected void incorporateKeyInfo() throws DSSException {
        if (this.params.getSigningCertificate() == null && this.params.isGenerateTBSWithoutCertificate()) {
            LOG.debug("Signing certificate not available and must be added to signature DOM later");
            return;
        }
        Element keyInfoElement = DomUtils.createElementNS((Document)this.documentDom, (DSSNamespace)this.getXmldsigNamespace(), (DSSElement)XMLDSigElement.KEY_INFO);
        this.signatureDom.appendChild(keyInfoElement);
        if (this.params.isSignKeyInfo()) {
            keyInfoElement.setAttribute(XMLDSigAttribute.ID.getAttributeName(), KEYINFO_SUFFIX + this.deterministicId);
        }
        BaselineBCertificateSelector certSelector = new BaselineBCertificateSelector(this.certificateVerifier, (AbstractSignatureParameters)this.params);
        List certificates = certSelector.getCertificates();
        if (this.params.isAddX509SubjectName()) {
            for (CertificateToken token : certificates) {
                Element x509DataDom = DomUtils.createElementNS((Document)this.documentDom, (DSSNamespace)this.getXmldsigNamespace(), (DSSElement)XMLDSigElement.X509_DATA);
                keyInfoElement.appendChild(x509DataDom);
                this.addSubjectAndCertificate(x509DataDom, token);
            }
        } else {
            Element x509DataDom = DomUtils.createElementNS((Document)this.documentDom, (DSSNamespace)this.getXmldsigNamespace(), (DSSElement)XMLDSigElement.X509_DATA);
            keyInfoElement.appendChild(x509DataDom);
            for (CertificateToken token : certificates) {
                this.addCertificate(x509DataDom, token);
            }
        }
        this.keyInfoDom = keyInfoElement;
    }

    private void addSubjectAndCertificate(Element x509DataDom, CertificateToken token) {
        DomUtils.addTextElement((Document)this.documentDom, (Element)x509DataDom, (DSSNamespace)this.getXmldsigNamespace(), (DSSElement)XMLDSigElement.X509_SUBJECT_NAME, (String)token.getSubject().getRFC2253());
        this.addCertificate(x509DataDom, token);
    }

    private void addCertificate(Element x509DataDom, CertificateToken token) {
        DomUtils.addTextElement((Document)this.documentDom, (Element)x509DataDom, (DSSNamespace)this.getXmldsigNamespace(), (DSSElement)XMLDSigElement.X509_CERTIFICATE, (String)Utils.toBase64((byte[])token.getEncoded()));
    }

    protected void incorporateObjects() {
        this.incorporateQualifyingProperties();
        this.incorporateSignedObjects();
        this.incorporateCustomObjects();
    }

    protected void incorporateQualifyingProperties() {
        if (Utils.isArrayNotEmpty((byte[])this.params.getSignedAdESObject())) {
            LOG.debug("Incorporating signed XAdES Object from parameter");
            if (!DomUtils.isDOM((byte[])this.params.getSignedAdESObject())) {
                throw new IllegalArgumentException("The signed AdES Object shall represent an XML!");
            }
            Node signedObjectDom = DomUtils.buildDOM((byte[])this.params.getSignedAdESObject()).getDocumentElement();
            signedObjectDom = this.documentDom.importNode(signedObjectDom, true);
            this.signatureDom.appendChild(signedObjectDom);
            return;
        }
        Element objectDom = DomUtils.createElementNS((Document)this.documentDom, (DSSNamespace)this.getXmldsigNamespace(), (DSSElement)XMLDSigElement.OBJECT);
        this.signatureDom.appendChild(objectDom);
        this.qualifyingPropertiesDom = DomUtils.addElement((Document)this.documentDom, (Element)objectDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementQualifyingProperties());
        DomUtils.addNamespaceAttribute((Element)this.qualifyingPropertiesDom, (DSSNamespace)this.getXadesNamespace());
        this.qualifyingPropertiesDom.setAttribute("Target", DomUtils.toElementReference((String)this.deterministicId));
        this.incorporateSignedProperties();
    }

    protected void incorporateSignedObjects() {
        List<DSSReference> references = this.params.getReferences();
        for (DSSReference reference : references) {
            if (reference.getObject() == null) continue;
            this.incorporateObject(reference.getObject());
        }
    }

    protected void incorporateCustomObjects() {
        if (Utils.isCollectionNotEmpty(this.params.getObjects())) {
            for (DSSObject object : this.params.getObjects()) {
                this.incorporateObject(object);
            }
        }
    }

    protected void incorporateObject(DSSObject object) {
        Node objectContentDom;
        if (object.getContent() == null) {
            throw new IllegalArgumentException("The content shall be defined inside DSSObject element! Incorporation is not possible.");
        }
        Element objectDom = DomUtils.addElement((Document)this.documentDom, (Element)this.signatureDom, (DSSNamespace)this.getXmldsigNamespace(), (DSSElement)XMLDSigElement.OBJECT);
        if (DomUtils.isDOM((DSSDocument)object.getContent())) {
            objectContentDom = DomUtils.buildDOM((DSSDocument)object.getContent()).getDocumentElement();
            objectContentDom = this.documentDom.importNode(objectContentDom, true);
        } else {
            objectContentDom = this.documentDom.createTextNode(new String(DSSUtils.toByteArray((DSSDocument)object.getContent())));
        }
        objectDom.appendChild(objectContentDom);
        if (Utils.isStringNotBlank((String)object.getId())) {
            objectDom.setAttribute(XMLDSigAttribute.ID.getAttributeName(), object.getId());
        }
        if (object.getMimeType() != null) {
            objectDom.setAttribute(XMLDSigAttribute.MIME_TYPE.getAttributeName(), object.getMimeType().getMimeTypeString());
        }
        if (Utils.isStringNotBlank((String)object.getEncodingAlgorithm())) {
            objectDom.setAttribute(XMLDSigAttribute.ENCODING.getAttributeName(), object.getEncodingAlgorithm());
        }
    }

    protected void incorporateReferenceSignedProperties() {
        Element reference = DomUtils.createElementNS((Document)this.documentDom, (DSSNamespace)this.getXmldsigNamespace(), (DSSElement)XMLDSigElement.REFERENCE);
        this.signedInfoDom.appendChild(reference);
        reference.setAttribute(XMLDSigAttribute.TYPE.getAttributeName(), this.xadesPaths.getSignedPropertiesUri());
        reference.setAttribute(XMLDSigAttribute.URI.getAttributeName(), DomUtils.toElementReference((String)(XADES_SUFFIX + this.deterministicId)));
        Element transforms = DomUtils.createElementNS((Document)this.documentDom, (DSSNamespace)this.getXmldsigNamespace(), (DSSElement)XMLDSigElement.TRANSFORMS);
        reference.appendChild(transforms);
        Element transform = DomUtils.createElementNS((Document)this.documentDom, (DSSNamespace)this.getXmldsigNamespace(), (DSSElement)XMLDSigElement.TRANSFORM);
        transforms.appendChild(transform);
        transform.setAttribute(XMLDSigAttribute.ALGORITHM.getAttributeName(), this.signedPropertiesCanonicalizationMethod);
        DigestAlgorithm digestAlgorithm = this.getReferenceDigestAlgorithmOrDefault(this.params);
        DSSXMLUtils.incorporateDigestMethod(reference, digestAlgorithm, this.getXmldsigNamespace());
        byte[] canonicalizedBytes = DSSXMLUtils.canonicalizeSubtree(this.signedPropertiesCanonicalizationMethod, this.getNodeToCanonicalize(this.signedPropertiesDom));
        if (LOG.isTraceEnabled()) {
            LOG.trace("Canonicalization method  --> {}", (Object)this.signedPropertiesCanonicalizationMethod);
            LOG.trace("Canonicalized REF_2      --> {}", (Object)new String(canonicalizedBytes));
        }
        this.incorporateDigestValueOfReference(reference, digestAlgorithm, canonicalizedBytes);
    }

    protected void incorporateReferenceKeyInfo() {
        if (!this.params.isSignKeyInfo()) {
            return;
        }
        Element reference = DomUtils.createElementNS((Document)this.documentDom, (DSSNamespace)this.getXmldsigNamespace(), (DSSElement)XMLDSigElement.REFERENCE);
        this.signedInfoDom.appendChild(reference);
        reference.setAttribute(XMLDSigAttribute.URI.getAttributeName(), DomUtils.toElementReference((String)(KEYINFO_SUFFIX + this.deterministicId)));
        Element transforms = DomUtils.createElementNS((Document)this.documentDom, (DSSNamespace)this.getXmldsigNamespace(), (DSSElement)XMLDSigElement.TRANSFORMS);
        reference.appendChild(transforms);
        Element transform = DomUtils.createElementNS((Document)this.documentDom, (DSSNamespace)this.getXmldsigNamespace(), (DSSElement)XMLDSigElement.TRANSFORM);
        transforms.appendChild(transform);
        transform.setAttribute(XMLDSigAttribute.ALGORITHM.getAttributeName(), this.keyInfoCanonicalizationMethod);
        DigestAlgorithm digestAlgorithm = this.getReferenceDigestAlgorithmOrDefault(this.params);
        DSSXMLUtils.incorporateDigestMethod(reference, digestAlgorithm, this.getXmldsigNamespace());
        byte[] canonicalizedBytes = DSSXMLUtils.canonicalizeSubtree(this.keyInfoCanonicalizationMethod, this.getNodeToCanonicalize(this.keyInfoDom));
        if (LOG.isTraceEnabled()) {
            LOG.trace("Canonicalization method   --> {}", (Object)this.keyInfoCanonicalizationMethod);
            LOG.trace("Canonicalized REF_KeyInfo --> {}", (Object)new String(canonicalizedBytes));
        }
        this.incorporateDigestValueOfReference(reference, digestAlgorithm, canonicalizedBytes);
    }

    private void incorporateDigestValueOfReference(Element referenceDom, DigestAlgorithm digestAlgorithm, byte[] canonicalizedBytes) {
        Element digestValueDom = DomUtils.createElementNS((Document)this.documentDom, (DSSNamespace)this.getXmldsigNamespace(), (DSSElement)XMLDSigElement.DIGEST_VALUE);
        String base64EncodedDigestBytes = Utils.toBase64((byte[])DSSUtils.digest((DigestAlgorithm)digestAlgorithm, (byte[])canonicalizedBytes));
        Text textNode = this.documentDom.createTextNode(base64EncodedDigestBytes);
        digestValueDom.appendChild(textNode);
        referenceDom.appendChild(digestValueDom);
    }

    protected void incorporateSignatureValue() {
        this.signatureValueDom = DomUtils.createElementNS((Document)this.documentDom, (DSSNamespace)this.getXmldsigNamespace(), (DSSElement)XMLDSigElement.SIGNATURE_VALUE);
        this.signatureDom.appendChild(this.signatureValueDom);
        this.signatureValueDom.setAttribute(XMLDSigAttribute.ID.getAttributeName(), VALUE_SUFFIX + this.deterministicId);
    }

    protected void incorporateSignedProperties() {
        this.signedPropertiesDom = DomUtils.addElement((Document)this.documentDom, (Element)this.qualifyingPropertiesDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementSignedProperties());
        this.signedPropertiesDom.setAttribute(XMLDSigAttribute.ID.getAttributeName(), XADES_SUFFIX + this.deterministicId);
        this.incorporateSignedSignatureProperties();
        this.incorporateSignedDataObjectProperties();
    }

    protected void incorporateSignedSignatureProperties() {
        this.signedSignaturePropertiesDom = DomUtils.addElement((Document)this.documentDom, (Element)this.signedPropertiesDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementSignedSignatureProperties());
        this.incorporateSigningTime();
        this.incorporateSigningCertificate();
        this.incorporatePolicy();
        this.incorporateSignatureProductionPlace();
        this.incorporateSignerRole();
    }

    private void incorporatePolicy() {
        Policy signaturePolicy = this.params.bLevel().getSignaturePolicy();
        if (signaturePolicy != null) {
            Element signaturePolicyIdentifierDom = DomUtils.addElement((Document)this.documentDom, (Element)this.signedSignaturePropertiesDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementSignaturePolicyIdentifier());
            String signaturePolicyId = signaturePolicy.getId();
            if (Utils.isStringEmpty((String)signaturePolicyId)) {
                DomUtils.addElement((Document)this.documentDom, (Element)signaturePolicyIdentifierDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementSignaturePolicyImplied());
            } else {
                Object[] documentationReferences;
                String description;
                Element signaturePolicyIdDom = DomUtils.addElement((Document)this.documentDom, (Element)signaturePolicyIdentifierDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementSignaturePolicyId());
                Element sigPolicyIdDom = DomUtils.addElement((Document)this.documentDom, (Element)signaturePolicyIdDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementSigPolicyId());
                Element identifierDom = DomUtils.addTextElement((Document)this.documentDom, (Element)sigPolicyIdDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementIdentifier(), (String)signaturePolicyId);
                ObjectIdentifierQualifier qualifier = signaturePolicy.getQualifier();
                if (qualifier != null) {
                    identifierDom.setAttribute(XAdES132Attribute.QUALIFIER.getAttributeName(), qualifier.getValue());
                }
                if (Utils.isStringNotEmpty((String)(description = signaturePolicy.getDescription()))) {
                    DomUtils.addTextElement((Document)this.documentDom, (Element)sigPolicyIdDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementDescription(), (String)description);
                }
                if (Utils.isArrayNotEmpty((Object[])(documentationReferences = signaturePolicy.getDocumentationReferences()))) {
                    this.incorporateDocumentationReferences(sigPolicyIdDom, (String[])documentationReferences);
                }
                if (signaturePolicy instanceof XmlPolicyWithTransforms) {
                    XmlPolicyWithTransforms xmlPolicy = (XmlPolicyWithTransforms)signaturePolicy;
                    DSSXMLUtils.incorporateTransforms(signaturePolicyIdDom, xmlPolicy.getTransforms(), this.getXmldsigNamespace());
                }
                if (signaturePolicy.getDigestAlgorithm() != null && signaturePolicy.getDigestValue() != null) {
                    Element sigPolicyHashDom = DomUtils.addElement((Document)this.documentDom, (Element)signaturePolicyIdDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementSigPolicyHash());
                    DigestAlgorithm digestAlgorithm = signaturePolicy.getDigestAlgorithm();
                    this.incorporateDigestMethod(sigPolicyHashDom, digestAlgorithm);
                    byte[] hashValue = signaturePolicy.getDigestValue();
                    String base64EncodedHashValue = Utils.toBase64((byte[])hashValue);
                    this.incorporateDigestValue(sigPolicyHashDom, base64EncodedHashValue);
                }
                if (signaturePolicy.isSPQualifierPresent()) {
                    this.incorporateSigPolicyQualifiers(signaturePolicyIdDom, signaturePolicy);
                }
            }
        }
    }

    private void incorporateSigPolicyQualifiers(Element signaturePolicyIdDom, Policy signaturePolicy) {
        SpDocSpecification spDocSpecification;
        UserNotice userNotice;
        Element sigPolicyQualifiers = DomUtils.addElement((Document)this.documentDom, (Element)signaturePolicyIdDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementSigPolicyQualifiers());
        String spUri = signaturePolicy.getSpuri();
        if (Utils.isStringNotEmpty((String)spUri)) {
            Element sigPolicyQualifier = DomUtils.addElement((Document)this.documentDom, (Element)sigPolicyQualifiers, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementSigPolicyQualifier());
            DomUtils.addTextElement((Document)this.documentDom, (Element)sigPolicyQualifier, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementSPURI(), (String)spUri);
        }
        if ((userNotice = signaturePolicy.getUserNotice()) != null && !userNotice.isEmpty()) {
            String explicitText;
            DSSUtils.assertSPUserNoticeConfigurationValid((UserNotice)userNotice);
            Element sigPolicyQualifier = DomUtils.addElement((Document)this.documentDom, (Element)sigPolicyQualifiers, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementSigPolicyQualifier());
            Element spUserNotice = DomUtils.addElement((Document)this.documentDom, (Element)sigPolicyQualifier, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementSPUserNotice());
            String organization = userNotice.getOrganization();
            int[] noticeNumbers = userNotice.getNoticeNumbers();
            if (Utils.isStringNotEmpty((String)organization) && noticeNumbers != null && noticeNumbers.length > 0) {
                Element noticeRef = DomUtils.addElement((Document)this.documentDom, (Element)spUserNotice, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementNoticeRef());
                DomUtils.addTextElement((Document)this.documentDom, (Element)noticeRef, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementOrganization(), (String)organization);
                Element noticeNumbersElement = DomUtils.addElement((Document)this.documentDom, (Element)noticeRef, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementNoticeNumbers());
                for (int number : noticeNumbers) {
                    DomUtils.addTextElement((Document)this.documentDom, (Element)noticeNumbersElement, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementint(), (String)String.valueOf(number));
                }
            }
            if (Utils.isStringNotEmpty((String)(explicitText = userNotice.getExplicitText()))) {
                DomUtils.addTextElement((Document)this.documentDom, (Element)spUserNotice, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementExplicitText(), (String)explicitText);
            }
        }
        if ((spDocSpecification = signaturePolicy.getSpDocSpecification()) != null && Utils.isStringNotEmpty((String)spDocSpecification.getId())) {
            Element sigPolicyQualifier = DomUtils.addElement((Document)this.documentDom, (Element)sigPolicyQualifiers, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementSigPolicyQualifier());
            this.incorporateSPDocSpecification(sigPolicyQualifier, spDocSpecification);
        }
    }

    private void incorporateSigningTime() {
        Date signingDate = this.params.bLevel().getSigningDate();
        XMLGregorianCalendar xmlGregorianCalendar = DomUtils.createXMLGregorianCalendar((Date)signingDate);
        String xmlSigningTime = xmlGregorianCalendar.toXMLFormat();
        Element signingTimeDom = DomUtils.createElementNS((Document)this.documentDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementSigningTime());
        this.signedSignaturePropertiesDom.appendChild(signingTimeDom);
        Text textNode = this.documentDom.createTextNode(xmlSigningTime);
        signingTimeDom.appendChild(textNode);
    }

    private void incorporateSigningCertificate() {
        if (this.params.getSigningCertificate() == null && this.params.isGenerateTBSWithoutCertificate()) {
            return;
        }
        HashSet<CertificateToken> certificates = new HashSet<CertificateToken>();
        certificates.add(this.params.getSigningCertificate());
        if (this.params.isEn319132()) {
            this.incorporateSigningCertificateV2(certificates);
        } else {
            this.incorporateSigningCertificateV1(certificates);
        }
    }

    private void incorporateSigningCertificateV1(Set<CertificateToken> certificates) {
        Element signingCertificateDom = DomUtils.addElement((Document)this.documentDom, (Element)this.signedSignaturePropertiesDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementSigningCertificate());
        DigestAlgorithm signingCertificateDigestMethod = this.params.getSigningCertificateDigestMethod();
        for (CertificateToken certificate : certificates) {
            this.incorporateCert(signingCertificateDom, certificate, signingCertificateDigestMethod);
        }
    }

    private void incorporateSigningCertificateV2(Set<CertificateToken> certificates) {
        Element signingCertificateDom = DomUtils.addElement((Document)this.documentDom, (Element)this.signedSignaturePropertiesDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementSigningCertificateV2());
        DigestAlgorithm signingCertificateDigestMethod = this.params.getSigningCertificateDigestMethod();
        for (CertificateToken certificate : certificates) {
            this.incorporateCert(signingCertificateDom, certificate, signingCertificateDigestMethod);
        }
    }

    private void incorporateSignedDataObjectProperties() {
        this.incorporateDataObjectFormat();
        this.incorporateCommitmentTypeIndications();
        this.incorporateContentTimestamps();
    }

    private Element getSignedDataObjectPropertiesDom() {
        if (this.signedDataObjectPropertiesDom == null) {
            this.signedDataObjectPropertiesDom = DomUtils.addElement((Document)this.documentDom, (Element)this.signedPropertiesDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementSignedDataObjectProperties());
        }
        return this.signedDataObjectPropertiesDom;
    }

    private void incorporateDataObjectFormat() {
        List<DSSReference> references = this.params.getReferences();
        for (DSSReference reference : references) {
            if (this.xadesPaths.getCounterSignatureUri().equals(reference.getType())) continue;
            String dataObjectFormatObjectReference = DomUtils.toElementReference((String)reference.getId());
            Element dataObjectFormatDom = DomUtils.addElement((Document)this.documentDom, (Element)this.getSignedDataObjectPropertiesDom(), (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementDataObjectFormat());
            dataObjectFormatDom.setAttribute(XAdES132Attribute.OBJECT_REFERENCE.getAttributeName(), dataObjectFormatObjectReference);
            Element mimeTypeDom = DomUtils.addElement((Document)this.documentDom, (Element)dataObjectFormatDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementMimeType());
            MimeType dataObjectFormatMimeType = this.getReferenceMimeType(reference);
            DomUtils.setTextNode((Document)this.documentDom, (Element)mimeTypeDom, (String)dataObjectFormatMimeType.getMimeTypeString());
        }
    }

    private MimeType getReferenceMimeType(DSSReference reference) {
        MimeType dataObjectFormatMimeType = MimeType.BINARY;
        DSSDocument content = reference.getContents();
        if (content != null && content.getMimeType() != null) {
            dataObjectFormatMimeType = content.getMimeType();
        }
        return dataObjectFormatMimeType;
    }

    private void incorporateContentTimestamps() {
        List contentTimestamps = this.params.getContentTimestamps();
        if (contentTimestamps == null) {
            return;
        }
        for (TimestampToken contentTimestamp : contentTimestamps) {
            String timestampId = TIMESTAMP_SUFFIX + contentTimestamp.getDSSIdAsString();
            TimestampType timeStampType = contentTimestamp.getTimeStampType();
            if (TimestampType.ALL_DATA_OBJECTS_TIMESTAMP.equals((Object)timeStampType)) {
                Element allDataObjectsTimestampDom = DomUtils.addElement((Document)this.documentDom, (Element)this.getSignedDataObjectPropertiesDom(), (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementAllDataObjectsTimeStamp());
                allDataObjectsTimestampDom.setAttribute(XMLDSigAttribute.ID.getAttributeName(), timestampId);
                this.addTimestamp(allDataObjectsTimestampDom, contentTimestamp);
                continue;
            }
            if (TimestampType.INDIVIDUAL_DATA_OBJECTS_TIMESTAMP.equals((Object)timeStampType)) {
                Element individualDataObjectsTimestampDom = DomUtils.addElement((Document)this.documentDom, (Element)this.getSignedDataObjectPropertiesDom(), (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementIndividualDataObjectsTimeStamp());
                individualDataObjectsTimestampDom.setAttribute(XMLDSigAttribute.ID.getAttributeName(), timestampId);
                this.addTimestamp(individualDataObjectsTimestampDom, contentTimestamp);
                continue;
            }
            throw new UnsupportedOperationException("Only types ALL_DATA_OBJECTS_TIMESTAMP and INDIVIDUAL_DATA_OBJECTS_TIMESTAMP are allowed");
        }
    }

    private void incorporateSignerRole() {
        List claimedSignerRoles = this.params.bLevel().getClaimedSignerRoles();
        List signedAssertions = this.params.bLevel().getSignedAssertions();
        Element signerRoleDom = null;
        if (claimedSignerRoles != null) {
            signerRoleDom = this.params.isEn319132() ? DomUtils.addElement((Document)this.documentDom, (Element)this.signedSignaturePropertiesDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementSignerRoleV2()) : DomUtils.addElement((Document)this.documentDom, (Element)this.signedSignaturePropertiesDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementSignerRole());
            if (Utils.isCollectionNotEmpty((Collection)claimedSignerRoles)) {
                Element claimedRolesDom = DomUtils.addElement((Document)this.documentDom, (Element)signerRoleDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementClaimedRoles());
                this.addRoles(claimedSignerRoles, claimedRolesDom, this.getCurrentXAdESElements().getElementClaimedRole());
            }
        }
        if (signedAssertions != null && this.params.isEn319132()) {
            if (signerRoleDom == null) {
                signerRoleDom = DomUtils.addElement((Document)this.documentDom, (Element)this.signedSignaturePropertiesDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementSignerRoleV2());
            }
            if (Utils.isCollectionNotEmpty((Collection)signedAssertions)) {
                Element signedAssertionsDom = DomUtils.addElement((Document)this.documentDom, (Element)signerRoleDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementSignedAssertions());
                this.addAssertions(signedAssertions, signedAssertionsDom);
            }
        }
    }

    private void addRoles(List<String> signerRoles, Element rolesDom, DSSElement roleType) {
        for (String signerRole : signerRoles) {
            Element roleDom = DomUtils.addElement((Document)this.documentDom, (Element)rolesDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)roleType);
            DomUtils.setTextNode((Document)this.documentDom, (Element)roleDom, (String)signerRole);
        }
    }

    private void incorporateSignatureProductionPlace() {
        SignerLocation signatureProductionPlace = this.params.bLevel().getSignerLocation();
        if (signatureProductionPlace != null && !signatureProductionPlace.isEmpty()) {
            String country;
            String postalCode;
            String stateOrProvince;
            String streetAddress;
            Element signatureProductionPlaceDom = this.params.isEn319132() ? DomUtils.addElement((Document)this.documentDom, (Element)this.signedSignaturePropertiesDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementSignatureProductionPlaceV2()) : DomUtils.addElement((Document)this.documentDom, (Element)this.signedSignaturePropertiesDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementSignatureProductionPlace());
            String city = signatureProductionPlace.getLocality();
            if (city != null) {
                DomUtils.addTextElement((Document)this.documentDom, (Element)signatureProductionPlaceDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementCity(), (String)city);
            }
            if (this.params.isEn319132() && (streetAddress = signatureProductionPlace.getStreetAddress()) != null) {
                DomUtils.addTextElement((Document)this.documentDom, (Element)signatureProductionPlaceDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementStreetAddress(), (String)streetAddress);
            }
            if ((stateOrProvince = signatureProductionPlace.getStateOrProvince()) != null) {
                DomUtils.addTextElement((Document)this.documentDom, (Element)signatureProductionPlaceDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementStateOrProvince(), (String)stateOrProvince);
            }
            if ((postalCode = signatureProductionPlace.getPostalCode()) != null) {
                DomUtils.addTextElement((Document)this.documentDom, (Element)signatureProductionPlaceDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementPostalCode(), (String)postalCode);
            }
            if ((country = signatureProductionPlace.getCountry()) != null) {
                DomUtils.addTextElement((Document)this.documentDom, (Element)signatureProductionPlaceDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementCountryName(), (String)country);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void incorporateCommitmentTypeIndications() {
        List commitmentTypeIndications = this.params.bLevel().getCommitmentTypeIndications();
        if (Utils.isCollectionNotEmpty((Collection)commitmentTypeIndications)) {
            for (CommitmentType commitmentTypeIndication : commitmentTypeIndications) {
                void var17_21;
                Object[] documentationReferences;
                String description;
                Element commitmentTypeIndicationDom = DomUtils.addElement((Document)this.documentDom, (Element)this.getSignedDataObjectPropertiesDom(), (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementCommitmentTypeIndication());
                Element commitmentTypeIdDom = DomUtils.addElement((Document)this.documentDom, (Element)commitmentTypeIndicationDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementCommitmentTypeId());
                String uri = commitmentTypeIndication.getUri();
                String oid = commitmentTypeIndication.getOid();
                ObjectIdentifierQualifier qualifier = commitmentTypeIndication.getQualifier();
                if (Utils.isStringEmpty((String)uri)) {
                    if (Utils.isStringEmpty((String)oid)) {
                        throw new IllegalArgumentException("The URI or OID must be defined for commitmentTypeIndication for XAdES creation!");
                    }
                    if (qualifier == null) {
                        throw new IllegalArgumentException("When using OID as object identifier in XAdES, a Qualifier shall be provided! See EN 319 132-1 for more details.");
                    }
                    switch (qualifier) {
                        case OID_AS_URI: {
                            if (!DSSUtils.isUrnOid((String)oid)) break;
                            throw new IllegalArgumentException(String.format("Qualifier '%s' shall not be used for URN encoded OID! See EN 319 132-1 for more details.", qualifier));
                        }
                        case OID_AS_URN: {
                            if (DSSUtils.isUrnOid((String)oid)) break;
                            oid = DSSUtils.toUrnOid((String)oid);
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException(String.format("The Qualifier '%s' is not supported!", qualifier));
                        }
                    }
                    uri = oid;
                } else if (qualifier != null) {
                    throw new IllegalArgumentException("When using URI as object identifier in XAdES, a Qualifier shall not be present! See EN 319 132-1 for more details.");
                }
                Element identifierDom = DomUtils.addTextElement((Document)this.documentDom, (Element)commitmentTypeIdDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementIdentifier(), (String)uri);
                if (qualifier != null) {
                    identifierDom.setAttribute(XAdES132Attribute.QUALIFIER.getAttributeName(), qualifier.getValue());
                }
                if ((description = commitmentTypeIndication.getDescription()) != null) {
                    DomUtils.addTextElement((Document)this.documentDom, (Element)commitmentTypeIdDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementDescription(), (String)description);
                }
                if (Utils.isArrayNotEmpty((Object[])(documentationReferences = commitmentTypeIndication.getDocumentationReferences()))) {
                    this.incorporateDocumentationReferences(commitmentTypeIdDom, (String[])documentationReferences);
                }
                String[] signedDataObjects = null;
                Object[] commitmentTypeQualifiers = null;
                if (commitmentTypeIndication instanceof CommonCommitmentType) {
                    CommonCommitmentType commonCommitmentType = (CommonCommitmentType)commitmentTypeIndication;
                    signedDataObjects = commonCommitmentType.getSignedDataObjects();
                    commitmentTypeQualifiers = commonCommitmentType.getCommitmentTypeQualifiers();
                }
                if (Utils.isArrayNotEmpty(signedDataObjects)) {
                    for (CommonCommitmentType commonCommitmentType : signedDataObjects) {
                        if (Utils.isStringBlank((String)commonCommitmentType)) {
                            throw new IllegalArgumentException("SignedDataObject URI cannot be null!");
                        }
                        String string = DomUtils.toElementReference((String)commonCommitmentType);
                        DomUtils.addTextElement((Document)this.documentDom, (Element)commitmentTypeIndicationDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementObjectReference(), (String)string);
                    }
                } else {
                    DomUtils.addElement((Document)this.documentDom, (Element)commitmentTypeIndicationDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementAllSignedDataObjects());
                }
                if (!Utils.isArrayNotEmpty((Object[])commitmentTypeQualifiers)) continue;
                Element commitmentTypeQualifiersElement = DomUtils.addElement((Document)this.documentDom, (Element)commitmentTypeIndicationDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementCommitmentTypeQualifiers());
                Object[] objectArray = commitmentTypeQualifiers;
                int n = objectArray.length;
                boolean bl = false;
                while (var17_21 < n) {
                    Node objectContentDom;
                    Object commitmentQualifier = objectArray[var17_21];
                    Objects.requireNonNull(commitmentQualifier, "CommitmentTypeQualifier cannot be null!");
                    DSSDocument content = commitmentQualifier.getContent();
                    if (content == null) {
                        throw new IllegalArgumentException("CommitmentTypeQualifier content cannot be null!");
                    }
                    Element commitmentTypeQualifierElement = DomUtils.addElement((Document)this.documentDom, (Element)commitmentTypeQualifiersElement, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementCommitmentTypeQualifier());
                    if (DomUtils.isDOM((DSSDocument)content)) {
                        objectContentDom = DomUtils.buildDOM((DSSDocument)content).getDocumentElement();
                        objectContentDom = this.documentDom.importNode(objectContentDom, true);
                    } else {
                        LOG.info("None XML encoded CommitmentTypeQualifier has been provided. Incorporate as text node.");
                        objectContentDom = this.documentDom.createTextNode(new String(DSSUtils.toByteArray((DSSDocument)content)));
                    }
                    commitmentTypeQualifierElement.appendChild(objectContentDom);
                    ++var17_21;
                }
            }
        }
    }

    private void incorporateDocumentationReferences(Element parentElement, String[] documentationReferences) {
        Element documentReferencesDom = DomUtils.addElement((Document)this.documentDom, (Element)parentElement, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementDocumentationReferences());
        for (String ref : documentationReferences) {
            DomUtils.addTextElement((Document)this.documentDom, (Element)documentReferencesDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementDocumentationReference(), (String)ref);
        }
    }

    @Override
    public DSSDocument signDocument(byte[] signatureValue) {
        if (!this.built) {
            this.build();
        }
        EncryptionAlgorithm encryptionAlgorithm = this.params.getEncryptionAlgorithm();
        byte[] signatureValueBytes = DSSASN1Utils.ensurePlainSignatureValue((EncryptionAlgorithm)encryptionAlgorithm, (byte[])signatureValue);
        String signatureValueBase64Encoded = Utils.toBase64((byte[])signatureValueBytes);
        Text signatureValueNode = this.documentDom.createTextNode(signatureValueBase64Encoded);
        this.signatureValueDom.appendChild(signatureValueNode);
        return this.createXmlDocument();
    }

    protected void addTimestamp(Element timestampElement, TimestampToken token) {
        String canonicalizationMethod;
        List includes = token.getTimestampIncludes();
        if (includes != null) {
            for (TimestampInclude include : includes) {
                Element timestampIncludeElement = DomUtils.createElementNS((Document)this.documentDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementInclude());
                String uri = DomUtils.toElementReference((String)include.getURI());
                timestampIncludeElement.setAttribute("URI", uri);
                timestampIncludeElement.setAttribute("referencedData", "true");
                timestampElement.appendChild(timestampIncludeElement);
            }
        }
        if (!Utils.isStringNotEmpty((String)(canonicalizationMethod = token.getCanonicalizationMethod()))) {
            throw new IllegalArgumentException("Unable to create a timestamp with empty canonicalization method. See EN 319 132-1: 4.5 Managing canonicalization of XML nodesets.");
        }
        Element canonicalizationMethodElement = DomUtils.createElementNS((Document)this.documentDom, (DSSNamespace)this.getXmldsigNamespace(), (DSSElement)XMLDSigElement.CANONICALIZATION_METHOD);
        canonicalizationMethodElement.setAttribute(XMLDSigAttribute.ALGORITHM.getAttributeName(), canonicalizationMethod);
        timestampElement.appendChild(canonicalizationMethodElement);
        Element encapsulatedTimestampElement = DomUtils.createElementNS((Document)this.documentDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementEncapsulatedTimeStamp());
        encapsulatedTimestampElement.setTextContent(Utils.toBase64((byte[])token.getEncoded()));
        timestampElement.appendChild(encapsulatedTimestampElement);
    }

    protected Node getNodeToCanonicalize(Node node) {
        if (this.params.isPrettyPrint()) {
            return DSSXMLUtils.getIndentedNode(this.documentDom, node);
        }
        return node;
    }

    @Override
    protected void alignNodes() {
        if (this.unsignedSignaturePropertiesDom != null) {
            DSSXMLUtils.alignChildrenIndents(this.unsignedSignaturePropertiesDom);
        }
        if (this.qualifyingPropertiesDom != null) {
            DSSXMLUtils.alignChildrenIndents(this.qualifyingPropertiesDom);
        }
    }

    private void addAssertions(List<String> signedAssertions, Element rolesDom) {
        for (String signedAssertion : signedAssertions) {
            Element roleDom = DomUtils.addElement((Document)this.documentDom, (Element)rolesDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementSignedAssertion());
            Document samlAssertion = DomUtils.buildDOM((String)signedAssertion);
            Element docEl = samlAssertion.getDocumentElement();
            Node node = this.documentDom.importNode(docEl, true);
            roleDom.appendChild(node);
        }
    }
}

