/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.MimeType;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import java.util.List;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.resolver.ResourceResolverContext;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.w3c.dom.Attr;

public class DetachedSignatureResolver
extends ResourceResolverSpi {
    private final List<DSSDocument> documents;
    private final DigestAlgorithm digestAlgorithm;

    public DetachedSignatureResolver(List<DSSDocument> documents, DigestAlgorithm digestAlgorithm) {
        this.documents = documents;
        this.digestAlgorithm = digestAlgorithm;
    }

    public XMLSignatureInput engineResolveURI(ResourceResolverContext context) throws ResourceResolverException {
        DSSDocument document = this.getCurrentDocument(context);
        if (document instanceof DigestDocument) {
            DigestDocument digestDoc = (DigestDocument)document;
            return new XMLSignatureInput(digestDoc.getDigest(this.digestAlgorithm));
        }
        return this.createFromCommonDocument(document);
    }

    private XMLSignatureInput createFromCommonDocument(DSSDocument document) {
        XMLSignatureInput result = new XMLSignatureInput(DSSUtils.toByteArray((DSSDocument)document));
        MimeType mimeType = document.getMimeType();
        if (mimeType != null) {
            result.setMIMEType(mimeType.getMimeTypeString());
        }
        return result;
    }

    private DSSDocument getCurrentDocument(ResourceResolverContext context) throws ResourceResolverException {
        if (this.definedFilename(context) && this.isDocumentNamesDefined()) {
            Attr uriAttr = context.attr;
            String uriValue = DSSUtils.decodeURI((String)uriAttr.getNodeValue());
            for (DSSDocument dssDocument : this.documents) {
                if (!Utils.areStringsEqual((String)dssDocument.getName(), (String)uriValue)) continue;
                return dssDocument;
            }
            Object[] exArgs = new Object[]{"Unable to find document '" + uriValue + "' (detached signature)"};
            throw new ResourceResolverException("generic.EmptyMessage", exArgs, uriValue, context.baseUri);
        }
        if (Utils.collectionSize(this.documents) == 1) {
            return this.documents.get(0);
        }
        Object[] exArgs = new Object[]{"Unable to find document (detached signature)"};
        throw new ResourceResolverException("generic.EmptyMessage", exArgs, null, context.baseUri);
    }

    public boolean engineCanResolveURI(ResourceResolverContext context) {
        return this.nullURI(context) || this.definedFilename(context);
    }

    private boolean nullURI(ResourceResolverContext context) {
        return context.attr == null;
    }

    private boolean definedFilename(ResourceResolverContext context) {
        Attr uriAttr = context.attr;
        return uriAttr != null && Utils.isStringNotBlank((String)uriAttr.getNodeValue()) && !DomUtils.startsFromHash((String)uriAttr.getNodeValue());
    }

    private boolean isDocumentNamesDefined() {
        if (Utils.isCollectionNotEmpty(this.documents)) {
            for (DSSDocument dssDocument : this.documents) {
                if (dssDocument.getName() == null) continue;
                return true;
            }
        }
        return false;
    }
}

