/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigAttribute;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigPaths;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.SignatureAttribute;
import eu.europa.esig.dss.validation.timestamp.TimestampInclude;
import eu.europa.esig.dss.xades.definition.XAdESPaths;
import eu.europa.esig.dss.xades.definition.xades111.XAdES111Paths;
import eu.europa.esig.dss.xades.definition.xades132.XAdES132Attribute;
import eu.europa.esig.dss.xades.validation.XAdESAttributeIdentifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XAdESAttribute
implements SignatureAttribute {
    private static final long serialVersionUID = 7860166312054634028L;
    private static final Logger LOG = LoggerFactory.getLogger(XAdESAttribute.class);
    private final Element element;
    private final XAdESPaths xadesPaths;
    private String localName;
    private XAdESAttributeIdentifier identifier;

    XAdESAttribute(Element element, XAdESPaths xadesPaths) {
        this.element = element;
        this.xadesPaths = xadesPaths;
    }

    public String getName() {
        if (this.localName == null) {
            this.localName = this.element.getLocalName();
        }
        return this.localName;
    }

    public final Element getElement() {
        return this.element;
    }

    public String getNamespace() {
        return this.element.getNamespaceURI();
    }

    public final Element findElement(String xPathExpression) {
        return DomUtils.getElement((Node)this.element, (String)xPathExpression);
    }

    public final NodeList getNodeList(String xPathExpression) {
        return DomUtils.getNodeList((Node)this.element, (String)xPathExpression);
    }

    public String getTimestampCanonicalizationMethod() {
        String canonicalizationMethod = DomUtils.getValue((Node)this.element, (String)XMLDSigPaths.CANONICALIZATION_ALGORITHM_PATH);
        if (Utils.isStringEmpty((String)canonicalizationMethod)) {
            NodeList nodeList = DomUtils.getNodeList((Node)this.element, (String)XAdES111Paths.HASH_DATA_INFO_TRANSFORM_PATH);
            if (nodeList != null && nodeList.getLength() == 1) {
                Element transform = (Element)nodeList.item(0);
                canonicalizationMethod = transform.getAttribute(XMLDSigAttribute.ALGORITHM.getAttributeName());
            } else {
                LOG.warn("Unable to retrieve the canonicalization algorithm");
            }
        }
        return canonicalizationMethod;
    }

    public List<TimestampInclude> getTimestampIncludedReferences() {
        NodeList timestampIncludes;
        String currentIncludePath = this.xadesPaths.getCurrentInclude();
        if (currentIncludePath != null && (timestampIncludes = DomUtils.getNodeList((Node)this.element, (String)currentIncludePath)) != null && timestampIncludes.getLength() > 0) {
            ArrayList<TimestampInclude> includes = new ArrayList<TimestampInclude>();
            for (int jj = 0; jj < timestampIncludes.getLength(); ++jj) {
                Element include = (Element)timestampIncludes.item(jj);
                String uri = DomUtils.getId((String)include.getAttribute(XAdES132Attribute.URI.getAttributeName()));
                String referencedData = include.getAttribute(XAdES132Attribute.REFERENCED_DATA.getAttributeName());
                includes.add(new TimestampInclude(uri, Boolean.parseBoolean(referencedData)));
            }
            return includes;
        }
        return null;
    }

    public XAdESAttributeIdentifier getIdentifier() {
        if (this.identifier == null) {
            this.identifier = XAdESAttributeIdentifier.build(this.element);
        }
        return this.identifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XAdESAttribute that = (XAdESAttribute)o;
        return Objects.equals((Object)this.getIdentifier(), (Object)that.getIdentifier());
    }

    public int hashCode() {
        return this.identifier != null ? this.identifier.hashCode() : 0;
    }

    public String toString() {
        return this.getName();
    }
}

