/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.ResourceLoader;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.SantuarioInitializer;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.xml.security.c14n.Canonicalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class DSSXMLUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DSSXMLUtils.class);
    public static final String ID_ATTRIBUTE_NAME = "id";
    public static final String XAD_ESV141_XSD = "/XAdESv141.xsd";
    private static final Set<String> transforms;
    private static final Set<String> canonicalizers;
    private static Schema schema;

    private static void registerDefaultTransforms() {
        DSSXMLUtils.registerTransform("http://www.w3.org/2000/09/xmldsig#base64");
        DSSXMLUtils.registerTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        DSSXMLUtils.registerTransform("http://www.w3.org/TR/1999/REC-xpath-19991116");
        DSSXMLUtils.registerTransform("http://www.w3.org/2002/06/xmldsig-filter2");
        DSSXMLUtils.registerTransform("http://www.w3.org/TR/2001/WD-xptr-20010108");
        DSSXMLUtils.registerTransform("http://www.w3.org/TR/1999/REC-xslt-19991116");
    }

    private static void registerDefaultCanonicalizers() {
        DSSXMLUtils.registerCanonicalizer("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        DSSXMLUtils.registerCanonicalizer("http://www.w3.org/2001/10/xml-exc-c14n#");
        DSSXMLUtils.registerCanonicalizer("http://www.w3.org/2006/12/xml-c14n11");
        DSSXMLUtils.registerCanonicalizer("http://santuario.apache.org/c14n/physical");
        DSSXMLUtils.registerCanonicalizer("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        DSSXMLUtils.registerCanonicalizer("http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        DSSXMLUtils.registerCanonicalizer("http://www.w3.org/2006/12/xml-c14n11#WithComments");
    }

    private DSSXMLUtils() {
    }

    public static boolean registerTransform(String transformURI) {
        boolean added = transforms.add(transformURI);
        return added;
    }

    public static boolean registerCanonicalizer(String c14nAlgorithmURI) {
        boolean added = canonicalizers.add(c14nAlgorithmURI);
        return added;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] serializeNode(Node xmlNode) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            String xmlEncoding;
            Transformer transformer = DomUtils.getSecureTransformer();
            Document document = null;
            document = 9 == xmlNode.getNodeType() ? (Document)xmlNode : xmlNode.getOwnerDocument();
            if (document != null && Utils.isStringNotBlank((String)(xmlEncoding = document.getXmlEncoding()))) {
                transformer.setOutputProperty("encoding", xmlEncoding);
            }
            StreamResult result = new StreamResult(bos);
            DOMSource source = new DOMSource(xmlNode);
            transformer.transform(source, result);
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new DSSException((Throwable)e);
        }
    }

    public static boolean canCanonicalize(String canonicalizationMethod) {
        if (transforms.contains(canonicalizationMethod)) {
            return false;
        }
        boolean contains = canonicalizers.contains(canonicalizationMethod);
        return contains;
    }

    public static byte[] canonicalize(String canonicalizationMethod, byte[] toCanonicalizeBytes) throws DSSException {
        try {
            Canonicalizer c14n = Canonicalizer.getInstance((String)canonicalizationMethod);
            return c14n.canonicalize(toCanonicalizeBytes);
        }
        catch (Exception e) {
            throw new DSSException((Throwable)e);
        }
    }

    public static byte[] canonicalizeSubtree(String canonicalizationMethod, Node node) {
        try {
            Canonicalizer c14n = Canonicalizer.getInstance((String)canonicalizationMethod);
            byte[] canonicalized = c14n.canonicalizeSubtree(node);
            return canonicalized;
        }
        catch (Exception e) {
            throw new DSSException((Throwable)e);
        }
    }

    public static void recursiveIdBrowse(Element element) {
        for (int ii = 0; ii < element.getChildNodes().getLength(); ++ii) {
            Node node = element.getChildNodes().item(ii);
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            DSSXMLUtils.setIDIdentifier(childElement);
            DSSXMLUtils.recursiveIdBrowse(childElement);
        }
    }

    public static String getIDIdentifier(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        for (int jj = 0; jj < attributes.getLength(); ++jj) {
            String id;
            Node item = attributes.item(jj);
            String localName = item.getLocalName();
            if (localName == null || !ID_ATTRIBUTE_NAME.equals(id = localName.toLowerCase())) continue;
            return item.getTextContent();
        }
        return null;
    }

    public static void setIDIdentifier(Element childElement) {
        NamedNodeMap attributes = childElement.getAttributes();
        for (int jj = 0; jj < attributes.getLength(); ++jj) {
            String id;
            Node item = attributes.item(jj);
            String localName = item.getLocalName();
            String nodeName = item.getNodeName();
            if (localName == null || !ID_ATTRIBUTE_NAME.equals(id = localName.toLowerCase())) continue;
            childElement.setIdAttribute(nodeName, true);
            break;
        }
    }

    public static String validateAgainstXSD(StreamSource streamSource) {
        try {
            if (schema == null) {
                schema = DSSXMLUtils.getSchema();
            }
            Validator validator = schema.newValidator();
            validator.validate(streamSource);
            return "";
        }
        catch (Exception e) {
            LOG.warn("Error during the XML schema validation!", (Throwable)e);
            return e.getMessage();
        }
    }

    private static Schema getSchema() throws SAXException {
        ResourceLoader resourceLoader = new ResourceLoader();
        InputStream xadesXsd = resourceLoader.getResource(XAD_ESV141_XSD);
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        return factory.newSchema(new StreamSource(xadesXsd));
    }

    public static boolean isOid(String policyId) {
        return policyId != null && policyId.matches("^(?i)urn:oid:.*$");
    }

    static {
        SantuarioInitializer.init();
        transforms = new HashSet<String>();
        DSSXMLUtils.registerDefaultTransforms();
        canonicalizers = new HashSet<String>();
        DSSXMLUtils.registerDefaultCanonicalizers();
        schema = null;
    }
}

