/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.EncryptionAlgorithm;
import eu.europa.esig.dss.InMemoryDocument;
import eu.europa.esig.dss.MimeType;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.xades.DSSReference;
import eu.europa.esig.dss.xades.DSSTransform;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.signature.DSSSignatureUtils;
import eu.europa.esig.dss.xades.signature.XAdESSignatureBuilder;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class EnvelopingSignatureBuilder
extends XAdESSignatureBuilder {
    public EnvelopingSignatureBuilder(XAdESSignatureParameters params, DSSDocument origDoc, CertificateVerifier certificateVerifier) {
        super(params, origDoc, certificateVerifier);
        this.setCanonicalizationMethods(params, "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
    }

    @Override
    protected DSSReference createReference(DSSDocument document, int referenceIndex) {
        DSSReference reference = new DSSReference();
        reference.setId("r-id-" + referenceIndex);
        reference.setContents(document);
        reference.setDigestMethodAlgorithm(this.params.getDigestAlgorithm());
        if (this.params.isManifestSignature()) {
            reference.setType("http://www.w3.org/2000/09/xmldsig#Manifest");
            reference.setUri("#" + (this.params.getManifestId() == null ? "manifest" : this.params.getManifestId()));
            DSSTransform xmlTransform = new DSSTransform();
            xmlTransform.setAlgorithm("http://www.w3.org/2006/12/xml-c14n11");
            reference.setTransforms(Arrays.asList(xmlTransform));
        } else {
            reference.setType("http://www.w3.org/2000/09/xmldsig#Object");
            reference.setUri("#o-id-" + referenceIndex);
            DSSTransform base64Transform = new DSSTransform();
            base64Transform.setAlgorithm("http://www.w3.org/2000/09/xmldsig#base64");
            reference.setTransforms(Arrays.asList(base64Transform));
        }
        return reference;
    }

    @Override
    protected DSSDocument transformReference(DSSReference reference) {
        return reference.getContents();
    }

    @Override
    public DSSDocument signDocument(byte[] signatureValue) throws DSSException {
        if (!this.built) {
            this.build();
        }
        EncryptionAlgorithm encryptionAlgorithm = this.params.getEncryptionAlgorithm();
        byte[] signatureValueBytes = DSSSignatureUtils.convertToXmlDSig(encryptionAlgorithm, signatureValue);
        String signatureValueBase64Encoded = Utils.toBase64((byte[])signatureValueBytes);
        Text signatureValueNode = this.documentDom.createTextNode(signatureValueBase64Encoded);
        this.signatureValueDom.appendChild(signatureValueNode);
        List<DSSReference> references = this.params.getReferences();
        for (DSSReference reference : references) {
            String id = reference.getUri().substring(1);
            DSSDocument tbsDoc = reference.getContents();
            if (this.params.isManifestSignature()) {
                Document doc = DomUtils.buildDOM((DSSDocument)reference.getContents());
                Element root = doc.getDocumentElement();
                NodeList referencesNodes = root.getChildNodes();
                String idAttribute = root.getAttribute("Id");
                Element manifestDom = this.documentDom.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Manifest");
                manifestDom.setAttribute("Id", idAttribute);
                for (int i = 0; i < referencesNodes.getLength(); ++i) {
                    Node copyNode = this.documentDom.importNode(referencesNodes.item(i), true);
                    manifestDom.appendChild(copyNode);
                }
                Element dom = this.documentDom.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Object");
                dom.appendChild(manifestDom);
                this.signatureDom.appendChild(dom);
                continue;
            }
            String base64EncodedOriginalDocument = Utils.toBase64((byte[])DSSUtils.toByteArray((DSSDocument)reference.getContents()));
            Element objectDom = DomUtils.addTextElement((Document)this.documentDom, (Element)this.signatureDom, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"ds:Object", (String)base64EncodedOriginalDocument);
            objectDom.setAttribute("Id", id);
        }
        byte[] documentBytes = DSSXMLUtils.serializeNode(this.documentDom);
        InMemoryDocument inMemoryDocument = new InMemoryDocument(documentBytes);
        inMemoryDocument.setMimeType(MimeType.XML);
        return inMemoryDocument;
    }
}

