/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.TimestampParameters;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.x509.TimestampType;
import eu.europa.esig.dss.xades.signature.XAdESLevelXL;

public class XAdESLevelA
extends XAdESLevelXL {
    public XAdESLevelA(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    @Override
    protected void extendSignatureTag() throws DSSException {
        super.extendSignatureTag();
        this.xadesSignature.checkSignatureIntegrity();
        TimestampParameters archiveTimestampParameters = this.params.getArchiveTimestampParameters();
        String canonicalizationMethod = archiveTimestampParameters.getCanonicalizationMethod();
        byte[] data = this.xadesSignature.getArchiveTimestampData(null, canonicalizationMethod);
        DigestAlgorithm timestampDigestAlgorithm = archiveTimestampParameters.getDigestAlgorithm();
        byte[] digestBytes = DSSUtils.digest((DigestAlgorithm)timestampDigestAlgorithm, (byte[])data);
        this.createXAdESTimeStampType(TimestampType.ARCHIVE_TIMESTAMP, canonicalizationMethod, digestBytes);
    }
}

