/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.x509.crl.OfflineCRLSource;
import eu.europa.esig.dss.xades.XPathQueryHolder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XAdESCRLSource
extends OfflineCRLSource {
    public XAdESCRLSource(Element signatureElement, XPathQueryHolder xPathQueryHolder) {
        if (signatureElement == null) {
            throw new NullPointerException("signatureElement");
        }
        if (xPathQueryHolder == null) {
            throw new NullPointerException("xPathQueryHolder");
        }
        this.addCRLs(signatureElement, xPathQueryHolder.XPATH_CRL_VALUES_ENCAPSULATED_CRL);
        this.addCRLs(signatureElement, xPathQueryHolder.XPATH_TSVD_ENCAPSULATED_CRL_VALUES);
    }

    private void addCRLs(Element signatureElement, String xPathQuery) {
        NodeList nodeList = DomUtils.getNodeList((Node)signatureElement, (String)xPathQuery);
        for (int ii = 0; ii < nodeList.getLength(); ++ii) {
            Element certEl = (Element)nodeList.item(ii);
            String textContent = certEl.getTextContent();
            this.addCRLBinary(Utils.fromBase64((String)textContent));
        }
    }
}

