/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.x509.CertificatePool;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.SignatureCertificateSource;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.XPathQueryHolder;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XAdESCertificateSource
extends SignatureCertificateSource {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESCertificateSource.class);
    private final Element signatureElement;
    private final XPathQueryHolder xPathQueryHolder;
    private List<CertificateToken> keyInfoCerts;
    private List<CertificateToken> encapsulatedCerts;
    private List<CertificateToken> timestampValidationDataCerts;

    public XAdESCertificateSource(Element signatureElement, XPathQueryHolder xPathQueryHolder, CertificatePool certificatePool) {
        super(certificatePool);
        if (signatureElement == null) {
            throw new NullPointerException();
        }
        if (xPathQueryHolder == null) {
            throw new NullPointerException();
        }
        this.signatureElement = signatureElement;
        this.xPathQueryHolder = xPathQueryHolder;
        if (this.certificateTokens == null) {
            this.certificateTokens = new ArrayList();
            this.encapsulatedCerts = this.getCertificates(xPathQueryHolder.XPATH_ENCAPSULATED_X509_CERTIFICATE);
            this.keyInfoCerts = this.getCertificates(xPathQueryHolder.XPATH_KEY_INFO_X509_CERTIFICATE);
            this.timestampValidationDataCerts = this.getCertificates(xPathQueryHolder.XPATH_TSVD_ENCAPSULATED_X509_CERTIFICATE);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("+XAdESCertificateSource");
        }
    }

    private List<CertificateToken> getCertificates(String xPathQuery) {
        ArrayList<CertificateToken> list = new ArrayList<CertificateToken>();
        NodeList nodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)xPathQuery);
        for (int ii = 0; ii < nodeList.getLength(); ++ii) {
            Element certificateElement = (Element)nodeList.item(ii);
            byte[] derEncoded = Utils.fromBase64((String)certificateElement.getTextContent());
            try {
                CertificateToken cert = DSSUtils.loadCertificate((byte[])derEncoded);
                CertificateToken certToken = this.addCertificate(cert);
                if (list.contains(certToken)) continue;
                String idIdentifier = DSSXMLUtils.getIDIdentifier(certificateElement);
                certToken.setXmlId(idIdentifier);
                list.add(certToken);
                continue;
            }
            catch (Exception e) {
                LOG.warn("Unable to parse certificate '" + certificateElement.getTextContent() + "' : " + e.getMessage());
            }
        }
        return list;
    }

    public List<CertificateToken> getEncapsulatedCertificates() throws DSSException {
        return this.encapsulatedCerts;
    }

    public List<CertificateToken> getKeyInfoCertificates() throws DSSException {
        return this.keyInfoCerts;
    }

    public List<CertificateToken> getTimestampCertificates() throws DSSException {
        return this.timestampValidationDataCerts;
    }
}

