/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.definition.AbstractPaths;
import eu.europa.esig.dss.definition.DSSElement;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigAttribute;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigPaths;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.SantuarioInitializer;
import eu.europa.esig.dss.xades.definition.XAdESNamespaces;
import eu.europa.esig.dss.xades.definition.XAdESPaths;
import eu.europa.esig.dss.xades.definition.xades111.XAdES111Paths;
import eu.europa.esig.dss.xades.definition.xades132.XAdES132Element;
import eu.europa.esig.dss.xades.signature.PrettyPrintTransformer;
import eu.europa.esig.xmldsig.XSDAbstractUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.PublicKey;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.exceptions.XMLSecurityRuntimeException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.ReferenceNotInitializedException;
import org.apache.xml.security.transforms.Transforms;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DSSXMLUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DSSXMLUtils.class);
    private static final Set<String> transforms;
    private static final Set<String> canonicalizers;
    private static final String TRANSFORMATION_EXCLUDE_SIGNATURE = "not(ancestor-or-self::ds:Signature)";
    private static final String TRANSFORMATION_XPATH_NODE_NAME = "XPath";
    public static final String DEFAULT_CANONICALIZATION_METHOD = "http://www.w3.org/2001/10/xml-exc-c14n#";

    private static void registerDefaultTransforms() {
        DSSXMLUtils.registerTransform("http://www.w3.org/2000/09/xmldsig#base64");
        DSSXMLUtils.registerTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        DSSXMLUtils.registerTransform("http://www.w3.org/TR/1999/REC-xpath-19991116");
        DSSXMLUtils.registerTransform("http://www.w3.org/2002/06/xmldsig-filter2");
        DSSXMLUtils.registerTransform("http://www.w3.org/TR/2001/WD-xptr-20010108");
        DSSXMLUtils.registerTransform("http://www.w3.org/TR/1999/REC-xslt-19991116");
    }

    private static void registerDefaultCanonicalizers() {
        DSSXMLUtils.registerCanonicalizer("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        DSSXMLUtils.registerCanonicalizer(DEFAULT_CANONICALIZATION_METHOD);
        DSSXMLUtils.registerCanonicalizer("http://www.w3.org/2006/12/xml-c14n11");
        DSSXMLUtils.registerCanonicalizer("http://santuario.apache.org/c14n/physical");
        DSSXMLUtils.registerCanonicalizer("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        DSSXMLUtils.registerCanonicalizer("http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        DSSXMLUtils.registerCanonicalizer("http://www.w3.org/2006/12/xml-c14n11#WithComments");
    }

    private DSSXMLUtils() {
    }

    public static boolean registerTransform(String transformURI) {
        boolean added = transforms.add(transformURI);
        return added;
    }

    public static boolean registerCanonicalizer(String c14nAlgorithmURI) {
        boolean added = canonicalizers.add(c14nAlgorithmURI);
        return added;
    }

    public static Node indentAndReplace(Document document, Node node) {
        Node indentedNode = DSSXMLUtils.getIndentedNode(document, node);
        Node importedNode = document.importNode(indentedNode, true);
        node.getParentNode().replaceChild(importedNode, node);
        return importedNode;
    }

    public static Node indentAndExtend(Document document, Node newNode, Node oldNode) {
        Node indentedNode = DSSXMLUtils.getIndentedNode(document, newNode);
        indentedNode = DSSXMLUtils.alignChildrenIndents(indentedNode);
        Node importedNode = document.importNode(indentedNode, true);
        NodeList nodeList = importedNode.getChildNodes();
        for (int i = DSSXMLUtils.getPositionToStartExtension(oldNode, importedNode); i < nodeList.getLength(); ++i) {
            Node nodeToAppend = nodeList.item(i).cloneNode(true);
            if (1 == nodeToAppend.getNodeType() && DSSXMLUtils.checkIfExists(oldNode, nodeToAppend)) continue;
            oldNode.appendChild(nodeToAppend);
        }
        newNode.getParentNode().replaceChild(oldNode, newNode);
        return oldNode;
    }

    private static int getPositionToStartExtension(Node oldNode, Node indentedNode) {
        NodeList nodeList = oldNode.getChildNodes();
        int startPosition = nodeList.getLength();
        Node child = null;
        while (oldNode.hasChildNodes() && 3 == (child = oldNode.getLastChild()).getNodeType()) {
            oldNode.removeChild(child);
        }
        Integer position = DSSXMLUtils.getPosition(indentedNode, child);
        if (position != null) {
            return position;
        }
        return startPosition;
    }

    private static boolean checkIfExists(Node parentNode, Node childToCheck) {
        return DSSXMLUtils.getPosition(parentNode, childToCheck) != null;
    }

    private static Integer getPosition(Node parentNode, Node childToCheck) {
        if (parentNode != null && childToCheck != null) {
            String nodeName = childToCheck.getLocalName();
            NodeList newNodeChildList = parentNode.getChildNodes();
            for (int i = 0; i < newNodeChildList.getLength(); ++i) {
                String idIdentifier;
                Node newChildNode = newNodeChildList.item(i);
                if (!nodeName.equals(newChildNode.getLocalName()) || (idIdentifier = DSSXMLUtils.getIDIdentifier(childToCheck)) != null && !idIdentifier.equals(DSSXMLUtils.getIDIdentifier(newChildNode))) continue;
                return i + 1;
            }
        }
        return null;
    }

    public static Document getDocWithIndentedSignatures(Document documentDom, String signatureId, List<String> noIndentObjectIds) {
        NodeList signatures = DomUtils.getNodeList((Node)documentDom, (String)XMLDSigPaths.ALL_SIGNATURES_PATH);
        for (int i = 0; i < signatures.getLength(); ++i) {
            Element signature = (Element)signatures.item(i);
            String signatureAttrIdValue = DSSXMLUtils.getIDIdentifier(signature);
            if (!Utils.isStringNotEmpty((String)signatureAttrIdValue) || !signatureAttrIdValue.contains(signatureId)) continue;
            Node unsignedSignatureProperties = DomUtils.getNode((Node)signature, (String)AbstractPaths.allFromCurrentPosition((DSSElement)XAdES132Element.UNSIGNED_SIGNATURE_PROPERTIES));
            Node indentedSignature = DSSXMLUtils.getIndentedSignature(signature, noIndentObjectIds);
            Node importedSignature = documentDom.importNode(indentedSignature, true);
            signature.getParentNode().replaceChild(importedSignature, signature);
            if (unsignedSignatureProperties == null) continue;
            Node newUnsignedSignatureProperties = DomUtils.getNode((Node)signature, (String)AbstractPaths.allFromCurrentPosition((DSSElement)XAdES132Element.UNSIGNED_SIGNATURE_PROPERTIES));
            newUnsignedSignatureProperties.getParentNode().replaceChild(unsignedSignatureProperties, newUnsignedSignatureProperties);
        }
        return documentDom;
    }

    private static Node getIndentedSignature(Node signature, List<String> noIndentObjectIds) {
        Node indentedSignature = DSSXMLUtils.getIndentedNode(signature);
        NodeList sigChildNodes = signature.getChildNodes();
        for (int i = 0; i < sigChildNodes.getLength(); ++i) {
            Element sigChild;
            String idAttribute;
            Node childNode = sigChildNodes.item(i);
            if (childNode.getNodeType() != 1 || !noIndentObjectIds.contains(idAttribute = DSSXMLUtils.getIDIdentifier(sigChild = (Element)childNode))) continue;
            Node nodeToReplace = DomUtils.getNode((Node)indentedSignature, (String)(".//*" + DomUtils.getXPathByIdAttribute((String)idAttribute)));
            Node importedNode = indentedSignature.getOwnerDocument().importNode(sigChild, true);
            indentedSignature.replaceChild(importedNode, nodeToReplace);
        }
        return indentedSignature;
    }

    public static Node getIndentedNode(Node documentDom, Node xmlNode) {
        NodeList signatures = DomUtils.getNodeList((Node)documentDom, (String)XMLDSigPaths.ALL_SIGNATURES_PATH);
        String pathAllFromCurrentPosition = null;
        DSSElement element = XAdES132Element.fromTagName(xmlNode.getLocalName());
        pathAllFromCurrentPosition = element != null ? AbstractPaths.allFromCurrentPosition((DSSElement)element) : ".//" + xmlNode.getNodeName();
        for (int i = 0; i < signatures.getLength(); ++i) {
            Node signature = signatures.item(i);
            String idAttribute = DSSXMLUtils.getIDIdentifier(xmlNode);
            NodeList candidateList = idAttribute != null ? DomUtils.getNodeList((Node)signature, (String)(".//*" + DomUtils.getXPathByIdAttribute((String)idAttribute))) : DomUtils.getNodeList((Node)signature, (String)pathAllFromCurrentPosition);
            if (!DSSXMLUtils.isNodeListContains(candidateList, xmlNode)) continue;
            Node indentedSignature = DSSXMLUtils.getIndentedNode(signature);
            Node indentedXmlNode = idAttribute != null ? DomUtils.getNode((Node)indentedSignature, (String)(".//*" + DomUtils.getXPathByIdAttribute((String)idAttribute))) : DomUtils.getNode((Node)indentedSignature, (String)pathAllFromCurrentPosition);
            if (indentedXmlNode == null) continue;
            return indentedXmlNode;
        }
        return xmlNode;
    }

    private static Node getIndentedNode(Node xmlNode) {
        PrettyPrintTransformer prettyPrintTransformer = new PrettyPrintTransformer();
        return prettyPrintTransformer.transform(xmlNode);
    }

    private static boolean isNodeListContains(NodeList nodeList, Node node) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (child != node) continue;
            return true;
        }
        return false;
    }

    public static Node alignChildrenIndents(Node parentNode) {
        NodeList nodeChildren;
        String targetIndent;
        if (parentNode.hasChildNodes() && (targetIndent = DSSXMLUtils.getTargetIndent(nodeChildren = parentNode.getChildNodes())) != null) {
            for (int i = 0; i < nodeChildren.getLength() - 1; ++i) {
                Node node = nodeChildren.item(i);
                if (3 != node.getNodeType()) continue;
                node.setNodeValue(targetIndent);
            }
            Node lastChild = parentNode.getLastChild();
            targetIndent = targetIndent.substring(0, targetIndent.length() - 4);
            switch (lastChild.getNodeType()) {
                case 1: {
                    DomUtils.setTextNode((Document)parentNode.getOwnerDocument(), (Element)((Element)parentNode), (String)targetIndent);
                    break;
                }
                case 3: {
                    lastChild.setNodeValue(targetIndent);
                    break;
                }
            }
        }
        return parentNode;
    }

    private static String getTargetIndent(NodeList nodeChildren) {
        for (int i = 0; i < nodeChildren.getLength() - 1; ++i) {
            Node node = nodeChildren.item(i);
            if (3 != node.getNodeType()) continue;
            return node.getNodeValue();
        }
        return null;
    }

    public static byte[] serializeNode(Node xmlNode) {
        byte[] byArray;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            String xmlEncoding;
            Transformer transformer = DomUtils.getSecureTransformer();
            Document document = null;
            document = 9 == xmlNode.getNodeType() ? (Document)xmlNode : xmlNode.getOwnerDocument();
            if (document != null && Utils.isStringNotBlank((String)(xmlEncoding = document.getXmlEncoding()))) {
                transformer.setOutputProperty("encoding", xmlEncoding);
            }
            StreamResult result = new StreamResult(bos);
            DOMSource source = new DOMSource(xmlNode);
            transformer.transform(source, result);
            byArray = bos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    bos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new DSSException("An error occurred during a node serialization.", (Throwable)e);
            }
        }
        bos.close();
        return byArray;
    }

    public static boolean canCanonicalize(String canonicalizationMethod) {
        return canonicalizers.contains(canonicalizationMethod);
    }

    public static byte[] canonicalize(String canonicalizationMethod, byte[] toCanonicalizeBytes) throws DSSException {
        try {
            Canonicalizer c14n = Canonicalizer.getInstance((String)DSSXMLUtils.getCanonicalizationMethod(canonicalizationMethod));
            return c14n.canonicalize(toCanonicalizeBytes);
        }
        catch (Exception e) {
            throw new DSSException("Cannot canonicalize the binaries", (Throwable)e);
        }
    }

    public static byte[] canonicalizeSubtree(String canonicalizationMethod, Node node) {
        try {
            Canonicalizer c14n = Canonicalizer.getInstance((String)DSSXMLUtils.getCanonicalizationMethod(canonicalizationMethod));
            return c14n.canonicalizeSubtree(node);
        }
        catch (Exception e) {
            throw new DSSException("Cannot canonicalize the subtree", (Throwable)e);
        }
    }

    public static String getCanonicalizationMethod(String canonicalizationMethod) {
        if (Utils.isStringEmpty((String)canonicalizationMethod)) {
            LOG.warn("Canonicalization method is not defined. A default canonicalization '{}' will be used.", (Object)DEFAULT_CANONICALIZATION_METHOD);
            return DEFAULT_CANONICALIZATION_METHOD;
        }
        return canonicalizationMethod;
    }

    public static void recursiveIdBrowse(Element element) {
        for (int ii = 0; ii < element.getChildNodes().getLength(); ++ii) {
            Node node = element.getChildNodes().item(ii);
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            DSSXMLUtils.setIDIdentifier(childElement);
            DSSXMLUtils.recursiveIdBrowse(childElement);
        }
    }

    public static String getIDIdentifier(Node node) {
        return DSSXMLUtils.getAttribute(node, XMLDSigAttribute.ID.getAttributeName());
    }

    public static String getAttribute(Node node, String attributeName) {
        NamedNodeMap attributes = node.getAttributes();
        for (int jj = 0; jj < attributes.getLength(); ++jj) {
            String localName;
            Node item = attributes.item(jj);
            String string = localName = item.getLocalName() != null ? item.getLocalName() : item.getNodeName();
            if (localName == null || !Utils.areStringsEqualIgnoreCase((String)attributeName, (String)localName)) continue;
            return item.getTextContent();
        }
        return null;
    }

    public static void setIDIdentifier(Element childElement) {
        NamedNodeMap attributes = childElement.getAttributes();
        for (int jj = 0; jj < attributes.getLength(); ++jj) {
            Node item = attributes.item(jj);
            String localName = item.getLocalName();
            String nodeName = item.getNodeName();
            if (localName == null || !Utils.areStringsEqualIgnoreCase((String)XMLDSigAttribute.ID.getAttributeName(), (String)localName)) continue;
            childElement.setIdAttribute(nodeName, true);
            break;
        }
    }

    public static String validateAgainstXSD(XSDAbstractUtils xsdUtils, Source source) {
        return xsdUtils.validateAgainstXSD(source);
    }

    public static boolean isOid(String policyId) {
        return policyId != null && policyId.matches("^(?i)urn:oid:.*$");
    }

    public static String getOidCode(String oid) {
        if (oid == null) {
            return null;
        }
        return oid.substring(oid.lastIndexOf(58) + 1);
    }

    public static boolean isDuplicateIdsDetected(DSSDocument doc) {
        try {
            Document dom = DomUtils.buildDOM((DSSDocument)doc);
            Element root = dom.getDocumentElement();
            DSSXMLUtils.recursiveIdBrowse(root);
            XPathExpression xPathExpression = DomUtils.createXPathExpression((String)"//*/@*");
            NodeList nodeList = (NodeList)xPathExpression.evaluate(root, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                XPathExpression xpathAllById;
                NodeList nodeListById;
                Attr attr = (Attr)nodeList.item(i);
                if (!Utils.areStringsEqualIgnoreCase((String)XMLDSigAttribute.ID.getAttributeName(), (String)attr.getName()) || (nodeListById = (NodeList)(xpathAllById = DomUtils.createXPathExpression((String)("//*[@" + attr.getName() + "='" + attr.getValue() + "']"))).evaluate(root, XPathConstants.NODESET)).getLength() == 1) continue;
                LOG.warn("Problem detected with Id '{}', nb occurences = {}", (Object)attr.getValue(), (Object)nodeListById.getLength());
                return true;
            }
        }
        catch (XPathExpressionException e) {
            throw new DSSException("Unable to check if duplicate ids are present", (Throwable)e);
        }
        return false;
    }

    public static byte[] getNodeBytes(Node node) {
        if (node.getNodeType() == 1) {
            byte[] bytes = DSSXMLUtils.serializeNode(node);
            String str = new String(bytes);
            if (str.startsWith("<?")) {
                str = str.substring(str.indexOf("?>") + 2);
            }
            return str.getBytes();
        }
        if (node.getNodeType() == 3) {
            String textContent = node.getTextContent();
            if (Utils.isBase64Encoded((String)textContent)) {
                return Utils.fromBase64((String)node.getTextContent());
            }
            return textContent.getBytes();
        }
        return null;
    }

    public static byte[] getReferenceOriginalContentBytes(Reference reference) {
        try {
            Element transformsElement;
            NodeList transformChildNodes;
            Transforms transforms = reference.getTransforms();
            if (transforms != null && (transformChildNodes = (transformsElement = transforms.getElement()).getChildNodes()) != null && transformChildNodes.getLength() > 0) {
                for (int i = 0; i < transformChildNodes.getLength(); ++i) {
                    Node transformation = transformChildNodes.item(i);
                    if (!DSSXMLUtils.isEnvelopedTransform(transformation)) continue;
                    return reference.getReferencedBytes();
                }
            }
        }
        catch (XMLSecurityException | XMLSecurityRuntimeException e) {
            LOG.warn("Signature reference with id [{}] is corrupted or has an invalid format. Original data cannot be obtained. Reason: [{}]", (Object)reference.getId(), (Object)e.getMessage());
        }
        return DSSXMLUtils.getBytesBeforeTransformation(reference);
    }

    private static boolean isEnvelopedTransform(Node transformation) {
        String algorithm = DomUtils.getValue((Node)transformation, (String)"@Algorithm");
        if ("http://www.w3.org/2000/09/xmldsig#enveloped-signature".equals(algorithm)) {
            return true;
        }
        if ("http://www.w3.org/TR/1999/REC-xpath-19991116".equals(algorithm) || "http://www.w3.org/2002/06/xmldsig-filter2".equals(algorithm)) {
            NodeList childNodes = transformation.getChildNodes();
            for (int j = 0; j < childNodes.getLength(); ++j) {
                Node item = childNodes.item(j);
                if (1 != item.getNodeType() || !TRANSFORMATION_XPATH_NODE_NAME.equals(item.getLocalName()) || !TRANSFORMATION_EXCLUDE_SIGNATURE.equals(item.getTextContent())) continue;
                return true;
            }
        }
        return false;
    }

    private static byte[] getBytesBeforeTransformation(Reference reference) {
        try {
            return reference.getContentsBeforeTransformation().getBytes();
        }
        catch (ReferenceNotInitializedException e) {
            LOG.warn("Original data is not provided for the reference with id [{}]. Reason: [{}]", (Object)reference.getId(), (Object)e.getMessage());
        }
        catch (IOException | CanonicalizationException e) {
            LOG.error("Unable to retrieve the content of reference with id [{}].", (Object)reference.getId(), (Object)e);
        }
        return null;
    }

    public static Digest getDigestAndValue(Element element) {
        if (element == null) {
            return null;
        }
        String digestAlgorithmUri = null;
        String digestValueBase64 = null;
        if (XAdESNamespaces.XADES_111.isSameUri(element.getNamespaceURI())) {
            digestAlgorithmUri = DomUtils.getValue((Node)element, (String)XAdES111Paths.DIGEST_METHOD_ALGORITHM_PATH);
            digestValueBase64 = DomUtils.getValue((Node)element, (String)XAdES111Paths.DIGEST_VALUE_PATH);
        } else {
            digestAlgorithmUri = DomUtils.getValue((Node)element, (String)XMLDSigPaths.DIGEST_METHOD_ALGORITHM_PATH);
            digestValueBase64 = DomUtils.getValue((Node)element, (String)XMLDSigPaths.DIGEST_VALUE_PATH);
        }
        DigestAlgorithm digestAlgorithm = DSSXMLUtils.getDigestAlgorithm(digestAlgorithmUri);
        byte[] digestValue = DSSXMLUtils.getDigestValue(digestValueBase64);
        if (digestAlgorithm == null || digestValue == null) {
            LOG.warn("Unable to read object DigestAlgAndValueType (XMLDSig or XAdES 1.1.1)");
            return null;
        }
        return new Digest(digestAlgorithm, digestValue);
    }

    private static byte[] getDigestValue(String digestValueBase64) {
        byte[] result = null;
        if (Utils.isStringNotEmpty((String)digestValueBase64)) {
            result = Utils.fromBase64((String)digestValueBase64);
        }
        return result;
    }

    private static DigestAlgorithm getDigestAlgorithm(String digestAlgorithmUri) {
        DigestAlgorithm result = null;
        if (Utils.isStringNotEmpty((String)digestAlgorithmUri)) {
            try {
                result = DigestAlgorithm.forXML((String)digestAlgorithmUri);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Unable to retrieve the used digest algorithm", (Throwable)e);
            }
        }
        return result;
    }

    public static boolean isSignedProperties(Reference reference, XAdESPaths xadesPaths) {
        return xadesPaths.getSignedPropertiesUri().equals(reference.getType());
    }

    public static boolean isCounterSignature(Reference reference, XAdESPaths xadesPaths) {
        return xadesPaths.getCounterSignatureUri().equals(reference.getType());
    }

    public static boolean isKeyInfoReference(Reference reference, Element signature) {
        String uri = reference.getURI();
        uri = DomUtils.getId((String)uri);
        Element element = DomUtils.getElement((Node)signature, (String)(XMLDSigPaths.KEY_INFO_PATH + DomUtils.getXPathByIdAttribute((String)uri)));
        return element != null;
    }

    public static boolean isObjectReferenceType(String referenceType) {
        return "http://www.w3.org/2000/09/xmldsig#Object".equals(referenceType);
    }

    public static boolean isManifestReferenceType(String referenceType) {
        return "http://www.w3.org/2000/09/xmldsig#Manifest".equals(referenceType);
    }

    public static boolean isCounterSignatureReferenceType(String referenceType) {
        return "http://uri.etsi.org/01903#CountersignedSignature".equals(referenceType);
    }

    public static PublicKey getKeyInfoSigningCertificatePublicKey(Element signatureElement) {
        Element keyInfoElement = DomUtils.getElement((Node)signatureElement, (String)XMLDSigPaths.KEY_INFO_PATH);
        if (keyInfoElement != null) {
            try {
                KeyInfo keyInfo = new KeyInfo(keyInfoElement, "");
                return keyInfo.getPublicKey();
            }
            catch (XMLSecurityException e) {
                LOG.warn("Unable to extract signing certificate's public key. Reason : {}", (Object)e.getMessage(), (Object)e);
            }
        }
        LOG.warn("Unable to extract the public key. Reason : KeyInfo element is null");
        return null;
    }

    static {
        SantuarioInitializer.init();
        transforms = new HashSet<String>();
        DSSXMLUtils.registerDefaultTransforms();
        canonicalizers = new HashSet<String>();
        DSSXMLUtils.registerDefaultCanonicalizers();
    }
}

