/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.reference;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.definition.DSSElement;
import eu.europa.esig.dss.definition.DSSNamespace;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigAttribute;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigElement;
import eu.europa.esig.dss.xades.definition.XAdESNamespaces;
import eu.europa.esig.dss.xades.reference.DSSTransform;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractTransform
implements DSSTransform {
    protected final String algorithm;
    protected DSSNamespace namespace = XAdESNamespaces.XMLDSIG;

    public AbstractTransform(String algorithm) {
        this.algorithm = algorithm;
    }

    public AbstractTransform(DSSNamespace xmlDSigNamespace, String algorithm) {
        this.namespace = xmlDSigNamespace;
        this.algorithm = algorithm;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public void setNamespace(DSSNamespace namespace) {
        this.namespace = namespace;
    }

    @Override
    public Element createTransform(Document document, Element parentNode) {
        Element transformDom = DomUtils.addElement((Document)document, (Element)parentNode, (DSSNamespace)this.namespace, (DSSElement)XMLDSigElement.TRANSFORM);
        transformDom.setAttribute(XMLDSigAttribute.ALGORITHM.getAttributeName(), this.algorithm);
        return transformDom;
    }
}

