/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.reference;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.definition.DSSNamespace;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.definition.XAdESNamespaces;
import eu.europa.esig.dss.xades.reference.ComplexTransform;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.w3c.dom.Node;

public class CanonicalizationTransform
extends ComplexTransform {
    public CanonicalizationTransform(String canonicalizationAlgorithm) {
        this(XAdESNamespaces.XMLDSIG, canonicalizationAlgorithm);
    }

    public CanonicalizationTransform(DSSNamespace xmlDSigNamespace, String canonicalizationAlgorithm) {
        super(xmlDSigNamespace, canonicalizationAlgorithm);
        if (!DSSXMLUtils.canCanonicalize(canonicalizationAlgorithm)) {
            throw new DSSException(String.format("The provided canonicalization method [%s] is not supported!", canonicalizationAlgorithm));
        }
    }

    @Override
    protected XMLSignatureInput getXMLSignatureInput(Node node, String uri) {
        XMLSignatureInput xmlSignatureInput = super.getXMLSignatureInput(node, uri);
        xmlSignatureInput.setExcludeComments(this.isExcludeComments(uri));
        return xmlSignatureInput;
    }

    protected boolean isExcludeComments(String uri) {
        return uri != null && ("".equals(uri) || DomUtils.isElementReference((String)uri));
    }
}

