/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.definition.DSSElement;
import eu.europa.esig.dss.definition.DSSNamespace;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigAttribute;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigElement;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.reference.Base64Transform;
import eu.europa.esig.dss.xades.reference.CanonicalizationTransform;
import eu.europa.esig.dss.xades.reference.DSSReference;
import eu.europa.esig.dss.xades.signature.DSSSignatureUtils;
import eu.europa.esig.dss.xades.signature.XAdESSignatureBuilder;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class EnvelopingSignatureBuilder
extends XAdESSignatureBuilder {
    public EnvelopingSignatureBuilder(XAdESSignatureParameters params, DSSDocument origDoc, CertificateVerifier certificateVerifier) {
        super(params, origDoc, certificateVerifier);
    }

    @Override
    protected DSSReference createReference(DSSDocument document, int referenceIndex) {
        String suffix = this.deterministicId + "-" + referenceIndex;
        DSSReference reference = new DSSReference();
        reference.setId("r-" + suffix);
        reference.setContents(document);
        DigestAlgorithm digestAlgorithm = this.getReferenceDigestAlgorithmOrDefault(this.params);
        reference.setDigestMethodAlgorithm(digestAlgorithm);
        if (this.params.isManifestSignature()) {
            reference.setType("http://www.w3.org/2000/09/xmldsig#Manifest");
            Document manifestDoc = DomUtils.buildDOM((DSSDocument)document);
            Element manifestElement = manifestDoc.getDocumentElement();
            reference.setUri("#" + manifestElement.getAttribute(XMLDSigAttribute.ID.getAttributeName()));
            CanonicalizationTransform xmlTransform = new CanonicalizationTransform(this.getXmldsigNamespace(), "http://www.w3.org/2006/12/xml-c14n11");
            reference.setTransforms(Arrays.asList(xmlTransform));
        } else if (this.params.isEmbedXML()) {
            reference.setType("http://www.w3.org/2000/09/xmldsig#Object");
            reference.setUri("#o-" + suffix);
            CanonicalizationTransform xmlTransform = new CanonicalizationTransform(this.getXmldsigNamespace(), "http://www.w3.org/2006/12/xml-c14n11");
            reference.setTransforms(Arrays.asList(xmlTransform));
        } else {
            reference.setType("http://www.w3.org/2000/09/xmldsig#Object");
            reference.setUri("#o-" + suffix);
            Base64Transform base64Transform = new Base64Transform(this.getXmldsigNamespace());
            reference.setTransforms(Arrays.asList(base64Transform));
        }
        return reference;
    }

    @Override
    protected DSSDocument transformReference(DSSReference reference) {
        return reference.getContents();
    }

    @Override
    public DSSDocument signDocument(byte[] signatureValue) throws DSSException {
        if (!this.built) {
            this.build();
        }
        EncryptionAlgorithm encryptionAlgorithm = this.params.getEncryptionAlgorithm();
        byte[] signatureValueBytes = DSSSignatureUtils.convertToXmlDSig(encryptionAlgorithm, signatureValue);
        String signatureValueBase64Encoded = Utils.toBase64((byte[])signatureValueBytes);
        Text signatureValueNode = this.documentDom.createTextNode(signatureValueBase64Encoded);
        this.signatureValueDom.appendChild(signatureValueNode);
        List<DSSReference> references = this.params.getReferences();
        for (DSSReference reference : references) {
            Element root;
            Document doc;
            if (this.params.isManifestSignature()) {
                doc = DomUtils.buildDOM((DSSDocument)reference.getContents());
                root = doc.getDocumentElement();
                NodeList referencesNodes = root.getChildNodes();
                String idAttribute = root.getAttribute(XMLDSigAttribute.ID.getAttributeName());
                Element manifestDom = DomUtils.createElementNS((Document)this.documentDom, (DSSNamespace)this.getXmldsigNamespace(), (DSSElement)XMLDSigElement.MANIFEST);
                manifestDom.setAttribute(XMLDSigAttribute.ID.getAttributeName(), idAttribute);
                for (int i = 0; i < referencesNodes.getLength(); ++i) {
                    Node copyNode = this.documentDom.importNode(referencesNodes.item(i), true);
                    manifestDom.appendChild(copyNode);
                }
                Element dom = DomUtils.createElementNS((Document)this.documentDom, (DSSNamespace)this.getXmldsigNamespace(), (DSSElement)XMLDSigElement.OBJECT);
                dom.appendChild(manifestDom);
                this.signatureDom.appendChild(dom);
                continue;
            }
            if (this.params.isEmbedXML()) {
                doc = DomUtils.buildDOM((DSSDocument)reference.getContents());
                root = doc.getDocumentElement();
                Node adopted = this.documentDom.adoptNode(root);
                Element dom = DomUtils.createElementNS((Document)this.documentDom, (DSSNamespace)this.getXmldsigNamespace(), (DSSElement)XMLDSigElement.OBJECT);
                String id = reference.getUri().substring(1);
                dom.setAttribute(XMLDSigAttribute.ID.getAttributeName(), id);
                dom.appendChild(adopted);
                this.signatureDom.appendChild(dom);
                continue;
            }
            String base64EncodedOriginalDocument = Utils.toBase64((byte[])DSSUtils.toByteArray((DSSDocument)reference.getContents()));
            Element objectDom = DomUtils.addTextElement((Document)this.documentDom, (Element)this.signatureDom, (DSSNamespace)this.getXmldsigNamespace(), (DSSElement)XMLDSigElement.OBJECT, (String)base64EncodedOriginalDocument);
            String id = reference.getUri().substring(1);
            objectDom.setAttribute(XMLDSigAttribute.ID.getAttributeName(), id);
        }
        return this.createXmlDocument();
    }
}

