/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.reference.CanonicalizationTransform;
import eu.europa.esig.dss.xades.reference.DSSReference;
import eu.europa.esig.dss.xades.reference.DSSTransform;
import eu.europa.esig.dss.xades.signature.XAdESSignatureBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class InternallyDetachedSignatureBuilder
extends XAdESSignatureBuilder {
    public InternallyDetachedSignatureBuilder(XAdESSignatureParameters params, DSSDocument origDoc, CertificateVerifier certificateVerifier) {
        super(params, origDoc, certificateVerifier);
    }

    @Override
    protected Document buildRootDocumentDom() {
        if (this.params.getRootDocument() != null) {
            return this.params.getRootDocument();
        }
        Document rootDocument = DomUtils.buildDOM();
        Element rootElement = rootDocument.createElement("internally-detached");
        rootDocument.appendChild(rootElement);
        return rootDocument;
    }

    @Override
    protected Node getParentNodeOfSignature() {
        if (this.params.getRootDocument() != null) {
            return this.documentDom.getDocumentElement();
        }
        return this.documentDom.getDocumentElement();
    }

    @Override
    protected DSSReference createReference(DSSDocument document, int referenceIndex) {
        DSSReference reference = new DSSReference();
        reference.setId("r-" + this.deterministicId + "-" + referenceIndex);
        Document dom = DomUtils.buildDOM((DSSDocument)document);
        String identifier = DSSXMLUtils.getIDIdentifier(dom.getDocumentElement());
        Objects.requireNonNull(identifier, "ID not defined on the root xml element");
        reference.setUri("#" + identifier);
        reference.setContents(document);
        DigestAlgorithm digestAlgorithm = this.getReferenceDigestAlgorithmOrDefault(this.params);
        reference.setDigestMethodAlgorithm(digestAlgorithm);
        ArrayList<DSSTransform> dssTransformList = new ArrayList<DSSTransform>();
        CanonicalizationTransform canonicalization = new CanonicalizationTransform(this.getXmldsigNamespace(), "http://www.w3.org/2001/10/xml-exc-c14n#");
        dssTransformList.add(canonicalization);
        reference.setTransforms(dssTransformList);
        return reference;
    }

    @Override
    protected void incorporateFiles() {
        List<DSSReference> references = this.params.getReferences();
        for (DSSReference ref : references) {
            Document doc = DomUtils.buildDOM((DSSDocument)ref.getContents());
            Element root = doc.getDocumentElement();
            Node adopted = this.documentDom.importNode(root, true);
            this.documentDom.getDocumentElement().appendChild(adopted);
        }
    }

    @Override
    protected DSSDocument transformReference(DSSReference reference) {
        DSSDocument contents = reference.getContents();
        Document dom = DomUtils.buildDOM((DSSDocument)contents);
        Element root = dom.getDocumentElement();
        return new InMemoryDocument(this.applyTransformations(reference, root));
    }
}

