/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.definition.DSSElement;
import eu.europa.esig.dss.definition.DSSNamespace;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigAttribute;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigElement;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.TimestampBinary;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.signature.SignatureExtension;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.validation.ValidationDataForInclusion;
import eu.europa.esig.dss.validation.ValidationDataForInclusionBuilder;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.ProfileParameters;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.XAdESTimestampParameters;
import eu.europa.esig.dss.xades.definition.XAdESNamespaces;
import eu.europa.esig.dss.xades.definition.xades111.XAdES111Attribute;
import eu.europa.esig.dss.xades.definition.xades111.XAdES111Element;
import eu.europa.esig.dss.xades.definition.xades111.XAdES111Paths;
import eu.europa.esig.dss.xades.definition.xades122.XAdES122Attribute;
import eu.europa.esig.dss.xades.definition.xades122.XAdES122Element;
import eu.europa.esig.dss.xades.definition.xades122.XAdES122Paths;
import eu.europa.esig.dss.xades.definition.xades132.XAdES132Paths;
import eu.europa.esig.dss.xades.definition.xades141.XAdES141Element;
import eu.europa.esig.dss.xades.signature.ExtensionBuilder;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import org.digidoc4j.dss.xades.BDocTmSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XAdESLevelBaselineT
extends ExtensionBuilder
implements SignatureExtension<XAdESSignatureParameters>,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESLevelBaselineT.class);
    protected TSPSource tspSource;

    public XAdESLevelBaselineT(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    private void incorporateC14nMethod(Element parentDom, String signedInfoC14nMethod) {
        Element canonicalizationMethodDom = DomUtils.createElementNS((Document)this.documentDom, (DSSNamespace)this.getXmldsigNamespace(), (DSSElement)XMLDSigElement.CANONICALIZATION_METHOD);
        canonicalizationMethodDom.setAttribute(XMLDSigAttribute.ALGORITHM.getAttributeName(), signedInfoC14nMethod);
        parentDom.appendChild(canonicalizationMethodDom);
    }

    public DSSDocument extendSignatures(DSSDocument dssDocument, XAdESSignatureParameters params) throws DSSException {
        Objects.requireNonNull(dssDocument, "The document cannot be null");
        Objects.requireNonNull(this.tspSource, "The TSPSource cannot be null");
        this.params = params;
        ProfileParameters context = params.getContext();
        if (LOG.isInfoEnabled()) {
            LOG.info("====> Extending: {}", (Object)(dssDocument.getName() == null ? "IN MEMORY DOCUMENT" : dssDocument.getName()));
        }
        this.documentDom = DomUtils.buildDOM((DSSDocument)dssDocument);
        NodeList signatureNodeList = this.documentDom.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (signatureNodeList.getLength() == 0) {
            throw new DSSException("There is no signature to extend!");
        }
        String signatureId = null;
        ProfileParameters.Operation operationKind = context.getOperationKind();
        if (ProfileParameters.Operation.SIGNING.equals((Object)operationKind)) {
            signatureId = params.getDeterministicId();
        }
        for (int ii = 0; ii < signatureNodeList.getLength(); ++ii) {
            this.currentSignatureDom = (Element)signatureNodeList.item(ii);
            String currentSignatureId = this.currentSignatureDom.getAttribute(XMLDSigAttribute.ID.getAttributeName());
            if (signatureId != null && !signatureId.equals(currentSignatureId)) continue;
            this.xadesSignature = new XAdESSignature(this.currentSignatureDom, Arrays.asList(new XAdES111Paths(), new XAdES122Paths(), new XAdES132Paths()));
            this.xadesSignature.setDetachedContents(params.getDetachedContents());
            this.xadesSignature.prepareOfflineCertificateVerifier(this.certificateVerifier);
            this.extendSignatureTag();
        }
        return this.createXmlDocument();
    }

    protected void extendSignatureTag() throws DSSException {
        this.assertExtendSignatureToTPossible();
        this.xadesPaths = this.xadesSignature.getXAdESPaths();
        this.ensureUnsignedProperties();
        this.ensureUnsignedSignatureProperties();
        this.ensureSignedDataObjectProperties();
        this.assertSignatureValid(this.xadesSignature);
        Element levelBUnsignedProperties = (Element)this.unsignedSignaturePropertiesDom.cloneNode(true);
        if (BDocTmSupport.isBdocTmSignatureProfile(this.params)) {
            return;
        }
        if (!this.xadesSignature.hasTProfile() || SignatureLevel.XAdES_BASELINE_T.equals((Object)this.params.getSignatureLevel())) {
            XAdESTimestampParameters signatureTimestampParameters = this.params.getSignatureTimestampParameters();
            String canonicalizationMethod = signatureTimestampParameters.getCanonicalizationMethod();
            byte[] canonicalisedValue = this.xadesSignature.getTimestampSource().getSignatureTimestampData(canonicalizationMethod);
            DigestAlgorithm timestampDigestAlgorithm = signatureTimestampParameters.getDigestAlgorithm();
            byte[] digestValue = DSSUtils.digest((DigestAlgorithm)timestampDigestAlgorithm, (byte[])canonicalisedValue);
            this.createXAdESTimeStampType(TimestampType.SIGNATURE_TIMESTAMP, canonicalizationMethod, digestValue);
            this.unsignedSignaturePropertiesDom = this.indentIfPrettyPrint(this.unsignedSignaturePropertiesDom, levelBUnsignedProperties);
        }
    }

    private void assertExtendSignatureToTPossible() {
        SignatureLevel signatureLevel = this.params.getSignatureLevel();
        if (SignatureLevel.XAdES_BASELINE_T.equals((Object)signatureLevel) && (this.xadesSignature.hasLTProfile() || this.xadesSignature.hasLTAProfile())) {
            String exceptionMessage = "Cannot extend signature. The signedData is already extended with [%s].";
            throw new DSSException(String.format("Cannot extend signature. The signedData is already extended with [%s].", "XAdES LT"));
        }
    }

    public void setTspSource(TSPSource tspSource) {
        this.tspSource = tspSource;
    }

    protected ValidationDataForInclusion getValidationDataForInclusion(ValidationContext validationContext) {
        ValidationDataForInclusionBuilder validationDataForInclusionBuilder = new ValidationDataForInclusionBuilder(validationContext, this.xadesSignature.getCompleteCertificateSource()).excludeCertificateTokens((Collection)this.xadesSignature.getCertificateSource().getCertificates()).excludeCRLs((Collection)this.xadesSignature.getCRLSource().getAllRevocationBinaries()).excludeOCSPs((Collection)this.xadesSignature.getOCSPSource().getAllRevocationBinaries());
        return validationDataForInclusionBuilder.build();
    }

    protected Element incorporateCertificateValues(Element parentDom, Collection<CertificateToken> certificatesToBeAdded) {
        Element certificateValuesDom = null;
        if (Utils.isCollectionNotEmpty(certificatesToBeAdded)) {
            certificateValuesDom = DomUtils.addElement((Document)this.documentDom, (Element)parentDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementCertificateValues());
            int responderCertCounter = 0;
            for (CertificateToken certificateToken : certificatesToBeAdded) {
                boolean isCaCert;
                String base64EncodeCertificate = Utils.toBase64((byte[])certificateToken.getEncoded());
                Element element = DomUtils.addTextElement((Document)this.documentDom, (Element)certificateValuesDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementEncapsulatedX509Certificate(), (String)base64EncodeCertificate);
                boolean bl = isCaCert = certificateToken.getCertificate().getBasicConstraints() != -1;
                if (!DSSASN1Utils.isOCSPSigning((CertificateToken)certificateToken) || isCaCert) continue;
                element.setAttribute("Id", this.xadesSignature.getId() + "-RESPONDER_CERT-" + responderCertCounter);
                ++responderCertCounter;
            }
        }
        return certificateValuesDom;
    }

    protected Element incorporateRevocationValues(Element parentDom, Collection<CRLToken> crlsToAdd, Collection<OCSPToken> ocspsToAdd) {
        Element revocationValuesDom = null;
        if (Utils.isCollectionNotEmpty(crlsToAdd) || Utils.isCollectionNotEmpty(ocspsToAdd)) {
            revocationValuesDom = DomUtils.addElement((Document)this.documentDom, (Element)parentDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementRevocationValues());
            this.incorporateCrlTokens(revocationValuesDom, crlsToAdd);
            this.incorporateOcspTokens(revocationValuesDom, ocspsToAdd);
        }
        return revocationValuesDom;
    }

    private void incorporateCrlTokens(Element parentDom, Collection<CRLToken> crlTokens) {
        if (crlTokens.isEmpty()) {
            return;
        }
        Element crlValuesDom = DomUtils.addElement((Document)this.documentDom, (Element)parentDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementCRLValues());
        for (RevocationToken revocationToken : crlTokens) {
            byte[] encodedCRL = revocationToken.getEncoded();
            String base64EncodedCRL = Utils.toBase64((byte[])encodedCRL);
            DomUtils.addTextElement((Document)this.documentDom, (Element)crlValuesDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementEncapsulatedCRLValue(), (String)base64EncodedCRL);
        }
    }

    private void incorporateOcspTokens(Element parentDom, Collection<OCSPToken> ocspTokens) {
        if (ocspTokens.isEmpty()) {
            return;
        }
        Element ocspValuesDom = DomUtils.addElement((Document)this.documentDom, (Element)parentDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementOCSPValues());
        for (RevocationToken revocationToken : ocspTokens) {
            byte[] encodedOCSP = revocationToken.getEncoded();
            String base64EncodedOCSP = Utils.toBase64((byte[])encodedOCSP);
            DomUtils.addTextElement((Document)this.documentDom, (Element)ocspValuesDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementEncapsulatedOCSPValue(), (String)base64EncodedOCSP);
        }
    }

    protected void incorporateCertificateValues(Element parentDom, Collection<CertificateToken> certificatesToBeAdded, String indent) {
        Element certificatesDom = this.incorporateCertificateValues(parentDom, certificatesToBeAdded);
        if (certificatesDom != null && indent != null) {
            DomUtils.setTextNode((Document)this.documentDom, (Element)this.unsignedSignaturePropertiesDom, (String)indent);
            DSSXMLUtils.indentAndReplace(this.documentDom, certificatesDom);
        }
    }

    protected void incorporateRevocationValues(Element parentDom, Collection<CRLToken> crlsToAdd, Collection<OCSPToken> ocspsToAdd, String indent) {
        Element revocationDom = this.incorporateRevocationValues(parentDom, crlsToAdd, ocspsToAdd);
        if (revocationDom != null && indent != null) {
            DomUtils.setTextNode((Document)this.documentDom, (Element)this.unsignedSignaturePropertiesDom, (String)indent);
            DSSXMLUtils.indentAndReplace(this.documentDom, revocationDom);
        }
    }

    protected void createXAdESTimeStampType(TimestampType timestampType, String timestampC14nMethod, byte[] digestValue) throws DSSException {
        if ((XAdESNamespaces.XADES_111.isSameUri(this.getXadesNamespace().getUri()) || XAdESNamespaces.XADES_122.isSameUri(this.getXadesNamespace().getUri())) && TimestampType.SIGNATURE_TIMESTAMP != timestampType) {
            throw new DSSException("Signature Timestamp creation is only supported for XAdES 1.1.1 and 1.2.2");
        }
        Element timeStampDom = null;
        XAdESTimestampParameters signatureTimestampParameters = this.params.getSignatureTimestampParameters();
        DigestAlgorithm timestampDigestAlgorithm = signatureTimestampParameters.getDigestAlgorithm();
        switch (timestampType) {
            case SIGNATURE_TIMESTAMP: {
                timeStampDom = DomUtils.addElement((Document)this.documentDom, (Element)this.unsignedSignaturePropertiesDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementSignatureTimeStamp());
                break;
            }
            case VALIDATION_DATA_TIMESTAMP: {
                if (this.params.isEn319132() && !this.isOldGeneration(this.params.getSignatureLevel())) {
                    timeStampDom = DomUtils.addElement((Document)this.documentDom, (Element)this.unsignedSignaturePropertiesDom, (DSSNamespace)this.getXades141Namespace(), (DSSElement)XAdES141Element.SIG_AND_REFS_TIMESTAMP_V2);
                    break;
                }
                timeStampDom = DomUtils.addElement((Document)this.documentDom, (Element)this.unsignedSignaturePropertiesDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementSigAndRefsTimeStamp());
                break;
            }
            case ARCHIVE_TIMESTAMP: {
                timeStampDom = DomUtils.addElement((Document)this.documentDom, (Element)this.unsignedSignaturePropertiesDom, (DSSNamespace)this.getXades141Namespace(), (DSSElement)XAdES141Element.ARCHIVE_TIMESTAMP);
                timestampDigestAlgorithm = this.params.getArchiveTimestampParameters().getDigestAlgorithm();
                break;
            }
            default: {
                throw new DSSException("Unsupported timestamp type : " + timestampType);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Timestamp generation: {} / {} / {}", new Object[]{timestampDigestAlgorithm.getName(), timestampC14nMethod, Utils.toBase64((byte[])digestValue)});
        }
        TimestampBinary timeStampToken = this.tspSource.getTimeStampResponse(timestampDigestAlgorithm, digestValue);
        String base64EncodedTimeStampToken = Utils.toBase64((byte[])DSSASN1Utils.getDEREncoded((TimestampBinary)timeStampToken));
        if (XAdESNamespaces.XADES_122.isSameUri(this.getXadesNamespace().getUri())) {
            this.incorporateXAdES122Include(timeStampDom);
        }
        String timestampId = UUID.randomUUID().toString();
        if (!XAdESNamespaces.XADES_111.isSameUri(this.getXadesNamespace().getUri())) {
            timeStampDom.setAttribute(XMLDSigAttribute.ID.getAttributeName(), "TS-" + timestampId);
            this.incorporateC14nMethod(timeStampDom, timestampC14nMethod);
        } else {
            this.incorporateHashDataInfo(timeStampDom, timestampC14nMethod);
        }
        Element encapsulatedTimeStampDom = DomUtils.addElement((Document)this.documentDom, (Element)timeStampDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementEncapsulatedTimeStamp());
        encapsulatedTimeStampDom.setAttribute(XMLDSigAttribute.ID.getAttributeName(), "ETS-" + timestampId);
        DomUtils.setTextNode((Document)this.documentDom, (Element)encapsulatedTimeStampDom, (String)base64EncodedTimeStampToken);
    }

    private void incorporateHashDataInfo(Element timeStampDom, String timestampC14nMethod) {
        Element hashDataInfoDom = DomUtils.addElement((Document)this.documentDom, (Element)timeStampDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)XAdES111Element.HASH_DATA_INFO);
        hashDataInfoDom.setAttribute(XAdES111Attribute.URI.getAttributeName(), '#' + this.xadesSignature.getId());
        Element transformsDom = DomUtils.addElement((Document)this.documentDom, (Element)hashDataInfoDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)XAdES111Element.TRANSFORMS);
        Element transformDom = DomUtils.addElement((Document)this.documentDom, (Element)transformsDom, (DSSNamespace)this.getXmldsigNamespace(), (DSSElement)XMLDSigElement.TRANSFORM);
        transformDom.setAttribute(XMLDSigAttribute.ALGORITHM.getAttributeName(), timestampC14nMethod);
    }

    private void incorporateXAdES122Include(Element timeStampDom) {
        Element includeDom = DomUtils.addElement((Document)this.documentDom, (Element)timeStampDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)XAdES122Element.INCLUDE);
        includeDom.setAttribute(XAdES122Attribute.URI.getAttributeName(), '#' + this.xadesSignature.getSignatureValueId());
    }

    private boolean isOldGeneration(SignatureLevel signatureLevel) {
        return SignatureLevel.XAdES_X.equals((Object)signatureLevel) || SignatureLevel.XAdES_XL.equals((Object)signatureLevel) || SignatureLevel.XAdES_A.equals((Object)signatureLevel);
    }
}

