/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.definition.DSSElement;
import eu.europa.esig.dss.definition.DSSNamespace;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.Token;
import eu.europa.esig.dss.model.x509.revocation.Revocation;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.x509.ResponderId;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.xades.signature.XAdESLevelBaselineT;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.RespID;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XAdESLevelC
extends XAdESLevelBaselineT {
    public XAdESLevelC(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    private void incorporateCRLRefs(Element completeRevocationRefsDom, Set<RevocationToken<Revocation>> processedRevocationTokens) throws DSSException {
        RevocationToken<Revocation> revocationToken;
        if (processedRevocationTokens.isEmpty()) {
            return;
        }
        boolean containsCrlToken = false;
        Iterator<RevocationToken<Revocation>> iterator = processedRevocationTokens.iterator();
        while (iterator.hasNext() && !(containsCrlToken = (revocationToken = iterator.next()) instanceof CRLToken)) {
        }
        if (!containsCrlToken) {
            return;
        }
        Element crlRefsDom = DomUtils.addElement((Document)this.documentDom, (Element)completeRevocationRefsDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementCRLRefs());
        for (RevocationToken<Revocation> revocationToken2 : processedRevocationTokens) {
            if (!(revocationToken2 instanceof CRLToken)) continue;
            CRLToken crl = (CRLToken)revocationToken2;
            Element crlRefDom = DomUtils.addElement((Document)this.documentDom, (Element)crlRefsDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementCRLRef());
            Element digestAlgAndValueDom = DomUtils.addElement((Document)this.documentDom, (Element)crlRefDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementDigestAlgAndValue());
            DigestAlgorithm digestAlgorithm = DigestAlgorithm.SHA1;
            this.incorporateDigestMethod(digestAlgAndValueDom, digestAlgorithm);
            this.incorporateDigestValue(digestAlgAndValueDom, digestAlgorithm, (Token)revocationToken2);
            Element crlIdentifierDom = DomUtils.addElement((Document)this.documentDom, (Element)crlRefDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementCRLIdentifier());
            String issuerX500PrincipalName = crl.getIssuerX500Principal().getName();
            DomUtils.addTextElement((Document)this.documentDom, (Element)crlIdentifierDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementIssuer(), (String)issuerX500PrincipalName);
            Date thisUpdate = crl.getThisUpdate();
            XMLGregorianCalendar xmlGregorianCalendar = DomUtils.createXMLGregorianCalendar((Date)thisUpdate);
            String thisUpdateAsXmlFormat = xmlGregorianCalendar.toXMLFormat();
            DomUtils.addTextElement((Document)this.documentDom, (Element)crlIdentifierDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementIssueTime(), (String)thisUpdateAsXmlFormat);
        }
    }

    private void incorporateOCSPRefs(Element completeRevocationRefsDom, Set<RevocationToken<Revocation>> processedRevocationTokens) throws DSSException {
        RevocationToken<Revocation> revocationToken;
        if (processedRevocationTokens.isEmpty()) {
            return;
        }
        boolean containsOCSPToken = false;
        Iterator<RevocationToken<Revocation>> iterator = processedRevocationTokens.iterator();
        while (iterator.hasNext() && !(containsOCSPToken = (revocationToken = iterator.next()) instanceof OCSPToken)) {
        }
        if (!containsOCSPToken) {
            return;
        }
        Element ocspRefsDom = DomUtils.addElement((Document)this.documentDom, (Element)completeRevocationRefsDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementOCSPRefs());
        for (RevocationToken<Revocation> revocationToken2 : processedRevocationTokens) {
            BasicOCSPResp basicOcspResp;
            if (!(revocationToken2 instanceof OCSPToken) || (basicOcspResp = ((OCSPToken)revocationToken2).getBasicOCSPResp()) == null) continue;
            Element ocspRefDom = DomUtils.addElement((Document)this.documentDom, (Element)ocspRefsDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementOCSPRef());
            Element ocspIdentifierDom = DomUtils.addElement((Document)this.documentDom, (Element)ocspRefDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementOCSPIdentifier());
            Element responderIDDom = DomUtils.addElement((Document)this.documentDom, (Element)ocspIdentifierDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementResponderID());
            RespID respID = basicOcspResp.getResponderId();
            ResponderId responderId = DSSRevocationUtils.getDSSResponderId((RespID)respID);
            if (responderId.getX500Principal() != null) {
                DomUtils.addTextElement((Document)this.documentDom, (Element)responderIDDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementByName(), (String)responderId.getX500Principal().toString());
            } else {
                String base64EncodedKeyHashOctetStringBytes = Utils.toBase64((byte[])responderId.getSki());
                DomUtils.addTextElement((Document)this.documentDom, (Element)responderIDDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementByKey(), (String)base64EncodedKeyHashOctetStringBytes);
            }
            Date producedAt = basicOcspResp.getProducedAt();
            XMLGregorianCalendar xmlGregorianCalendar = DomUtils.createXMLGregorianCalendar((Date)producedAt);
            String producedAtXmlEncoded = xmlGregorianCalendar.toXMLFormat();
            DomUtils.addTextElement((Document)this.documentDom, (Element)ocspIdentifierDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementProducedAt(), (String)producedAtXmlEncoded);
            Element digestAlgAndValueDom = DomUtils.addElement((Document)this.documentDom, (Element)ocspRefDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementDigestAlgAndValue());
            DigestAlgorithm digestAlgorithm = DigestAlgorithm.SHA1;
            this.incorporateDigestMethod(digestAlgAndValueDom, digestAlgorithm);
            this.incorporateDigestValue(digestAlgAndValueDom, digestAlgorithm, (Token)revocationToken2);
        }
    }

    @Override
    protected void extendSignatureTag() throws DSSException {
        super.extendSignatureTag();
        Element levelTUnsignedProperties = (Element)this.unsignedSignaturePropertiesDom.cloneNode(true);
        SignatureLevel signatureLevel = this.params.getSignatureLevel();
        if (!this.xadesSignature.hasCProfile() || SignatureLevel.XAdES_C.equals((Object)signatureLevel) || SignatureLevel.XAdES_XL.equals((Object)signatureLevel)) {
            ValidationContext validationContext = this.xadesSignature.getSignatureValidationContext(this.certificateVerifier);
            Element toRemove = this.xadesSignature.getCompleteCertificateRefs();
            this.removeChild(this.unsignedSignaturePropertiesDom, toRemove);
            Element completeCertificateRefsDom = DomUtils.addElement((Document)this.documentDom, (Element)this.unsignedSignaturePropertiesDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementCompleteCertificateRefs());
            Element certRefsDom = DomUtils.addElement((Document)this.documentDom, (Element)completeCertificateRefsDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementCertRefs());
            CertificateToken certificateToken = this.xadesSignature.getSigningCertificateToken();
            Set processedCertificateTokens = validationContext.getProcessedCertificates();
            HashSet<CertificateToken> processedCertificateTokenList = new HashSet<CertificateToken>();
            processedCertificateTokenList.addAll(processedCertificateTokens);
            processedCertificateTokenList.remove(certificateToken);
            HashSet<CertificateToken> x509CertificateProcessedList = processedCertificateTokenList;
            this.incorporateCertificateRef(certRefsDom, x509CertificateProcessedList);
            toRemove = this.xadesSignature.getCompleteRevocationRefs();
            this.removeChild(this.unsignedSignaturePropertiesDom, toRemove);
            Element completeRevocationRefsDom = DomUtils.addElement((Document)this.documentDom, (Element)this.unsignedSignaturePropertiesDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementCompleteRevocationRefs());
            this.incorporateCRLRefs(completeRevocationRefsDom, validationContext.getProcessedRevocations());
            this.incorporateOCSPRefs(completeRevocationRefsDom, validationContext.getProcessedRevocations());
            this.unsignedSignaturePropertiesDom = this.indentIfPrettyPrint(this.unsignedSignaturePropertiesDom, levelTUnsignedProperties);
        }
    }
}

