/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.CertificateIdentifier;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.definition.XAdESPaths;
import java.math.BigInteger;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class XAdESCertificateRefExtractionUtils {
    private XAdESCertificateRefExtractionUtils() {
    }

    public static CertificateRef createCertificateRefFromV1(Element certRefElement, XAdESPaths xadesPaths) {
        Digest certDigest;
        if (certRefElement != null && (certDigest = DSSXMLUtils.getDigestAndValue(DomUtils.getElement((Node)certRefElement, (String)xadesPaths.getCurrentCertDigest()))) != null) {
            CertificateRef certRef = new CertificateRef();
            certRef.setCertDigest(certDigest);
            certRef.setCertificateIdentifier(XAdESCertificateRefExtractionUtils.getCertificateIdentifierV1(certRefElement, xadesPaths));
            return certRef;
        }
        return null;
    }

    public static CertificateRef createCertificateRefFromV2(Element certRefElement, XAdESPaths xadesPaths) {
        Digest certDigest;
        if (certRefElement != null && (certDigest = DSSXMLUtils.getDigestAndValue(DomUtils.getElement((Node)certRefElement, (String)xadesPaths.getCurrentCertDigest()))) != null) {
            CertificateRef certRef = new CertificateRef();
            certRef.setCertDigest(certDigest);
            certRef.setCertificateIdentifier(XAdESCertificateRefExtractionUtils.getCertificateIdentifierV2(certRefElement, xadesPaths));
            return certRef;
        }
        return null;
    }

    private static CertificateIdentifier getCertificateIdentifierV1(Element certRefElement, XAdESPaths xadesPaths) {
        Element serialNumberEl;
        CertificateIdentifier certificateIdentifier = new CertificateIdentifier();
        Element issuerNameEl = DomUtils.getElement((Node)certRefElement, (String)xadesPaths.getCurrentIssuerSerialIssuerNamePath());
        if (issuerNameEl != null) {
            certificateIdentifier.setIssuerName(DSSUtils.getX500PrincipalOrNull((String)issuerNameEl.getTextContent()));
        }
        if ((serialNumberEl = DomUtils.getElement((Node)certRefElement, (String)xadesPaths.getCurrentIssuerSerialSerialNumberPath())) != null) {
            String serialNumberText = serialNumberEl.getTextContent();
            certificateIdentifier.setSerialNumber(new BigInteger(serialNumberText.trim()));
        }
        return certificateIdentifier;
    }

    private static CertificateIdentifier getCertificateIdentifierV2(Element certRefElement, XAdESPaths xadesPaths) {
        Element issuerSerialV2Element = DomUtils.getElement((Node)certRefElement, (String)xadesPaths.getCurrentIssuerSerialV2Path());
        if (issuerSerialV2Element == null) {
            return null;
        }
        String textContent = issuerSerialV2Element.getTextContent();
        IssuerSerial issuerSerial = DSSASN1Utils.getIssuerSerial((byte[])Utils.fromBase64((String)textContent));
        return DSSASN1Utils.toCertificateIdentifier((IssuerSerial)issuerSerial);
    }
}

