/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigPaths;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.timestamp.TimestampDataBuilder;
import eu.europa.esig.dss.validation.timestamp.TimestampInclude;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.definition.XAdESPaths;
import eu.europa.esig.dss.xades.definition.xades132.XAdES132Element;
import eu.europa.esig.dss.xades.definition.xades141.XAdES141Element;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XAdESTimestampDataBuilder
implements TimestampDataBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESTimestampDataBuilder.class);
    private final List<Reference> references;
    private final Element signature;
    private final XAdESPaths xadesPaths;

    public XAdESTimestampDataBuilder(Element signature, List<Reference> references, XAdESPaths xadesPaths) {
        this.signature = signature;
        this.references = references;
        this.xadesPaths = xadesPaths;
    }

    public DSSDocument getContentTimestampData(TimestampToken timestampToken) {
        InMemoryDocument inMemoryDocument;
        TimestampType timeStampType = timestampToken.getTimeStampType();
        if (!timeStampType.isContentTimestamp()) {
            return null;
        }
        if (!this.checkTimestampTokenIncludes(timestampToken)) {
            throw new DSSException("The Included referencedData attribute is either not present or set to false!");
        }
        if (this.references.isEmpty()) {
            throw new DSSException("The method 'checkSignatureIntegrity' must be invoked first!");
        }
        String canonicalizationMethod = timestampToken.getCanonicalizationMethod();
        List includes = timestampToken.getTimestampIncludes();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            for (Reference reference : this.references) {
                if (!this.isContentTimestampedReference(reference, timeStampType, includes)) continue;
                byte[] referenceBytes = this.getReferenceBytes(reference, canonicalizationMethod);
                outputStream.write(referenceBytes);
            }
            byte[] byteArray = outputStream.toByteArray();
            if (LOG.isTraceEnabled()) {
                LOG.trace("IndividualDataObjectsTimestampData/AllDataObjectsTimestampData bytes: {}", (Object)new String(byteArray));
            }
            inMemoryDocument = new InMemoryDocument(byteArray);
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | XMLSecurityException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn("Unable to extract IndividualDataObjectsTimestampData/AllDataObjectsTimestampData. Reason : {}", (Object)e.getMessage(), (Object)e);
                } else {
                    LOG.warn("Unable to extract IndividualDataObjectsTimestampData/AllDataObjectsTimestampData. Reason : {}", (Object)e.getMessage());
                }
                return null;
            }
        }
        outputStream.close();
        return inMemoryDocument;
    }

    private byte[] getReferenceBytes(Reference reference, String canonicalizationMethod) throws XMLSecurityException {
        byte[] referencedBytes = reference.getReferencedBytes();
        if (DomUtils.isDOM((byte[])referencedBytes)) {
            referencedBytes = DSSXMLUtils.canonicalize(canonicalizationMethod, referencedBytes);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("ReferencedBytes : {}", (Object)new String(referencedBytes));
        }
        return referencedBytes;
    }

    private boolean checkTimestampTokenIncludes(TimestampToken timestampToken) {
        List timestampIncludes = timestampToken.getTimestampIncludes();
        if (Utils.isCollectionNotEmpty((Collection)timestampIncludes)) {
            for (TimestampInclude timestampInclude : timestampIncludes) {
                if (timestampInclude.isReferencedData()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isContentTimestampedReference(Reference reference, TimestampType timeStampType, List<TimestampInclude> includes) {
        if (TimestampType.ALL_DATA_OBJECTS_TIMESTAMP.equals((Object)timeStampType)) {
            return !DSSXMLUtils.isSignedProperties(reference, this.xadesPaths);
        }
        for (TimestampInclude timestampInclude : includes) {
            String id = timestampInclude.getURI();
            if (!reference.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    public DSSDocument getSignatureTimestampData(TimestampToken timestampToken) {
        byte[] timestampData = this.getSignatureTimestampData(timestampToken, null);
        return new InMemoryDocument(timestampData);
    }

    public byte[] getSignatureTimestampData(String canonicalizationMethod) {
        return this.getSignatureTimestampData(null, canonicalizationMethod);
    }

    protected byte[] getSignatureTimestampData(TimestampToken timestampToken, String canonicalizationMethod) {
        byte[] byArray;
        canonicalizationMethod = timestampToken != null ? timestampToken.getCanonicalizationMethod() : canonicalizationMethod;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            this.writeCanonicalizedValue(XMLDSigPaths.SIGNATURE_VALUE_PATH, canonicalizationMethod, buffer);
            byte[] byteArray = buffer.toByteArray();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Signature timestamp canonicalized string : \n{}", (Object)new String(byteArray));
            }
            byArray = byteArray;
        }
        catch (Throwable throwable) {
            try {
                try {
                    buffer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException("Error when computing the SignatureTimestamp", (Throwable)e);
            }
        }
        buffer.close();
        return byArray;
    }

    public DSSDocument getTimestampX1Data(TimestampToken timestampToken) {
        byte[] timestampX1Data = this.getTimestampX1Data(timestampToken, null);
        return new InMemoryDocument(timestampX1Data);
    }

    public byte[] getTimestampX1Data(String canonicalizationMethod) {
        return this.getTimestampX1Data(null, canonicalizationMethod);
    }

    protected byte[] getTimestampX1Data(TimestampToken timestampToken, String canonicalizationMethod) {
        byte[] byArray;
        canonicalizationMethod = timestampToken != null ? timestampToken.getCanonicalizationMethod() : canonicalizationMethod;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            this.writeCanonicalizedValue(XMLDSigPaths.SIGNATURE_VALUE_PATH, canonicalizationMethod, buffer);
            NodeList signatureTimeStampNode = DomUtils.getNodeList((Node)this.signature, (String)this.xadesPaths.getSignatureTimestampsPath());
            if (signatureTimeStampNode != null) {
                for (int ii = 0; ii < signatureTimeStampNode.getLength(); ++ii) {
                    Node item = signatureTimeStampNode.item(ii);
                    byte[] canonicalizedValue = DSSXMLUtils.canonicalizeSubtree(canonicalizationMethod, item);
                    buffer.write(canonicalizedValue);
                }
            }
            this.writeCanonicalizedValue(this.xadesPaths.getCompleteCertificateRefsPath(), canonicalizationMethod, buffer);
            this.writeCanonicalizedValue(this.xadesPaths.getCompleteRevocationRefsPath(), canonicalizationMethod, buffer);
            byte[] byteArray = buffer.toByteArray();
            if (LOG.isTraceEnabled()) {
                LOG.trace("X1Timestamp (SigAndRefsTimeStamp) canonicalised string : \n{}", (Object)new String(byteArray));
            }
            byArray = byteArray;
        }
        catch (Throwable throwable) {
            try {
                try {
                    buffer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException("Error when computing the SigAndRefsTimeStamp (X1Timestamp)", (Throwable)e);
            }
        }
        buffer.close();
        return byArray;
    }

    public DSSDocument getTimestampX2Data(TimestampToken timestampToken) {
        byte[] timestampX2Data = this.getTimestampX2Data(timestampToken, null);
        return new InMemoryDocument(timestampX2Data);
    }

    public byte[] getTimestampX2Data(String canonicalizationMethod) {
        return this.getTimestampX2Data(null, canonicalizationMethod);
    }

    protected byte[] getTimestampX2Data(TimestampToken timestampToken, String canonicalizationMethod) {
        byte[] byArray;
        canonicalizationMethod = timestampToken != null ? timestampToken.getCanonicalizationMethod() : canonicalizationMethod;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            this.writeCanonicalizedValue(this.xadesPaths.getCompleteCertificateRefsPath(), canonicalizationMethod, buffer);
            this.writeCanonicalizedValue(this.xadesPaths.getCompleteRevocationRefsPath(), canonicalizationMethod, buffer);
            byte[] byteArray = buffer.toByteArray();
            if (LOG.isTraceEnabled()) {
                LOG.trace("TimestampX2Data (RefsOnlyTimeStamp) canonicalised string : \n{}", (Object)new String(byteArray));
            }
            byArray = byteArray;
        }
        catch (Throwable throwable) {
            try {
                try {
                    buffer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException("Error when computing the RefsOnlyTimeStamp (TimestampX2D)", (Throwable)e);
            }
        }
        buffer.close();
        return byArray;
    }

    public DSSDocument getArchiveTimestampData(TimestampToken timestampToken) {
        try {
            byte[] archiveTimestampData = this.getArchiveTimestampData(timestampToken, null);
            return new InMemoryDocument(archiveTimestampData);
        }
        catch (DSSException e) {
            LOG.error("Unable to get data for TimestampToken with Id '{}'. Reason : {}", new Object[]{timestampToken.getDSSIdAsString(), e.getMessage(), e});
            return null;
        }
    }

    public byte[] getArchiveTimestampData(String canonicalizationMethod) {
        return this.getArchiveTimestampData(null, canonicalizationMethod);
    }

    protected byte[] getArchiveTimestampData(TimestampToken timestampToken, String canonicalizationMethod) {
        byte[] byArray;
        if (LOG.isTraceEnabled()) {
            LOG.trace("--->Get archive timestamp data : {}", (Object)(timestampToken == null ? "--> CREATION" : "--> VALIDATION"));
        }
        canonicalizationMethod = timestampToken != null ? timestampToken.getCanonicalizationMethod() : canonicalizationMethod;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            HashSet<String> referenceURIs = new HashSet<String>();
            for (Reference reference : this.references) {
                referenceURIs.add(DomUtils.getId((String)reference.getURI()));
                this.writeReferenceBytes(reference, buffer);
            }
            this.writeCanonicalizedValue(XMLDSigPaths.SIGNED_INFO_PATH, canonicalizationMethod, buffer);
            this.writeCanonicalizedValue(XMLDSigPaths.SIGNATURE_VALUE_PATH, canonicalizationMethod, buffer);
            this.writeCanonicalizedValue(XMLDSigPaths.KEY_INFO_PATH, canonicalizationMethod, buffer);
            Element unsignedSignaturePropertiesDom = this.getUnsignedSignaturePropertiesDom();
            if (unsignedSignaturePropertiesDom == null) {
                throw new NullPointerException(this.xadesPaths.getUnsignedSignaturePropertiesPath());
            }
            this.writeTimestampedUnsignedProperties(unsignedSignaturePropertiesDom, timestampToken, canonicalizationMethod, buffer);
            boolean xades141 = timestampToken == null || !ArchiveTimestampType.XAdES.equals((Object)timestampToken.getArchiveTimestampType());
            NodeList objects = this.getObjects();
            this.writeObjectBytes(objects, referenceURIs, canonicalizationMethod, xades141, buffer);
            byte[] bytes = buffer.toByteArray();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Data to TimeStamp:");
                LOG.trace(new String(bytes));
            }
            byArray = bytes;
        }
        catch (Throwable throwable) {
            try {
                try {
                    buffer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new DSSException(String.format("An error occurred while building a message imprint data. Reason : %s", e.getMessage()), (Throwable)e);
            }
        }
        buffer.close();
        return byArray;
    }

    private void writeReferenceBytes(Reference reference, ByteArrayOutputStream buffer) throws IOException {
        try {
            byte[] referencedBytes = reference.getReferencedBytes();
            if (referencedBytes == null) {
                throw new DSSException(String.format("No binaries found for URI '%s'", reference.getURI()));
            }
            buffer.write(referencedBytes);
        }
        catch (XMLSecurityException e) {
            throw new DSSException(String.format("Unable to retrieve content for URI '%s' : %s", reference.getURI(), e.getMessage()), (Throwable)e);
        }
    }

    private void writeCanonicalizedValue(String xPathString, String canonicalizationMethod, ByteArrayOutputStream buffer) throws IOException {
        Element element = DomUtils.getElement((Node)this.signature, (String)xPathString);
        if (element != null) {
            buffer.write(DSSXMLUtils.canonicalizeSubtree(canonicalizationMethod, element));
        }
    }

    private Element getUnsignedSignaturePropertiesDom() {
        return DomUtils.getElement((Node)this.signature, (String)this.xadesPaths.getUnsignedSignaturePropertiesPath());
    }

    private void writeTimestampedUnsignedProperties(Element unsignedSignaturePropertiesDom, TimestampToken timestampToken, String canonicalizationMethod, ByteArrayOutputStream buffer) throws IOException {
        NodeList unsignedProperties = unsignedSignaturePropertiesDom.getChildNodes();
        for (int ii = 0; ii < unsignedProperties.getLength(); ++ii) {
            byte[] canonicalizedValue;
            Node node = unsignedProperties.item(ii);
            if (node.getNodeType() != 1) continue;
            String localName = node.getLocalName();
            if (XAdES132Element.ARCHIVE_TIMESTAMP.isSameTagName(localName)) {
                if (timestampToken != null && timestampToken.getHashCode() == node.hashCode()) {
                    break;
                }
            } else if (XAdES141Element.TIMESTAMP_VALIDATION_DATA.isSameTagName(localName)) {
                // empty if block
            }
            if (timestampToken == null) {
                byte[] bytesToCanonicalize = DSSXMLUtils.serializeNode(node);
                canonicalizedValue = DSSXMLUtils.canonicalize(canonicalizationMethod, bytesToCanonicalize);
            } else {
                canonicalizedValue = DSSXMLUtils.canonicalizeSubtree(canonicalizationMethod, node);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("{}: Canonicalization: {} : \n{}", new Object[]{localName, canonicalizationMethod, new String(canonicalizedValue)});
            }
            buffer.write(canonicalizedValue);
        }
    }

    private NodeList getObjects() {
        return DomUtils.getNodeList((Node)this.signature, (String)XMLDSigPaths.OBJECT_PATH);
    }

    private void writeObjectBytes(NodeList objects, Set<String> referenceURIs, String canonicalizationMethod, boolean xades141, ByteArrayOutputStream buffer) throws IOException {
        for (int ii = 0; ii < objects.getLength(); ++ii) {
            Node node = objects.item(ii);
            Element qualifyingProperties = DomUtils.getElement((Node)node, (String)this.xadesPaths.getCurrentQualifyingPropertiesPath());
            if (qualifyingProperties != null) continue;
            if (!xades141) {
                boolean contains;
                NamedNodeMap attributes = node.getAttributes();
                int length = attributes.getLength();
                String id = "";
                for (int jj = 0; jj < length; ++jj) {
                    Node item = attributes.item(jj);
                    String nodeName = item.getNodeName();
                    if (!Utils.areStringsEqualIgnoreCase((String)"ID", (String)nodeName)) continue;
                    id = item.getNodeValue();
                    break;
                }
                if (contains = referenceURIs.contains(id)) continue;
            }
            byte[] canonicalizedValue = DSSXMLUtils.canonicalizeSubtree(canonicalizationMethod, node);
            buffer.write(canonicalizedValue);
        }
    }
}

