/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.crl.CRLUtils;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.enumerations.TimestampLocation;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.enumerations.TimestampedObjectType;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.identifier.Identifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.ReferenceValidation;
import eu.europa.esig.dss.validation.SignatureProperties;
import eu.europa.esig.dss.validation.scope.SignatureScope;
import eu.europa.esig.dss.validation.timestamp.AbstractTimestampSource;
import eu.europa.esig.dss.validation.timestamp.TimestampInclude;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.validation.timestamp.TimestampedReference;
import eu.europa.esig.dss.xades.definition.XAdESNamespaces;
import eu.europa.esig.dss.xades.definition.XAdESPaths;
import eu.europa.esig.dss.xades.definition.xades132.XAdES132Element;
import eu.europa.esig.dss.xades.definition.xades141.XAdES141Element;
import eu.europa.esig.dss.xades.validation.XAdESAttribute;
import eu.europa.esig.dss.xades.validation.XAdESCertificateRefExtractionUtils;
import eu.europa.esig.dss.xades.validation.XAdESRevocationRefExtractionUtils;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import eu.europa.esig.dss.xades.validation.XAdESSignedDataObjectProperties;
import eu.europa.esig.dss.xades.validation.XAdESTimestampDataBuilder;
import eu.europa.esig.dss.xades.validation.XAdESUnsignedSigProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.xml.security.signature.Reference;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XAdESTimestampSource
extends AbstractTimestampSource<XAdESAttribute> {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESTimestampSource.class);
    private final transient Element signatureElement;
    private final XAdESPaths xadesPaths;
    private transient List<Reference> references;
    private List<ReferenceValidation> referenceValidations;
    private transient XAdESTimestampDataBuilder timestampDataBuilder;

    public XAdESTimestampSource(XAdESSignature signature, Element signatureElement, XAdESPaths xadesPaths) {
        super((AdvancedSignature)signature);
        this.references = signature.getReferences();
        this.referenceValidations = signature.getReferenceValidations();
        this.signatureElement = signatureElement;
        this.xadesPaths = xadesPaths;
    }

    protected SignatureProperties<XAdESAttribute> getSignedSignatureProperties() {
        return XAdESSignedDataObjectProperties.build(this.signatureElement, this.xadesPaths);
    }

    protected SignatureProperties<XAdESAttribute> getUnsignedSignatureProperties() {
        return XAdESUnsignedSigProperties.build(this.signatureElement, this.xadesPaths);
    }

    protected XAdESTimestampDataBuilder getTimestampDataBuilder() {
        if (this.timestampDataBuilder == null) {
            this.timestampDataBuilder = new XAdESTimestampDataBuilder(this.signatureElement, this.references, this.xadesPaths);
        }
        return this.timestampDataBuilder;
    }

    public byte[] getSignatureTimestampData(String canonicalizationMethod) {
        return this.timestampDataBuilder.getSignatureTimestampData(canonicalizationMethod);
    }

    public byte[] getTimestampX1Data(String canonicalizationMethod) {
        return this.timestampDataBuilder.getTimestampX1Data(canonicalizationMethod);
    }

    public byte[] getTimestampX2Data(String canonicalizationMethod) {
        return this.timestampDataBuilder.getTimestampX2Data(canonicalizationMethod);
    }

    public byte[] getArchiveTimestampData(String canonicalizationMethod) {
        return this.timestampDataBuilder.getArchiveTimestampData(canonicalizationMethod);
    }

    protected boolean isContentTimestamp(XAdESAttribute signedAttribute) {
        return false;
    }

    protected boolean isAllDataObjectsTimestamp(XAdESAttribute signedAttribute) {
        return XAdES132Element.ALL_DATA_OBJECTS_TIMESTAMP.isSameTagName(signedAttribute.getName());
    }

    protected boolean isIndividualDataObjectsTimestamp(XAdESAttribute signedAttribute) {
        return XAdES132Element.INDIVIDUAL_DATA_OBJECTS_TIMESTAMP.isSameTagName(signedAttribute.getName());
    }

    protected boolean isSignatureTimestamp(XAdESAttribute unsignedAttribute) {
        return XAdES132Element.SIGNATURE_TIMESTAMP.isSameTagName(unsignedAttribute.getName());
    }

    protected boolean isCompleteCertificateRef(XAdESAttribute unsignedAttribute) {
        String localName = unsignedAttribute.getName();
        return XAdES132Element.COMPLETE_CERTIFICATE_REFS.isSameTagName(localName) || XAdES141Element.COMPLETE_CERTIFICATE_REFS_V2.isSameTagName(localName);
    }

    protected boolean isAttributeCertificateRef(XAdESAttribute unsignedAttribute) {
        String localName = unsignedAttribute.getName();
        return XAdES132Element.ATTRIBUTE_CERTIFICATE_REFS.isSameTagName(localName) || XAdES141Element.ATTRIBUTE_CERTIFICATE_REFS_V2.isSameTagName(localName);
    }

    protected boolean isCompleteRevocationRef(XAdESAttribute unsignedAttribute) {
        return XAdES132Element.COMPLETE_REVOCATION_REFS.isSameTagName(unsignedAttribute.getName());
    }

    protected boolean isAttributeRevocationRef(XAdESAttribute unsignedAttribute) {
        return XAdES132Element.ATTRIBUTE_REVOCATION_REFS.isSameTagName(unsignedAttribute.getName());
    }

    protected boolean isRefsOnlyTimestamp(XAdESAttribute unsignedAttribute) {
        String localName = unsignedAttribute.getName();
        return XAdES132Element.REFS_ONLY_TIMESTAMP.isSameTagName(localName) || XAdES141Element.REFS_ONLY_TIMESTAMP_V2.isSameTagName(localName);
    }

    protected boolean isSigAndRefsTimestamp(XAdESAttribute unsignedAttribute) {
        String localName = unsignedAttribute.getName();
        return XAdES132Element.SIG_AND_REFS_TIMESTAMP.isSameTagName(localName) || XAdES141Element.SIG_AND_REFS_TIMESTAMP_V2.isSameTagName(localName);
    }

    protected boolean isCertificateValues(XAdESAttribute unsignedAttribute) {
        return XAdES132Element.CERTIFICATE_VALUES.isSameTagName(unsignedAttribute.getName());
    }

    protected boolean isRevocationValues(XAdESAttribute unsignedAttribute) {
        return XAdES132Element.REVOCATION_VALUES.isSameTagName(unsignedAttribute.getName());
    }

    protected boolean isAttrAuthoritiesCertValues(XAdESAttribute unsignedAttribute) {
        return XAdES132Element.ATTR_AUTHORITIES_CERT_VALUES.isSameTagName(unsignedAttribute.getName());
    }

    protected boolean isAttributeRevocationValues(XAdESAttribute unsignedAttribute) {
        return XAdES132Element.ATTRIBUTE_REVOCATION_VALUES.isSameTagName(unsignedAttribute.getName());
    }

    protected boolean isArchiveTimestamp(XAdESAttribute unsignedAttribute) {
        return XAdES132Element.ARCHIVE_TIMESTAMP.isSameTagName(unsignedAttribute.getName());
    }

    protected boolean isTimeStampValidationData(XAdESAttribute unsignedAttribute) {
        return XAdES141Element.TIMESTAMP_VALIDATION_DATA.isSameTagName(unsignedAttribute.getName());
    }

    protected TimestampToken makeTimestampToken(XAdESAttribute unsignedAttribute, TimestampType timestampType, List<TimestampedReference> references) {
        Element timestampTokenNode = unsignedAttribute.findElement(this.xadesPaths.getCurrentEncapsulatedTimestamp());
        if (timestampTokenNode == null) {
            LOG.warn("The timestamp {} cannot be extracted from the signature!", (Object)timestampType.name());
            return null;
        }
        TimestampToken timestampToken = null;
        try {
            timestampToken = new TimestampToken(Utils.fromBase64((String)timestampTokenNode.getTextContent()), timestampType, references, TimestampLocation.XAdES);
        }
        catch (Exception e) {
            LOG.warn("Unable to build timestamp token from binaries '{}'. Reason : {}", new Object[]{timestampTokenNode.getTextContent(), e.getMessage(), e});
            return null;
        }
        timestampToken.setHashCode(unsignedAttribute.getElementHashCode());
        timestampToken.setCanonicalizationMethod(unsignedAttribute.getTimestampCanonicalizationMethod());
        timestampToken.setTimestampIncludes(unsignedAttribute.getTimestampIncludedReferences());
        return timestampToken;
    }

    protected List<TimestampedReference> getIndividualContentTimestampedReferences(XAdESAttribute signedAttribute) {
        List<TimestampInclude> includes = signedAttribute.getTimestampIncludedReferences();
        ArrayList<TimestampedReference> timestampReferences = new ArrayList<TimestampedReference>();
        for (Reference reference : this.references) {
            if (!this.isContentTimestampedReference(reference, includes)) continue;
            for (SignatureScope signatureScope : this.signatureScopes) {
                if (!Utils.endsWithIgnoreCase((String)reference.getURI(), (String)signatureScope.getName())) continue;
                this.addReference(timestampReferences, new TimestampedReference(signatureScope.getDSSIdAsString(), TimestampedObjectType.SIGNED_DATA));
            }
        }
        return timestampReferences;
    }

    protected List<TimestampedReference> getArchiveTimestampOtherReferences(TimestampToken timestampToken) {
        return this.getKeyInfoReferences();
    }

    private boolean isContentTimestampedReference(Reference reference, List<TimestampInclude> includes) {
        for (TimestampInclude timestampInclude : includes) {
            if (!reference.getId().equals(timestampInclude.getURI())) continue;
            return true;
        }
        return false;
    }

    public List<TimestampedReference> getSignatureTimestampReferences() {
        List timestampedReferences = super.getSignatureTimestampReferences();
        if (this.isKeyInfoCovered()) {
            this.addReferences(timestampedReferences, this.getKeyInfoReferences());
        }
        return timestampedReferences;
    }

    protected List<TimestampedReference> getKeyInfoReferences() {
        return this.createReferencesForCertificates(this.signatureCertificateSource.getKeyInfoCertificates());
    }

    private boolean isKeyInfoCovered() {
        if (Utils.isCollectionNotEmpty(this.referenceValidations)) {
            for (ReferenceValidation referenceValidation : this.referenceValidations) {
                if (!DigestMatcherType.KEY_INFO.equals((Object)referenceValidation.getType()) || !referenceValidation.isFound() || !referenceValidation.isIntact()) continue;
                return true;
            }
        }
        return false;
    }

    protected List<CertificateRef> getCertificateRefs(XAdESAttribute unsignedAttribute) {
        ArrayList<CertificateRef> certRefs = new ArrayList<CertificateRef>();
        boolean certificateRefV1 = this.isCertificateRefV1(unsignedAttribute);
        NodeList certRefsNodeList = unsignedAttribute.getNodeList(this.xadesPaths.getCurrentCertRefsCertChildren());
        for (int ii = 0; ii < certRefsNodeList.getLength(); ++ii) {
            Element certRefElement = (Element)certRefsNodeList.item(ii);
            CertificateRef certificateRef = null;
            certificateRef = certificateRefV1 ? XAdESCertificateRefExtractionUtils.createCertificateRefFromV1(certRefElement, this.xadesPaths) : XAdESCertificateRefExtractionUtils.createCertificateRefFromV2(certRefElement, this.xadesPaths);
            if (certificateRef == null) continue;
            certRefs.add(certificateRef);
        }
        return certRefs;
    }

    private boolean isCertificateRefV1(XAdESAttribute unsignedAttribute) {
        String localName = unsignedAttribute.getName();
        return XAdES132Element.ATTRIBUTE_CERTIFICATE_REFS.isSameTagName(localName) || XAdES132Element.COMPLETE_CERTIFICATE_REFS.isSameTagName(localName);
    }

    protected List<CRLRef> getCRLRefs(XAdESAttribute unsignedAttribute) {
        ArrayList<CRLRef> crlRefs = new ArrayList<CRLRef>();
        NodeList nodeList = unsignedAttribute.getNodeList(this.xadesPaths.getCurrentCRLRefsChildren());
        for (int ii = 0; ii < nodeList.getLength(); ++ii) {
            Element element = (Element)nodeList.item(ii);
            CRLRef crlRef = XAdESRevocationRefExtractionUtils.createCRLRef(this.xadesPaths, element);
            if (crlRef == null) continue;
            crlRefs.add(crlRef);
        }
        return crlRefs;
    }

    protected List<OCSPRef> getOCSPRefs(XAdESAttribute unsignedAttribute) {
        ArrayList<OCSPRef> ocspRefs = new ArrayList<OCSPRef>();
        NodeList nodeList = unsignedAttribute.getNodeList(this.xadesPaths.getCurrentOCSPRefsChildren());
        for (int ii = 0; ii < nodeList.getLength(); ++ii) {
            Element element = (Element)nodeList.item(ii);
            OCSPRef ocspRef = XAdESRevocationRefExtractionUtils.createOCSPRef(this.xadesPaths, element);
            if (ocspRef == null) continue;
            ocspRefs.add(ocspRef);
        }
        return ocspRefs;
    }

    protected List<Identifier> getEncapsulatedCertificateIdentifiers(XAdESAttribute unsignedAttribute) {
        ArrayList<Identifier> certificateIdentifiers = new ArrayList<Identifier>();
        String xPathString = this.isTimeStampValidationData(unsignedAttribute) ? this.xadesPaths.getCurrentCertificateValuesEncapsulatedCertificate() : this.xadesPaths.getCurrentEncapsulatedCertificate();
        NodeList encapsulatedNodes = unsignedAttribute.getNodeList(xPathString);
        for (int ii = 0; ii < encapsulatedNodes.getLength(); ++ii) {
            try {
                Element element = (Element)encapsulatedNodes.item(ii);
                byte[] binaries = this.getEncapsulatedTokenBinaries(element);
                CertificateToken certificateToken = DSSUtils.loadCertificate((byte[])binaries);
                certificateIdentifiers.add((Identifier)certificateToken.getDSSId());
                continue;
            }
            catch (Exception e) {
                String errorMessage = "Unable to parse an encapsulated certificate : {}";
                if (LOG.isDebugEnabled()) {
                    LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
                    continue;
                }
                LOG.warn(errorMessage, (Object)e.getMessage());
            }
        }
        return certificateIdentifiers;
    }

    protected List<Identifier> getEncapsulatedCRLIdentifiers(XAdESAttribute unsignedAttribute) {
        ArrayList<Identifier> crlIdentifiers = new ArrayList<Identifier>();
        String xPathString = this.isTimeStampValidationData(unsignedAttribute) ? this.xadesPaths.getCurrentRevocationValuesEncapsulatedCRLValue() : this.xadesPaths.getCurrentEncapsulatedCRLValue();
        NodeList encapsulatedNodes = unsignedAttribute.getNodeList(xPathString);
        for (int ii = 0; ii < encapsulatedNodes.getLength(); ++ii) {
            try {
                Element element = (Element)encapsulatedNodes.item(ii);
                byte[] binaries = this.getEncapsulatedTokenBinaries(element);
                crlIdentifiers.add((Identifier)CRLUtils.buildCRLBinary((byte[])binaries));
                continue;
            }
            catch (Exception e) {
                String errorMessage = "Unable to parse CRL binaries : {}";
                if (LOG.isDebugEnabled()) {
                    LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
                    continue;
                }
                LOG.warn(errorMessage, (Object)e.getMessage());
            }
        }
        return crlIdentifiers;
    }

    protected List<Identifier> getEncapsulatedOCSPIdentifiers(XAdESAttribute unsignedAttribute) {
        ArrayList<Identifier> ocspIdentifiers = new ArrayList<Identifier>();
        String xPathString = this.isTimeStampValidationData(unsignedAttribute) ? this.xadesPaths.getCurrentRevocationValuesEncapsulatedOCSPValue() : this.xadesPaths.getCurrentEncapsulatedOCSPValue();
        NodeList encapsulatedNodes = unsignedAttribute.getNodeList(xPathString);
        for (int ii = 0; ii < encapsulatedNodes.getLength(); ++ii) {
            Element element = (Element)encapsulatedNodes.item(ii);
            byte[] binaries = this.getEncapsulatedTokenBinaries(element);
            try {
                BasicOCSPResp basicOCSPResp = DSSRevocationUtils.loadOCSPFromBinaries((byte[])binaries);
                ocspIdentifiers.add((Identifier)OCSPResponseBinary.build((BasicOCSPResp)basicOCSPResp));
                continue;
            }
            catch (IOException e) {
                String errorMessage = "Unable to parse OCSP response binaries : {}";
                if (LOG.isDebugEnabled()) {
                    LOG.error(errorMessage, (Object)e.getMessage(), (Object)e);
                    continue;
                }
                LOG.warn(errorMessage, (Object)e.getMessage());
            }
        }
        return ocspIdentifiers;
    }

    private byte[] getEncapsulatedTokenBinaries(Element encapsulatedElement) {
        String base64String;
        Node firstChild;
        if (encapsulatedElement.hasChildNodes() && 3 == (firstChild = encapsulatedElement.getFirstChild()).getNodeType() && Utils.isBase64Encoded((String)(base64String = firstChild.getTextContent()))) {
            return Utils.fromBase64((String)base64String);
        }
        throw new DSSException(String.format("Cannot create the token reference. The element with local name [%s] must contain an encapsulated base64 token value!", encapsulatedElement.getLocalName()));
    }

    protected ArchiveTimestampType getArchiveTimestampType(XAdESAttribute unsignedAttribute) {
        if (XAdESNamespaces.XADES_141.isSameUri(unsignedAttribute.getNamespace())) {
            return ArchiveTimestampType.XAdES_141;
        }
        return ArchiveTimestampType.XAdES;
    }
}

