/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation.scope;

import eu.europa.esig.dss.enumerations.SignatureScopeType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.identifier.TokenIdentifierProvider;
import eu.europa.esig.dss.validation.scope.SignatureScopeWithTransformations;
import eu.europa.esig.dss.xml.utils.DomUtils;
import java.util.List;
import java.util.Objects;

public class ManifestEntrySignatureScope
extends SignatureScopeWithTransformations {
    private static final long serialVersionUID = 8764813918985821868L;
    private final String manifestName;

    public ManifestEntrySignatureScope(String entryName, DSSDocument document, String manifestName, List<String> transformations) {
        super(entryName, document, transformations);
        this.manifestName = manifestName;
    }

    public String getDescription(TokenIdentifierProvider tokenIdentifierProvider) {
        String description = DomUtils.isElementReference((String)this.getDocumentName()) ? String.format("The XML Manifest Entry with ID '%s' from a Manifest with name '%s'", this.getDocumentName(), this.manifestName) : String.format("The File Manifest Entry with name '%s' from a Manifest with name '%s'", this.getDocumentName(), this.manifestName);
        return this.addTransformationIfNeeded(description);
    }

    public SignatureScopeType getType() {
        return SignatureScopeType.FULL;
    }

    public String toString() {
        return "ManifestEntrySignatureScope{manifestName='" + this.manifestName + '\'' + "} " + super.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ManifestEntrySignatureScope)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ManifestEntrySignatureScope that = (ManifestEntrySignatureScope)((Object)o);
        return Objects.equals(this.manifestName, that.manifestName);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.manifestName != null ? this.manifestName.hashCode() : 0);
        return result;
    }
}

