/*
 * Decompiled with CFR 0.152.
 */
package org.digidoc4j.dss.xades;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Policy;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xml.utils.DomUtils;
import eu.europa.esig.xades.definition.XAdESPath;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BDocTmSupport
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(BDocTmSupport.class);
    public static final String BDOC_TM_POLICY_ID = "urn:oid:1.3.6.1.4.1.10015.1000.3.2.1";
    public static final String BDOC_TM_POLICY_QUALIFIER = "OIDAsURN";

    public static boolean isBdocTmSignatureProfile(XAdESSignatureParameters params) {
        Policy signaturePolicy = params.bLevel().getSignaturePolicy();
        if (signaturePolicy == null) {
            return false;
        }
        String policyId = Utils.trim((String)signaturePolicy.getId());
        return BDOC_TM_POLICY_ID.equals(policyId);
    }

    public static boolean hasBDocTmPolicyId(Element signatureElement, XAdESPath xadesPath) {
        Element policyId;
        Element policyIdentifier = DomUtils.getElement((Node)signatureElement, (String)xadesPath.getSignaturePolicyIdentifierPath());
        if (policyIdentifier != null && (policyId = DomUtils.getElement((Node)policyIdentifier, (String)xadesPath.getCurrentSignaturePolicyId())) != null) {
            String policyIdString = Utils.trim((String)policyId.getTextContent());
            return Utils.areStringsEqualIgnoreCase((String)BDOC_TM_POLICY_ID, (String)policyIdString);
        }
        return false;
    }

    public static boolean hasBDocTmOcsp(Element signatureElement, XAdESPath xadesPath) {
        if (BDocTmSupport.hasBDocTmPolicyId(signatureElement, xadesPath)) {
            String ocspValuesPath = xadesPath.getRevocationValuesPath() + xadesPath.getCurrentOCSPValuesChildren().substring(1);
            NodeList ocspValues = DomUtils.getNodeList((Node)signatureElement, (String)ocspValuesPath);
            for (int i = 0; i < ocspValues.getLength(); ++i) {
                try {
                    Element element = (Element)ocspValues.item(i);
                    byte[] binaries = BDocTmSupport.getEncapsulatedTokenBinaries(element);
                    BasicOCSPResp basicOCSPResp = DSSRevocationUtils.loadOCSPFromBinaries((byte[])binaries);
                    Extension ocspNonce = basicOCSPResp.getExtension(new ASN1ObjectIdentifier(OCSPObjectIdentifiers.id_pkix_ocsp_nonce.getId()));
                    if (ocspNonce != null && BDocTmSupport.isOcspNonceInValidFormat(ocspNonce)) {
                        return true;
                    }
                    continue;
                }
                catch (Exception e) {
                    String errorMessage = "Unable to parse OCSP response binaries : {}";
                    if (LOG.isDebugEnabled()) {
                        LOG.error(errorMessage, (Object)e.getMessage(), (Object)e);
                        continue;
                    }
                    LOG.warn(errorMessage, (Object)e.getMessage());
                }
            }
        }
        return false;
    }

    private static byte[] getEncapsulatedTokenBinaries(Element encapsulatedElement) {
        String base64String;
        Node firstChild;
        if (encapsulatedElement.hasChildNodes() && 3 == (firstChild = encapsulatedElement.getFirstChild()).getNodeType() && Utils.isBase64Encoded((String)(base64String = firstChild.getTextContent()))) {
            return Utils.fromBase64((String)base64String);
        }
        throw new DSSException(String.format("Cannot create the token reference. The element with local name [%s] must contain an encapsulated base64 token value!", encapsulatedElement.getLocalName()));
    }

    private static boolean isOcspNonceInValidFormat(Extension extension) {
        try {
            ASN1OctetString ev = extension.getExtnValue();
            byte[] octets = ev.getOctets();
            DigestAlgorithm usedDigestAlgorithm = BDocTmSupport.getExtensionDigestAlgorithm(octets);
            ASN1Sequence seq = ASN1Sequence.getInstance((Object)octets);
            byte[] foundHash = ((DEROctetString)seq.getObjectAt(1)).getOctets();
            return usedDigestAlgorithm.getSaltLength() == foundHash.length;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static DigestAlgorithm getExtensionDigestAlgorithm(byte[] octets) {
        ASN1Encodable oid = ASN1Sequence.getInstance((Object)octets).getObjectAt(0);
        String oidString = ((DLSequence)oid).getObjects().nextElement().toString();
        return DigestAlgorithm.forOID((String)oidString);
    }

    public static String uriEncode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8").replaceAll("\\+", "%20").replaceAll("\\%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Unable to decode '" + string + "' : " + e.getMessage(), (Throwable)e);
            return string;
        }
    }

    public static String fixEncoding(String string) {
        return string.replaceAll("\\+", "%2B");
    }
}

