/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.enumerations.CertificateOrigin;
import eu.europa.esig.dss.enumerations.CertificateRefOrigin;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.SignatureCertificateSource;
import eu.europa.esig.dss.spi.x509.CandidatesForSigningCertificate;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.CertificateValidity;
import eu.europa.esig.dss.spi.x509.SignerIdentifier;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.validation.XAdESCertificateRefExtractionUtils;
import eu.europa.esig.dss.xml.utils.DomUtils;
import eu.europa.esig.xades.definition.XAdESPath;
import eu.europa.esig.xmldsig.definition.XMLDSigPath;
import java.security.PublicKey;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XAdESCertificateSource
extends SignatureCertificateSource {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESCertificateSource.class);
    private final Element signatureElement;
    private final XAdESPath xadesPaths;

    public XAdESCertificateSource(Element signatureElement, XAdESPath xadesPaths) {
        Objects.requireNonNull(signatureElement, "Element signature must not be null");
        Objects.requireNonNull(xadesPaths, "XAdESPaths must not be null");
        this.signatureElement = signatureElement;
        this.xadesPaths = xadesPaths;
        this.extractCertificates(XMLDSigPath.KEY_INFO_X509_CERTIFICATE_PATH, CertificateOrigin.KEY_INFO);
        this.extractCertificates(xadesPaths.getEncapsulatedCertificateValuesPath(), CertificateOrigin.CERTIFICATE_VALUES);
        this.extractCertificates(xadesPaths.getEncapsulatedAttrAuthoritiesCertValuesPath(), CertificateOrigin.ATTR_AUTHORITIES_CERT_VALUES);
        this.extractCertificates(xadesPaths.getEncapsulatedTimeStampValidationDataCertValuesPath(), CertificateOrigin.TIMESTAMP_VALIDATION_DATA);
        this.extractCertificateRefs(xadesPaths.getSigningCertificateChildren(), xadesPaths.getSigningCertificateV2Children(), CertificateRefOrigin.SIGNING_CERTIFICATE);
        this.extractCertificateRefs(xadesPaths.getCompleteCertificateRefsCertPath(), xadesPaths.getCompleteCertificateRefsV2CertPath(), CertificateRefOrigin.COMPLETE_CERTIFICATE_REFS);
        this.extractCertificateRefs(xadesPaths.getAttributeCertificateRefsCertPath(), xadesPaths.getAttributeCertificateRefsV2CertPath(), CertificateRefOrigin.ATTRIBUTE_CERTIFICATE_REFS);
        if (LOG.isInfoEnabled()) {
            LOG.info("+XAdESCertificateSource");
        }
    }

    private void extractCertificates(String xPathQuery, CertificateOrigin origin) {
        if (xPathQuery == null) {
            return;
        }
        NodeList nodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)xPathQuery);
        for (int ii = 0; ii < nodeList.getLength(); ++ii) {
            Element certificateElement = (Element)nodeList.item(ii);
            String base64EncodedCertificate = certificateElement.getTextContent();
            try {
                byte[] derEncoded = Utils.fromBase64((String)base64EncodedCertificate);
                CertificateToken cert = DSSUtils.loadCertificate((byte[])derEncoded);
                this.addCertificate(cert, origin);
                continue;
            }
            catch (Exception e) {
                LOG.warn("Unable to parse certificate '{}' : {}", new Object[]{certificateElement.getTextContent(), e.getMessage(), e});
            }
        }
    }

    private void extractCertificateRefs(String xpathV1, String xpathV2, CertificateRefOrigin origin) {
        NodeList certRefNodeList;
        if (xpathV1 != null && (certRefNodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)xpathV1)) != null) {
            this.extractXAdESCertsV1(certRefNodeList, origin);
        }
        if (xpathV2 != null && (certRefNodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)xpathV2)) != null) {
            this.extractXAdESCertsV2(certRefNodeList, origin);
        }
    }

    private void extractXAdESCertsV1(NodeList certNodeList, CertificateRefOrigin origin) {
        for (int i = 0; i < certNodeList.getLength(); ++i) {
            Element certRefElement = (Element)certNodeList.item(i);
            CertificateRef certificateRef = XAdESCertificateRefExtractionUtils.createCertificateRefFromV1(certRefElement, this.xadesPaths);
            if (certificateRef == null) continue;
            this.addCertificateRef(certificateRef, origin);
        }
    }

    private void extractXAdESCertsV2(NodeList certNodeList, CertificateRefOrigin origin) {
        for (int i = 0; i < certNodeList.getLength(); ++i) {
            Element certRefElement = (Element)certNodeList.item(i);
            CertificateRef certificateRef = XAdESCertificateRefExtractionUtils.createCertificateRefFromV2(certRefElement, this.xadesPaths);
            if (certificateRef == null) continue;
            this.addCertificateRef(certificateRef, origin);
        }
    }

    protected CandidatesForSigningCertificate extractCandidatesForSigningCertificate(CertificateSource signingCertificateSource) {
        CandidatesForSigningCertificate candidatesForSigningCertificate = new CandidatesForSigningCertificate();
        for (CertificateToken certificateToken : this.getKeyInfoCertificates()) {
            candidatesForSigningCertificate.add(new CertificateValidity(certificateToken));
        }
        if (candidatesForSigningCertificate.isEmpty()) {
            PublicKey publicKey = DSSXMLUtils.getKeyInfoSigningCertificatePublicKey(this.signatureElement);
            if (publicKey != null) {
                Set certsByPublicKey = this.getByPublicKey(publicKey);
                if (Utils.isCollectionNotEmpty((Collection)certsByPublicKey)) {
                    for (CertificateToken certificateToken : certsByPublicKey) {
                        candidatesForSigningCertificate.add(new CertificateValidity(certificateToken));
                    }
                } else {
                    candidatesForSigningCertificate.add(new CertificateValidity(publicKey));
                }
            } else {
                for (CertificateToken certificateToken : this.getCertificates()) {
                    candidatesForSigningCertificate.add(new CertificateValidity(certificateToken));
                }
            }
        }
        if (signingCertificateSource != null) {
            this.resolveFromSource(signingCertificateSource, candidatesForSigningCertificate);
        }
        this.checkCandidatesAgainstSigningCertificateRef(candidatesForSigningCertificate);
        return candidatesForSigningCertificate;
    }

    private void resolveFromSource(CertificateSource certificateSource, CandidatesForSigningCertificate candidatesForSigningCertificate) {
        block3: {
            block2: {
                List signingCertificateRefs = this.getSigningCertificateRefs();
                if (!Utils.isCollectionNotEmpty((Collection)signingCertificateRefs)) break block2;
                for (CertificateRef certificateRef : signingCertificateRefs) {
                    this.resolveForReference(certificateRef, certificateSource, candidatesForSigningCertificate);
                }
                break block3;
            }
            if (!candidatesForSigningCertificate.isEmpty()) break block3;
            List certificates = certificateSource.getCertificates();
            LOG.debug("No signing certificate reference found. Resolve all {} certificates from the provided certificate source as signing candidates.", (Object)certificates.size());
            for (CertificateToken certCandidate : certificates) {
                candidatesForSigningCertificate.add(new CertificateValidity(certCandidate));
            }
        }
    }

    private void resolveForReference(CertificateRef certificateRef, CertificateSource certificateSource, CandidatesForSigningCertificate candidatesForSigningCertificate) {
        Set certificatesByDigest;
        Set certificatesByIdentifier;
        SignerIdentifier signerIdentifier = certificateRef.getCertificateIdentifier();
        if (signerIdentifier != null && Utils.isCollectionNotEmpty((Collection)(certificatesByIdentifier = certificateSource.getBySignerIdentifier(signerIdentifier)))) {
            LOG.debug("Resolved certificate by certificate identifier");
            for (CertificateToken certCandidate : certificatesByIdentifier) {
                candidatesForSigningCertificate.add(new CertificateValidity(certCandidate));
            }
            return;
        }
        Digest certDigest = certificateRef.getCertDigest();
        if (certDigest != null && Utils.isCollectionNotEmpty((Collection)(certificatesByDigest = certificateSource.getByCertificateDigest(certDigest)))) {
            LOG.debug("Resolved certificate by digest");
            for (CertificateToken certCandidate : certificatesByDigest) {
                candidatesForSigningCertificate.add(new CertificateValidity(certCandidate));
            }
        }
    }

    private void checkCandidatesAgainstSigningCertificateRef(CandidatesForSigningCertificate candidates) {
        List potentialSigningCertificates = this.getSigningCertificateRefs();
        if (Utils.isCollectionNotEmpty((Collection)potentialSigningCertificates)) {
            CertificateRef signingCert = (CertificateRef)potentialSigningCertificates.get(0);
            CertificateValidity bestCertificateValidity = null;
            List certificateValidityList = candidates.getCertificateValidityList();
            for (CertificateValidity certificateValidity : certificateValidityList) {
                if (!this.isValid(certificateValidity, signingCert)) continue;
                bestCertificateValidity = certificateValidity;
            }
            if (bestCertificateValidity != null) {
                candidates.setTheCertificateValidity(bestCertificateValidity);
            }
        }
    }

    private boolean isValid(CertificateValidity certificateValidity, CertificateRef signingCert) {
        certificateValidity.setDigestPresent(signingCert.getCertDigest() != null);
        certificateValidity.setIssuerSerialPresent(signingCert.getCertificateIdentifier() != null);
        CertificateToken certificateToken = certificateValidity.getCertificateToken();
        if (certificateToken != null) {
            certificateValidity.setDigestEqual(this.certificateMatcher.matchByDigest(certificateToken, signingCert));
            certificateValidity.setSerialNumberEqual(this.certificateMatcher.matchBySerialNumber(certificateToken, signingCert));
            certificateValidity.setDistinguishedNameEqual(this.certificateMatcher.matchByIssuerName(certificateToken, signingCert));
        }
        return certificateValidity.isValid();
    }
}

