/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.xmldsig;

import eu.europa.esig.dss.jaxb.XmlDefinerUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public abstract class XSDAbstractUtils {
    private static final Logger LOG = LoggerFactory.getLogger(XSDAbstractUtils.class);
    private static final String EMPTY_STRING = "";
    private Schema schema;

    public abstract JAXBContext getJAXBContext() throws JAXBException;

    public abstract List<Source> getXSDSources();

    public Schema getSchema() throws SAXException {
        if (this.schema == null) {
            this.schema = XmlDefinerUtils.getInstance().getSchema(this.getXSDSources());
        }
        return this.schema;
    }

    public Schema getSchema(Source ... sources) throws SAXException {
        List<Source> xsdSources = this.getXSDSources();
        if (sources != null) {
            xsdSources.addAll(Arrays.asList(sources));
        }
        return XmlDefinerUtils.getInstance().getSchema(xsdSources);
    }

    public String validateAgainstXSD(Source xmlSource) {
        try {
            this.validate(xmlSource, this.getSchema(), true);
            return EMPTY_STRING;
        }
        catch (Exception e) {
            String errorMessage = String.format("Error during the XML schema validation! Reason : [%s]", e.getMessage());
            if (LOG.isDebugEnabled()) {
                LOG.warn(errorMessage, (Throwable)e);
            } else {
                LOG.warn(errorMessage);
            }
            return e.getMessage();
        }
    }

    public String validateAgainstXSD(Source xmlSource, Source ... schemaSources) {
        try {
            this.validate(xmlSource, this.getSchema(schemaSources), true);
            return EMPTY_STRING;
        }
        catch (Exception e) {
            LOG.warn("Error during the XML schema validation!", (Throwable)e);
            return e.getMessage();
        }
    }

    public void validate(Source xmlSource, Schema schema, boolean secureValidation) throws SAXException, IOException {
        Validator validator = schema.newValidator();
        if (secureValidation) {
            XmlDefinerUtils.getInstance().configure(validator);
        }
        validator.validate(xmlSource);
    }
}

