/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.cc;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCryptographicAlgorithm;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.MaskGenerationFunction;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.CryptographicConstraint;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.sav.cc.DigestAlgorithmOnValidationTimeCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.cc.DigestAlgorithmReliableCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.cc.EncryptionAlgorithmOnValidationTimeCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.cc.EncryptionAlgorithmReliableCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.cc.PublicKeySizeAcceptableCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.cc.PublicKeySizeKnownCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CryptographicConstraintWrapper;
import java.util.Date;

public abstract class AbstractCryptographicChecker
extends Chain<XmlCC> {
    private static final String ALGORITHM_UNIDENTIFIED = "UNIDENTIFIED";
    private static final String ALGORITHM_UNIDENTIFIED_URN = "urn:etsi:019102:algorithm:unidentified";
    protected final EncryptionAlgorithm encryptionAlgorithm;
    protected final DigestAlgorithm digestAlgorithm;
    protected final MaskGenerationFunction maskGenerationFunction;
    protected final String keyLengthUsedToSignThisToken;
    protected final Date validationDate;
    protected final CryptographicConstraintWrapper constraintWrapper;
    protected final MessageTag position;
    private XmlCryptographicAlgorithm cryptographicAlgorithm;

    protected AbstractCryptographicChecker(I18nProvider i18nProvider, DigestAlgorithm digestAlgorithm, Date validationDate, MessageTag position, CryptographicConstraint constraint) {
        this(i18nProvider, null, digestAlgorithm, null, null, validationDate, position, constraint);
    }

    protected AbstractCryptographicChecker(I18nProvider i18nProvider, EncryptionAlgorithm encryptionAlgorithm, DigestAlgorithm digestAlgorithm, MaskGenerationFunction maskGenerationFunction, String keyLengthUsedToSignThisToken, Date validationDate, MessageTag position, CryptographicConstraint constraint) {
        super(i18nProvider, new XmlCC());
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.digestAlgorithm = digestAlgorithm;
        this.maskGenerationFunction = maskGenerationFunction;
        this.keyLengthUsedToSignThisToken = keyLengthUsedToSignThisToken;
        this.validationDate = validationDate;
        this.constraintWrapper = new CryptographicConstraintWrapper(constraint);
        this.position = position;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.CC;
    }

    protected boolean isExpirationDateAvailable(DigestAlgorithm digestAlgorithm) {
        return this.constraintWrapper.getExpirationDate(digestAlgorithm) != null;
    }

    protected boolean isExpirationDateAvailable(EncryptionAlgorithm encryptionAlgorithm, String keyLength) {
        return this.constraintWrapper.getExpirationDate(encryptionAlgorithm, keyLength) != null;
    }

    protected ChainItem<XmlCC> encryptionAlgorithmReliable() {
        return new EncryptionAlgorithmReliableCheck(this.i18nProvider, this.encryptionAlgorithm, (XmlCC)this.result, this.position, this.constraintWrapper);
    }

    protected ChainItem<XmlCC> digestAlgorithmReliable() {
        return new DigestAlgorithmReliableCheck(this.i18nProvider, this.digestAlgorithm, (XmlCC)this.result, this.position, this.constraintWrapper);
    }

    protected ChainItem<XmlCC> encryptionAlgorithmOnValidationTime() {
        return new EncryptionAlgorithmOnValidationTimeCheck(this.i18nProvider, this.encryptionAlgorithm, this.keyLengthUsedToSignThisToken, this.validationDate, (XmlCC)this.result, this.position, this.constraintWrapper);
    }

    protected ChainItem<XmlCC> digestAlgorithmOnValidationTime() {
        return new DigestAlgorithmOnValidationTimeCheck(this.i18nProvider, this.digestAlgorithm, this.validationDate, (XmlCC)this.result, this.position, this.constraintWrapper);
    }

    protected ChainItem<XmlCC> publicKeySizeKnown() {
        return new PublicKeySizeKnownCheck(this.i18nProvider, this.keyLengthUsedToSignThisToken, (XmlCC)this.result, this.position, this.constraintWrapper);
    }

    protected ChainItem<XmlCC> publicKeySizeAcceptable() {
        return new PublicKeySizeAcceptableCheck(this.i18nProvider, this.encryptionAlgorithm, this.keyLengthUsedToSignThisToken, (XmlCC)this.result, this.position, this.constraintWrapper);
    }

    @Override
    protected void addAdditionalInfo() {
        super.addAdditionalInfo();
        ((XmlCC)this.result).setVerifiedAlgorithm(this.getAlgorithm());
        ((XmlCC)this.result).setNotAfter(this.getNotAfter());
    }

    private XmlCryptographicAlgorithm getAlgorithm() {
        if (this.cryptographicAlgorithm == null) {
            this.cryptographicAlgorithm = new XmlCryptographicAlgorithm();
            if (this.digestAlgorithm == null) {
                this.cryptographicAlgorithm.setName(ALGORITHM_UNIDENTIFIED);
                this.cryptographicAlgorithm.setUri(ALGORITHM_UNIDENTIFIED_URN);
            } else if (this.encryptionAlgorithm != null) {
                SignatureAlgorithm signatureAlgorithm = this.getSignatureAlgorithm(this.digestAlgorithm, this.encryptionAlgorithm, this.maskGenerationFunction);
                this.cryptographicAlgorithm.setName(signatureAlgorithm.getName());
                this.cryptographicAlgorithm.setUri(this.getSignatureAlgorithmUri(signatureAlgorithm));
                this.cryptographicAlgorithm.setKeyLength(this.keyLengthUsedToSignThisToken);
            } else {
                this.cryptographicAlgorithm.setName(this.digestAlgorithm.getName());
                this.cryptographicAlgorithm.setUri(this.getDigestAlgorithmUri(this.digestAlgorithm));
            }
        }
        return this.cryptographicAlgorithm;
    }

    private SignatureAlgorithm getSignatureAlgorithm(DigestAlgorithm digestAlgorithm, EncryptionAlgorithm encryptionAlgorithm, MaskGenerationFunction maskGenerationFunction) {
        return SignatureAlgorithm.getAlgorithm((EncryptionAlgorithm)encryptionAlgorithm, (DigestAlgorithm)digestAlgorithm, (MaskGenerationFunction)maskGenerationFunction);
    }

    private String getSignatureAlgorithmUri(SignatureAlgorithm signatureAlgorithm) {
        if (signatureAlgorithm != null) {
            if (signatureAlgorithm.getUri() != null) {
                return signatureAlgorithm.getUri();
            }
            if (signatureAlgorithm.getOid() != null) {
                return signatureAlgorithm.getURIBasedOnOID();
            }
        }
        return ALGORITHM_UNIDENTIFIED_URN;
    }

    private String getDigestAlgorithmUri(DigestAlgorithm digestAlgorithm) {
        if (digestAlgorithm != null) {
            if (digestAlgorithm.getUri() != null) {
                return digestAlgorithm.getUri();
            }
            if (digestAlgorithm.getOid() != null) {
                return digestAlgorithm.getOid();
            }
        }
        return ALGORITHM_UNIDENTIFIED_URN;
    }

    private Date getNotAfter() {
        if (this.constraintWrapper.isDigestAlgorithmReliable(this.digestAlgorithm) && this.constraintWrapper.isEncryptionAlgorithmReliable(this.encryptionAlgorithm) && this.constraintWrapper.isEncryptionAlgorithmWithKeySizeReliable(this.encryptionAlgorithm, this.keyLengthUsedToSignThisToken)) {
            Date notAfter = this.constraintWrapper.getExpirationDate(this.digestAlgorithm);
            Date expirationEncryption = this.constraintWrapper.getExpirationDate(this.encryptionAlgorithm, this.keyLengthUsedToSignThisToken);
            if (notAfter == null || expirationEncryption != null && expirationEncryption.before(notAfter)) {
                notAfter = expirationEncryption;
            }
            return notAfter;
        }
        return null;
    }
}

