/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks.vts;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCRS;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.enumerations.TimestampedObjectType;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.vpfltvd.LongTermValidationCertificateRevocationSelector;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEExtraction;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.vts.checks.POEExistsAtOrBeforeControlTimeCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.vts.checks.RevocationIssuedBeforeControlTimeCheck;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ValidationTimeSlidingCertificateRevocationSelector
extends LongTermValidationCertificateRevocationSelector {
    private final POEExtraction poe;
    private final List<CertificateRevocationWrapper> certificateRevocationData;

    public ValidationTimeSlidingCertificateRevocationSelector(I18nProvider i18nProvider, CertificateWrapper certificate, List<CertificateRevocationWrapper> certificateRevocationData, Date currentTime, Map<String, XmlBasicBuildingBlocks> bbbs, String tokenId, POEExtraction poe, ValidationPolicy validationPolicy) {
        super(i18nProvider, certificate, currentTime, bbbs, tokenId, validationPolicy);
        this.certificateRevocationData = certificateRevocationData;
        this.poe = poe;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.VTS_CRS;
    }

    @Override
    public List<CertificateRevocationWrapper> getCertificateRevocationData() {
        return this.certificateRevocationData;
    }

    @Override
    protected ChainItem<XmlCRS> verifyRevocationData(ChainItem<XmlCRS> item, CertificateRevocationWrapper revocationWrapper) {
        item = super.verifyRevocationData(item, revocationWrapper);
        Boolean validity = (Boolean)this.revocationDataValidityMap.get(revocationWrapper);
        if (Boolean.TRUE.equals(validity)) {
            item = item.setNextItem(this.revocationIssuedBeforeControlTime((RevocationWrapper)revocationWrapper, this.currentTime));
            validity = revocationWrapper.getThisUpdate() != null && revocationWrapper.getThisUpdate().before(this.currentTime);
            if (Boolean.TRUE.equals(validity)) {
                item = item.setNextItem(this.poeExistsAtOrBeforeControlTime((TokenProxy)this.certificate, TimestampedObjectType.CERTIFICATE, this.currentTime));
                item = item.setNextItem(this.poeExistsAtOrBeforeControlTime((TokenProxy)revocationWrapper, TimestampedObjectType.REVOCATION, this.currentTime));
                validity = this.poe.isPOEExists(this.certificate.getId(), this.currentTime) && this.poe.isPOEExists(revocationWrapper.getId(), this.currentTime);
            }
            this.revocationDataValidityMap.put(revocationWrapper, validity);
        }
        return item;
    }

    private ChainItem<XmlCRS> revocationIssuedBeforeControlTime(RevocationWrapper revocation, Date controlTime) {
        return new RevocationIssuedBeforeControlTimeCheck<XmlCRS>(this.i18nProvider, (XmlCRS)this.result, revocation, controlTime, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlCRS> poeExistsAtOrBeforeControlTime(TokenProxy token, TimestampedObjectType objectType, Date controlTime) {
        return new POEExistsAtOrBeforeControlTimeCheck<XmlCRS>(this.i18nProvider, (XmlCRS)this.result, token, objectType, controlTime, this.poe, this.getWarnLevelConstraint());
    }
}

