/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.executor;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.jaxb.detailedreport.DetailedReport;
import eu.europa.esig.dss.jaxb.detailedreport.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.jaxb.detailedreport.XmlConclusion;
import eu.europa.esig.dss.jaxb.detailedreport.XmlSignature;
import eu.europa.esig.dss.jaxb.detailedreport.XmlTLAnalysis;
import eu.europa.esig.dss.jaxb.detailedreport.XmlValidationProcessArchivalData;
import eu.europa.esig.dss.jaxb.detailedreport.XmlValidationProcessBasicSignatures;
import eu.europa.esig.dss.jaxb.detailedreport.XmlValidationProcessLongTermData;
import eu.europa.esig.dss.jaxb.detailedreport.XmlValidationSignatureQualification;
import eu.europa.esig.dss.jaxb.diagnostic.XmlTrustedList;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.executor.ValidationLevel;
import eu.europa.esig.dss.validation.policy.Context;
import eu.europa.esig.dss.validation.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.process.bbb.BasicBuildingBlocks;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.SignatureQualificationBlock;
import eu.europa.esig.dss.validation.process.qmatrix.tl.TLValidationBlock;
import eu.europa.esig.dss.validation.process.vpfbs.ValidationProcessForBasicSignatures;
import eu.europa.esig.dss.validation.process.vpfltvd.ValidationProcessForSignaturesWithLongTermValidationData;
import eu.europa.esig.dss.validation.process.vpfswatsp.ValidationProcessForSignaturesWithArchivalData;
import eu.europa.esig.dss.validation.process.vpftsp.ValidationProcessForTimeStamps;
import eu.europa.esig.dss.validation.reports.wrapper.AbstractTokenProxy;
import eu.europa.esig.dss.validation.reports.wrapper.DiagnosticData;
import eu.europa.esig.dss.validation.reports.wrapper.SignatureWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.TimestampWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.TokenProxy;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetailedReportBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(DetailedReportBuilder.class);
    private final Date currentTime;
    private final ValidationPolicy policy;
    private final ValidationLevel validationLevel;
    private final DiagnosticData diagnosticData;

    public DetailedReportBuilder(Date currentTime, ValidationPolicy policy, ValidationLevel validationLevel, DiagnosticData diagnosticData) {
        this.currentTime = currentTime;
        this.policy = policy;
        this.validationLevel = validationLevel;
        this.diagnosticData = diagnosticData;
    }

    DetailedReport build() {
        DetailedReport detailedReport = new DetailedReport();
        Map<String, XmlBasicBuildingBlocks> bbbs = this.executeAllBasicBuildingBlocks();
        detailedReport.getBasicBuildingBlocks().addAll(bbbs.values());
        Map<Object, Object> tlAnalysisResults = new HashMap();
        if (this.policy.isEIDASConstraintPresent()) {
            tlAnalysisResults = this.executeAllTlAnalysis();
            detailedReport.getTLAnalysis().addAll(tlAnalysisResults.values());
        }
        for (SignatureWrapper signature : this.diagnosticData.getSignatures()) {
            XmlSignature signatureAnalysis = new XmlSignature();
            signatureAnalysis.setId(signature.getId());
            if (signature.isCounterSignature()) {
                signatureAnalysis.setCounterSignature(Boolean.valueOf(true));
            }
            XmlConclusion conlusion = this.executeBasicValidation(signatureAnalysis, signature, bbbs);
            if (ValidationLevel.TIMESTAMPS.equals((Object)this.validationLevel)) {
                this.executeTimestampsValidation(signatureAnalysis, signature, bbbs);
            } else if (ValidationLevel.LONG_TERM_DATA.equals((Object)this.validationLevel)) {
                this.executeTimestampsValidation(signatureAnalysis, signature, bbbs);
                conlusion = this.executeLongTermValidation(signatureAnalysis, signature, bbbs);
            } else if (ValidationLevel.ARCHIVAL_DATA.equals((Object)this.validationLevel)) {
                this.executeTimestampsValidation(signatureAnalysis, signature, bbbs);
                this.executeLongTermValidation(signatureAnalysis, signature, bbbs);
                conlusion = this.executeArchiveValidation(signatureAnalysis, signature, bbbs);
            }
            if (this.policy.isEIDASConstraintPresent()) {
                try {
                    SignatureQualificationBlock qualificationBlock = new SignatureQualificationBlock(conlusion, tlAnalysisResults, signature, this.diagnosticData, this.policy);
                    signatureAnalysis.setValidationSignatureQualification((XmlValidationSignatureQualification)qualificationBlock.execute());
                }
                catch (Exception e) {
                    LOG.error("Unable to determine the signature qualification", (Throwable)e);
                }
            }
            detailedReport.getSignatures().add(signatureAnalysis);
        }
        return detailedReport;
    }

    private Map<String, XmlTLAnalysis> executeAllTlAnalysis() {
        List trustedLists;
        HashMap<String, XmlTLAnalysis> result = new HashMap<String, XmlTLAnalysis>();
        XmlTrustedList listOfTrustedLists = this.diagnosticData.getListOfTrustedLists();
        if (listOfTrustedLists != null) {
            TLValidationBlock tlValidation = new TLValidationBlock(listOfTrustedLists, this.currentTime, this.policy);
            result.put(listOfTrustedLists.getCountryCode(), (XmlTLAnalysis)tlValidation.execute());
        }
        if (Utils.isCollectionNotEmpty((Collection)(trustedLists = this.diagnosticData.getTrustedLists()))) {
            for (XmlTrustedList xmlTrustedList : trustedLists) {
                TLValidationBlock tlValidation = new TLValidationBlock(xmlTrustedList, this.currentTime, this.policy);
                result.put(xmlTrustedList.getCountryCode(), (XmlTLAnalysis)tlValidation.execute());
            }
        }
        return result;
    }

    private XmlConclusion executeBasicValidation(XmlSignature signatureAnalysis, SignatureWrapper signature, Map<String, XmlBasicBuildingBlocks> bbbs) {
        ValidationProcessForBasicSignatures vpfbs = new ValidationProcessForBasicSignatures(this.diagnosticData, signature, bbbs);
        XmlValidationProcessBasicSignatures bs = (XmlValidationProcessBasicSignatures)vpfbs.execute();
        signatureAnalysis.setValidationProcessBasicSignatures(bs);
        return bs.getConclusion();
    }

    private void executeTimestampsValidation(XmlSignature signatureAnalysis, SignatureWrapper signature, Map<String, XmlBasicBuildingBlocks> bbbs) {
        List allTimestamps = signature.getTimestampList();
        for (TimestampWrapper timestamp : allTimestamps) {
            ValidationProcessForTimeStamps vpftsp = new ValidationProcessForTimeStamps(timestamp, bbbs);
            signatureAnalysis.getValidationProcessTimestamps().add(vpftsp.execute());
        }
    }

    private XmlConclusion executeLongTermValidation(XmlSignature signatureAnalysis, SignatureWrapper signature, Map<String, XmlBasicBuildingBlocks> bbbs) {
        ValidationProcessForSignaturesWithLongTermValidationData vpfltvd = new ValidationProcessForSignaturesWithLongTermValidationData(signatureAnalysis, this.diagnosticData, signature, bbbs, this.policy, this.currentTime);
        XmlValidationProcessLongTermData vpfltvdResult = (XmlValidationProcessLongTermData)vpfltvd.execute();
        signatureAnalysis.setValidationProcessLongTermData(vpfltvdResult);
        return vpfltvdResult.getConclusion();
    }

    private XmlConclusion executeArchiveValidation(XmlSignature signatureAnalysis, SignatureWrapper signature, Map<String, XmlBasicBuildingBlocks> bbbs) {
        ValidationProcessForSignaturesWithArchivalData vpfswad = new ValidationProcessForSignaturesWithArchivalData(signatureAnalysis, signature, this.diagnosticData, bbbs, this.policy, this.currentTime);
        XmlValidationProcessArchivalData vpfswadResult = (XmlValidationProcessArchivalData)vpfswad.execute();
        signatureAnalysis.setValidationProcessArchivalData(vpfswadResult);
        return vpfswadResult.getConclusion();
    }

    private Map<String, XmlBasicBuildingBlocks> executeAllBasicBuildingBlocks() {
        HashMap<String, XmlBasicBuildingBlocks> bbbs = new HashMap<String, XmlBasicBuildingBlocks>();
        switch (this.validationLevel) {
            case ARCHIVAL_DATA: 
            case LONG_TERM_DATA: {
                this.process(this.diagnosticData.getAllRevocationData(), Context.REVOCATION, bbbs);
                this.process(this.diagnosticData.getAllTimestamps(), Context.TIMESTAMP, bbbs);
                this.process(this.diagnosticData.getAllSignatures(), Context.SIGNATURE, bbbs);
                this.process(this.diagnosticData.getAllCounterSignatures(), Context.COUNTER_SIGNATURE, bbbs);
                break;
            }
            case TIMESTAMPS: {
                this.process(this.diagnosticData.getAllTimestamps(), Context.TIMESTAMP, bbbs);
                this.process(this.diagnosticData.getAllSignatures(), Context.SIGNATURE, bbbs);
                this.process(this.diagnosticData.getAllCounterSignatures(), Context.COUNTER_SIGNATURE, bbbs);
                break;
            }
            case BASIC_SIGNATURES: {
                this.process(this.diagnosticData.getAllSignatures(), Context.SIGNATURE, bbbs);
                this.process(this.diagnosticData.getAllCounterSignatures(), Context.COUNTER_SIGNATURE, bbbs);
                break;
            }
            default: {
                throw new DSSException("Unsupported validation level " + (Object)((Object)this.validationLevel));
            }
        }
        return bbbs;
    }

    private void process(Set<? extends AbstractTokenProxy> tokensToProcess, Context context, Map<String, XmlBasicBuildingBlocks> bbbs) {
        for (AbstractTokenProxy abstractTokenProxy : tokensToProcess) {
            BasicBuildingBlocks bbb = new BasicBuildingBlocks(this.diagnosticData, (TokenProxy)abstractTokenProxy, this.currentTime, this.policy, context);
            XmlBasicBuildingBlocks result = bbb.execute();
            bbbs.put(abstractTokenProxy.getId(), result);
        }
    }
}

