/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.executor;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.jaxb.detailedreport.DetailedReport;
import eu.europa.esig.dss.jaxb.detailedreport.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.jaxb.detailedreport.XmlChainItem;
import eu.europa.esig.dss.jaxb.detailedreport.XmlConclusion;
import eu.europa.esig.dss.jaxb.detailedreport.XmlConstraint;
import eu.europa.esig.dss.jaxb.detailedreport.XmlConstraintsConclusion;
import eu.europa.esig.dss.jaxb.detailedreport.XmlName;
import eu.europa.esig.dss.jaxb.detailedreport.XmlSignature;
import eu.europa.esig.dss.jaxb.detailedreport.XmlSubXCV;
import eu.europa.esig.dss.jaxb.detailedreport.XmlTLAnalysis;
import eu.europa.esig.dss.jaxb.detailedreport.XmlValidationProcessBasicSignatures;
import eu.europa.esig.dss.jaxb.detailedreport.XmlValidationProcessTimestamps;
import eu.europa.esig.dss.jaxb.detailedreport.XmlValidationSignatureQualification;
import eu.europa.esig.dss.jaxb.detailedreport.XmlXCV;
import eu.europa.esig.dss.jaxb.diagnostic.XmlSignatureScope;
import eu.europa.esig.dss.jaxb.simplereport.SimpleReport;
import eu.europa.esig.dss.jaxb.simplereport.XmlCertificate;
import eu.europa.esig.dss.jaxb.simplereport.XmlCertificateChain;
import eu.europa.esig.dss.jaxb.simplereport.XmlPolicy;
import eu.europa.esig.dss.jaxb.simplereport.XmlSignatureLevel;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.SignatureQualification;
import eu.europa.esig.dss.validation.executor.ValidationLevel;
import eu.europa.esig.dss.validation.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.policy.rules.Indication;
import eu.europa.esig.dss.validation.reports.wrapper.CertificateWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.DiagnosticData;
import eu.europa.esig.dss.validation.reports.wrapper.SignatureWrapper;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleReportBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleReportBuilder.class);
    private final Date currentTime;
    private final ValidationPolicy policy;
    private final DiagnosticData diagnosticData;
    private final ValidationLevel validationLevel;
    private final DetailedReport detailedReport;
    private int totalSignatureCount = 0;
    private int validSignatureCount = 0;

    public SimpleReportBuilder(Date currentTime, ValidationPolicy policy, DiagnosticData diagnosticData, ValidationLevel validationLevel, DetailedReport detailedReport) {
        this.currentTime = currentTime;
        this.policy = policy;
        this.diagnosticData = diagnosticData;
        this.validationLevel = validationLevel;
        this.detailedReport = detailedReport;
    }

    public SimpleReport build() {
        SimpleReport simpleReport = new SimpleReport();
        this.addPolicyNode(simpleReport);
        this.addValidationTime(simpleReport);
        this.addDocumentName(simpleReport);
        boolean containerInfoPresent = this.diagnosticData.isContainerInfoPresent();
        if (containerInfoPresent) {
            this.addContainerType(simpleReport);
        }
        this.addSignatures(simpleReport, containerInfoPresent);
        this.addStatistics(simpleReport);
        return simpleReport;
    }

    private void addPolicyNode(SimpleReport report) {
        XmlPolicy xmlpolicy = new XmlPolicy();
        xmlpolicy.setPolicyName(this.policy.getPolicyName());
        xmlpolicy.setPolicyDescription(this.policy.getPolicyDescription());
        report.setPolicy(xmlpolicy);
    }

    private void addValidationTime(SimpleReport report) {
        report.setValidationTime(this.currentTime);
    }

    private void addDocumentName(SimpleReport report) {
        report.setDocumentName(this.diagnosticData.getDocumentName());
    }

    private void addContainerType(SimpleReport simpleReport) {
        simpleReport.setContainerType(this.diagnosticData.getContainerType());
    }

    private void addSignatures(SimpleReport simpleReport, boolean container) throws DSSException {
        this.validSignatureCount = 0;
        this.totalSignatureCount = 0;
        List signatures = this.diagnosticData.getSignatures();
        for (SignatureWrapper signature : signatures) {
            this.addSignature(simpleReport, signature, container);
        }
    }

    private void addStatistics(SimpleReport simpleReport) {
        simpleReport.setValidSignaturesCount(this.validSignatureCount);
        simpleReport.setSignaturesCount(this.totalSignatureCount);
    }

    private void addSignature(SimpleReport simpleReport, SignatureWrapper signature, boolean container) {
        List errors;
        ++this.totalSignatureCount;
        String signatureId = signature.getId();
        eu.europa.esig.dss.jaxb.simplereport.XmlSignature xmlSignature = new eu.europa.esig.dss.jaxb.simplereport.XmlSignature();
        xmlSignature.setId(signatureId);
        this.addCounterSignature(signature, xmlSignature);
        this.addSignatureScope(signature, xmlSignature);
        this.addSigningTime(signature, xmlSignature);
        this.addSignatureFormat(signature, xmlSignature);
        xmlSignature.setSignedBy(this.getSignedBy(signature));
        if (container) {
            xmlSignature.setFilename(signature.getSignatureFilename());
        }
        XmlSignature xmlSig = this.getXmlSignature(signatureId);
        XmlValidationProcessBasicSignatures constraintsConclusion = null;
        switch (this.validationLevel) {
            case BASIC_SIGNATURES: {
                constraintsConclusion = xmlSig.getValidationProcessBasicSignatures();
                break;
            }
            case TIMESTAMPS: {
                constraintsConclusion = xmlSig.getValidationProcessBasicSignatures();
                break;
            }
            case LONG_TERM_DATA: {
                constraintsConclusion = xmlSig.getValidationProcessLongTermData();
                break;
            }
            case ARCHIVAL_DATA: {
                constraintsConclusion = xmlSig.getValidationProcessArchivalData();
                break;
            }
            default: {
                LOG.error("Unsupported validation level : " + (Object)((Object)this.validationLevel));
            }
        }
        if (constraintsConclusion == null) {
            LOG.error("Constraint conclusion not found!");
            return;
        }
        XmlConclusion conclusion = constraintsConclusion.getConclusion();
        HashSet<String> errorList = new HashSet<String>();
        HashSet<String> warnList = new HashSet<String>();
        HashSet<String> infoList = new HashSet<String>();
        XmlValidationSignatureQualification signQualBlock = xmlSig.getValidationSignatureQualification();
        if (signQualBlock != null) {
            List tlAnalysis = this.detailedReport.getTLAnalysis();
            for (XmlTLAnalysis xmlTLAnalysis : tlAnalysis) {
                this.collectErrors(errorList, (XmlConstraintsConclusion)xmlTLAnalysis);
                this.collectWarnings(warnList, (XmlConstraintsConclusion)xmlTLAnalysis);
                this.collectInfos(infoList, (XmlConstraintsConclusion)xmlTLAnalysis);
            }
            this.collectErrors(errorList, (XmlConstraintsConclusion)signQualBlock);
            this.collectWarnings(warnList, (XmlConstraintsConclusion)signQualBlock);
            this.collectInfos(infoList, (XmlConstraintsConclusion)signQualBlock);
        }
        if (Utils.isCollectionNotEmpty((Collection)(errors = conclusion.getErrors()))) {
            for (XmlName error : errors) {
                errorList.add(error.getValue());
            }
        }
        errorList.addAll(this.getLinkedErrors(xmlSig));
        warnList.addAll(this.getWarnings(xmlSig));
        infoList.addAll(this.getInfos(xmlSig));
        xmlSignature.getErrors().addAll(errorList);
        xmlSignature.getWarnings().addAll(warnList);
        xmlSignature.getInfos().addAll(infoList);
        Indication indication = conclusion.getIndication();
        if (Indication.PASSED.equals((Object)indication)) {
            ++this.validSignatureCount;
            xmlSignature.setIndication(Indication.TOTAL_PASSED);
        } else if (Indication.FAILED.equals((Object)indication)) {
            xmlSignature.setIndication(Indication.TOTAL_FAILED);
        } else {
            xmlSignature.setIndication(indication);
        }
        xmlSignature.setSubIndication(conclusion.getSubIndication());
        this.addSignatureProfile(signQualBlock, xmlSignature);
        XmlBasicBuildingBlocks signatureBasicBuildingBlock = this.getBasicBuildingBlockById(signatureId);
        List chainItems = signatureBasicBuildingBlock.getCertificateChain().getChainItem();
        if (Utils.isCollectionNotEmpty((Collection)chainItems)) {
            XmlCertificateChain xmlCertificateChain = new XmlCertificateChain();
            for (XmlChainItem xmlChainItem : chainItems) {
                XmlCertificate certificate = new XmlCertificate();
                certificate.setId(xmlChainItem.getId());
                certificate.setQualifiedName(this.getReadableCertificateName(xmlChainItem.getId()));
                xmlCertificateChain.getCertificate().add(certificate);
            }
            xmlSignature.setCertificateChain(xmlCertificateChain);
        }
        simpleReport.getSignature().add(xmlSignature);
    }

    private XmlSignature getXmlSignature(String signatureId) {
        List signatures = this.detailedReport.getSignatures();
        for (XmlSignature xmlSignature : signatures) {
            if (!Utils.areStringsEqual((String)signatureId, (String)xmlSignature.getId())) continue;
            return xmlSignature;
        }
        return null;
    }

    private XmlBasicBuildingBlocks getBasicBuildingBlockById(String id) {
        List basicBuildingBlocks;
        if (id != null && Utils.isCollectionNotEmpty((Collection)(basicBuildingBlocks = this.detailedReport.getBasicBuildingBlocks()))) {
            for (XmlBasicBuildingBlocks xmlBasicBuildingBlocks : basicBuildingBlocks) {
                if (!Utils.areStringsEqual((String)xmlBasicBuildingBlocks.getId(), (String)id)) continue;
                return xmlBasicBuildingBlocks;
            }
        }
        return null;
    }

    private Set<String> getLinkedErrors(XmlSignature xmlSignature) {
        HashSet<String> errors = new HashSet<String>();
        List validationProcessTimestamps = xmlSignature.getValidationProcessTimestamps();
        if (Utils.isCollectionNotEmpty((Collection)validationProcessTimestamps)) {
            for (XmlValidationProcessTimestamps xmlValidationProcessTimestamps : validationProcessTimestamps) {
                this.collectErrors(errors, (XmlConstraintsConclusion)xmlValidationProcessTimestamps);
            }
        }
        return errors;
    }

    private Set<String> getWarnings(XmlSignature xmlSignature) {
        HashSet<String> warns = new HashSet<String>();
        this.collectWarnings(warns, (XmlConstraintsConclusion)xmlSignature.getValidationProcessBasicSignatures());
        List validationProcessTimestamps = xmlSignature.getValidationProcessTimestamps();
        if (Utils.isCollectionNotEmpty((Collection)validationProcessTimestamps)) {
            for (XmlValidationProcessTimestamps xmlValidationProcessTimestamps : validationProcessTimestamps) {
                this.collectWarnings(warns, (XmlConstraintsConclusion)xmlValidationProcessTimestamps);
            }
        }
        this.collectWarnings(warns, (XmlConstraintsConclusion)xmlSignature.getValidationProcessLongTermData());
        this.collectWarnings(warns, (XmlConstraintsConclusion)xmlSignature.getValidationProcessArchivalData());
        return warns;
    }

    private void collectWarnings(Set<String> result, XmlConstraintsConclusion constraintConclusion) {
        if (constraintConclusion != null && Utils.isCollectionNotEmpty((Collection)constraintConclusion.getConstraint())) {
            for (XmlConstraint constraint : constraintConclusion.getConstraint()) {
                this.collectWarnings(result, this.getBasicBuildingBlockById(constraint.getId()));
                XmlName warning = constraint.getWarning();
                if (warning == null) continue;
                result.add(warning.getValue());
            }
        }
    }

    private void collectWarnings(Set<String> result, XmlBasicBuildingBlocks bbb) {
        if (bbb != null) {
            this.collectWarnings(result, (XmlConstraintsConclusion)bbb.getFC());
            this.collectWarnings(result, (XmlConstraintsConclusion)bbb.getISC());
            this.collectWarnings(result, (XmlConstraintsConclusion)bbb.getCV());
            this.collectWarnings(result, (XmlConstraintsConclusion)bbb.getSAV());
            XmlXCV xcv = bbb.getXCV();
            if (xcv != null) {
                this.collectWarnings(result, (XmlConstraintsConclusion)xcv);
                List subXCV = xcv.getSubXCV();
                if (Utils.isCollectionNotEmpty((Collection)subXCV)) {
                    for (XmlSubXCV xmlSubXCV : subXCV) {
                        this.collectWarnings(result, (XmlConstraintsConclusion)xmlSubXCV);
                    }
                }
            }
            this.collectWarnings(result, (XmlConstraintsConclusion)bbb.getVCI());
        }
    }

    private void collectErrors(Set<String> result, XmlConstraintsConclusion constraintConclusion) {
        if (constraintConclusion != null && Utils.isCollectionNotEmpty((Collection)constraintConclusion.getConstraint())) {
            for (XmlConstraint constraint : constraintConclusion.getConstraint()) {
                XmlName error = constraint.getError();
                if (error == null) continue;
                result.add(error.getValue());
            }
        }
    }

    private Set<String> getInfos(XmlSignature xmlSignature) {
        HashSet<String> infos = new HashSet<String>();
        this.collectInfos(infos, (XmlConstraintsConclusion)xmlSignature.getValidationProcessBasicSignatures());
        List validationProcessTimestamps = xmlSignature.getValidationProcessTimestamps();
        if (Utils.isCollectionNotEmpty((Collection)validationProcessTimestamps)) {
            for (XmlValidationProcessTimestamps xmlValidationProcessTimestamps : validationProcessTimestamps) {
                this.collectInfos(infos, (XmlConstraintsConclusion)xmlValidationProcessTimestamps);
            }
        }
        this.collectInfos(infos, (XmlConstraintsConclusion)xmlSignature.getValidationProcessLongTermData());
        this.collectInfos(infos, (XmlConstraintsConclusion)xmlSignature.getValidationProcessArchivalData());
        return infos;
    }

    private void collectInfos(Set<String> result, XmlConstraintsConclusion constraintConclusion) {
        if (constraintConclusion != null && Utils.isCollectionNotEmpty((Collection)constraintConclusion.getConstraint())) {
            for (XmlConstraint constraint : constraintConclusion.getConstraint()) {
                this.collectInfos(result, this.getBasicBuildingBlockById(constraint.getId()));
                XmlName info = constraint.getInfo();
                if (info == null) continue;
                result.add(info.getValue());
            }
        }
    }

    private void collectInfos(Set<String> result, XmlBasicBuildingBlocks bbb) {
        if (bbb != null) {
            this.collectInfos(result, (XmlConstraintsConclusion)bbb.getFC());
            this.collectInfos(result, (XmlConstraintsConclusion)bbb.getISC());
            this.collectInfos(result, (XmlConstraintsConclusion)bbb.getCV());
            this.collectInfos(result, (XmlConstraintsConclusion)bbb.getSAV());
            XmlXCV xcv = bbb.getXCV();
            if (xcv != null) {
                this.collectInfos(result, (XmlConstraintsConclusion)xcv);
                List subXCV = xcv.getSubXCV();
                if (Utils.isCollectionNotEmpty((Collection)subXCV)) {
                    for (XmlSubXCV xmlSubXCV : subXCV) {
                        this.collectInfos(result, (XmlConstraintsConclusion)xmlSubXCV);
                    }
                }
            }
            this.collectInfos(result, (XmlConstraintsConclusion)bbb.getVCI());
        }
    }

    private void addCounterSignature(SignatureWrapper signature, eu.europa.esig.dss.jaxb.simplereport.XmlSignature xmlSignature) {
        if (signature.isCounterSignature()) {
            xmlSignature.setCounterSignature(Boolean.valueOf(true));
            xmlSignature.setParentId(signature.getParentId());
        }
    }

    private void addSignatureScope(SignatureWrapper signature, eu.europa.esig.dss.jaxb.simplereport.XmlSignature xmlSignature) {
        List signatureScopes = signature.getSignatureScopes();
        if (Utils.isCollectionNotEmpty((Collection)signatureScopes)) {
            for (XmlSignatureScope scopeType : signatureScopes) {
                eu.europa.esig.dss.jaxb.simplereport.XmlSignatureScope scope = new eu.europa.esig.dss.jaxb.simplereport.XmlSignatureScope();
                scope.setName(scopeType.getName());
                scope.setScope(scopeType.getScope());
                scope.setValue(scopeType.getValue());
                xmlSignature.getSignatureScope().add(scope);
            }
        }
    }

    private void addSigningTime(SignatureWrapper signature, eu.europa.esig.dss.jaxb.simplereport.XmlSignature xmlSignature) {
        xmlSignature.setSigningTime(signature.getDateTime());
    }

    private void addSignatureFormat(SignatureWrapper signature, eu.europa.esig.dss.jaxb.simplereport.XmlSignature xmlSignature) {
        xmlSignature.setSignatureFormat(signature.getSignatureFormat());
    }

    private String getSignedBy(SignatureWrapper signature) {
        return this.getReadableCertificateName(signature.getSigningCertificateId());
    }

    private String getReadableCertificateName(String certId) {
        CertificateWrapper signingCert = this.diagnosticData.getUsedCertificateById(certId);
        if (signingCert != null) {
            if (Utils.isStringNotEmpty((String)signingCert.getCommonName())) {
                return signingCert.getCommonName();
            }
            if (Utils.isStringNotEmpty((String)signingCert.getGivenName())) {
                return signingCert.getGivenName();
            }
            if (Utils.isStringNotEmpty((String)signingCert.getSurname())) {
                return signingCert.getSurname();
            }
            if (Utils.isStringNotEmpty((String)signingCert.getPseudo())) {
                return signingCert.getPseudo();
            }
            if (Utils.isStringNotEmpty((String)signingCert.getOrganizationName())) {
                return signingCert.getOrganizationName();
            }
            if (Utils.isStringNotEmpty((String)signingCert.getOrganizationalUnit())) {
                return signingCert.getOrganizationalUnit();
            }
        }
        return "?";
    }

    private void addSignatureProfile(XmlValidationSignatureQualification signQualificationBlock, eu.europa.esig.dss.jaxb.simplereport.XmlSignature xmlSignature) {
        SignatureQualification qualification;
        if (signQualificationBlock != null && (qualification = signQualificationBlock.getSignatureQualification()) != null) {
            XmlSignatureLevel sigLevel = new XmlSignatureLevel();
            sigLevel.setValue(qualification);
            sigLevel.setDescription(qualification.getLabel());
            xmlSignature.setSignatureLevel(sigLevel);
        }
    }
}

