/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process;

import eu.europa.esig.dss.CertificatePolicyOids;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.reports.wrapper.CertificateWrapper;
import java.util.Collection;
import java.util.List;

public final class CertificatePolicyIdentifiers {
    private CertificatePolicyIdentifiers() {
    }

    public static boolean isSupportedByQSCD(CertificateWrapper certificate) {
        return CertificatePolicyIdentifiers.hasPolicyIdOIDs(certificate, CertificatePolicyOids.QCP_PUBLIC_WITH_SSCD, CertificatePolicyOids.QCP_LEGAL_QSCD, CertificatePolicyOids.QCP_NATURAL_QSCD);
    }

    public static boolean isQCP(CertificateWrapper certificate) {
        return CertificatePolicyIdentifiers.hasPolicyIdOIDs(certificate, CertificatePolicyOids.QCP_PUBLIC);
    }

    public static boolean isQCPPlus(CertificateWrapper certificate) {
        return CertificatePolicyIdentifiers.hasPolicyIdOIDs(certificate, CertificatePolicyOids.QCP_PUBLIC_WITH_SSCD);
    }

    public static boolean isLegal(CertificateWrapper certificate) {
        return CertificatePolicyIdentifiers.hasPolicyIdOIDs(certificate, CertificatePolicyOids.QCP_LEGAL, CertificatePolicyOids.QCP_LEGAL_QSCD);
    }

    public static boolean isNatural(CertificateWrapper certificate) {
        return CertificatePolicyIdentifiers.hasPolicyIdOIDs(certificate, CertificatePolicyOids.QCP_NATURAL, CertificatePolicyOids.QCP_NATURAL_QSCD);
    }

    private static boolean hasPolicyIdOIDs(CertificateWrapper certificate, CertificatePolicyOids ... certificatePolicyIds) {
        List policyIds = certificate.getPolicyIds();
        if (Utils.isCollectionNotEmpty((Collection)policyIds)) {
            for (CertificatePolicyOids policyId : certificatePolicyIds) {
                if (!policyIds.contains(policyId.getOid())) continue;
                return true;
            }
        }
        return false;
    }
}

