/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.isc;

import eu.europa.esig.dss.SignatureForm;
import eu.europa.esig.dss.jaxb.detailedreport.XmlCertificateChain;
import eu.europa.esig.dss.jaxb.detailedreport.XmlISC;
import eu.europa.esig.dss.jaxb.diagnostic.XmlChainItem;
import eu.europa.esig.dss.validation.policy.Context;
import eu.europa.esig.dss.validation.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.isc.checks.DigestValueMatchCheck;
import eu.europa.esig.dss.validation.process.bbb.isc.checks.DigestValuePresentCheck;
import eu.europa.esig.dss.validation.process.bbb.isc.checks.IssuerSerialMatchCheck;
import eu.europa.esig.dss.validation.process.bbb.isc.checks.SigningCertificateAttributePresentCheck;
import eu.europa.esig.dss.validation.process.bbb.isc.checks.SigningCertificateRecognitionCheck;
import eu.europa.esig.dss.validation.process.bbb.isc.checks.SigningCertificateSignedCheck;
import eu.europa.esig.dss.validation.reports.wrapper.DiagnosticData;
import eu.europa.esig.dss.validation.reports.wrapper.SignatureWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.TokenProxy;
import eu.europa.esig.jaxb.policy.LevelConstraint;

public class IdentificationOfTheSigningCertificate
extends Chain<XmlISC> {
    private final DiagnosticData diagnosticData;
    private final TokenProxy token;
    private final Context context;
    private final ValidationPolicy validationPolicy;

    public IdentificationOfTheSigningCertificate(DiagnosticData diagnosticData, TokenProxy token, Context context, ValidationPolicy validationPolicy) {
        super(new XmlISC());
        this.diagnosticData = diagnosticData;
        this.token = token;
        this.context = context;
        this.validationPolicy = validationPolicy;
    }

    @Override
    protected void initChain() {
        ChainItem<XmlISC> item = this.firstItem = this.signingCertificateRecognition();
        XmlCertificateChain certificateChain = new XmlCertificateChain();
        if (this.token.getCertificateChain() != null) {
            for (XmlChainItem diagnosticChainItem : this.token.getCertificateChain()) {
                eu.europa.esig.dss.jaxb.detailedreport.XmlChainItem chainItem = new eu.europa.esig.dss.jaxb.detailedreport.XmlChainItem();
                chainItem.setId(diagnosticChainItem.getId());
                chainItem.setSource(diagnosticChainItem.getSource());
                certificateChain.getChainItem().add(chainItem);
            }
            ((XmlISC)this.result).setCertificateChain(certificateChain);
        }
        if (Context.SIGNATURE.equals((Object)this.context) || Context.COUNTER_SIGNATURE.equals((Object)this.context)) {
            SignatureWrapper signature = (SignatureWrapper)this.token;
            if (signature.getFormat() != null && signature.getFormat().contains(SignatureForm.PKCS7.name())) {
                return;
            }
            item = item.setNextItem(this.signingCertificateSigned());
            item = item.setNextItem(this.signingCertificateAttributePresent());
            item = item.setNextItem(this.digestValuePresent());
            item = item.setNextItem(this.digestValueMatch());
            item = item.setNextItem(this.issuerSerialMatch());
        }
    }

    private ChainItem<XmlISC> signingCertificateRecognition() {
        LevelConstraint constraint = this.validationPolicy.getSigningCertificateRecognitionConstraint(this.context);
        return new SigningCertificateRecognitionCheck((XmlISC)this.result, this.token, this.diagnosticData, constraint);
    }

    private ChainItem<XmlISC> signingCertificateSigned() {
        LevelConstraint constraint = this.validationPolicy.getSigningCertificateSignedConstraint(this.context);
        return new SigningCertificateSignedCheck((XmlISC)this.result, this.token, constraint);
    }

    private ChainItem<XmlISC> signingCertificateAttributePresent() {
        LevelConstraint constraint = this.validationPolicy.getSigningCertificateAttributePresentConstraint(this.context);
        return new SigningCertificateAttributePresentCheck((XmlISC)this.result, this.token, constraint);
    }

    private ChainItem<XmlISC> digestValuePresent() {
        LevelConstraint constraint = this.validationPolicy.getSigningCertificateDigestValuePresentConstraint(this.context);
        return new DigestValuePresentCheck((XmlISC)this.result, this.token, constraint);
    }

    private ChainItem<XmlISC> digestValueMatch() {
        LevelConstraint constraint = this.validationPolicy.getSigningCertificateDigestValueMatchConstraint(this.context);
        return new DigestValueMatchCheck((XmlISC)this.result, this.token, constraint);
    }

    private ChainItem<XmlISC> issuerSerialMatch() {
        LevelConstraint constraint = this.validationPolicy.getSigningCertificateIssuerSerialMatchConstraint(this.context);
        return new IssuerSerialMatchCheck((XmlISC)this.result, this.token, constraint);
    }
}

