/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav;

import eu.europa.esig.dss.jaxb.detailedreport.XmlConstraintsConclusion;
import eu.europa.esig.dss.jaxb.detailedreport.XmlSAV;
import eu.europa.esig.dss.validation.policy.Context;
import eu.europa.esig.dss.validation.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.sav.AbstractAcceptanceValidation;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CryptographicCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.TimestampMessageImprintDataFoundCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.TimestampMessageImprintDataIntactCheck;
import eu.europa.esig.dss.validation.reports.wrapper.DiagnosticData;
import eu.europa.esig.dss.validation.reports.wrapper.TimestampWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.TokenProxy;
import eu.europa.esig.jaxb.policy.CryptographicConstraint;
import eu.europa.esig.jaxb.policy.LevelConstraint;
import java.util.Date;

public class TimestampAcceptanceValidation
extends AbstractAcceptanceValidation<TimestampWrapper> {
    public TimestampAcceptanceValidation(DiagnosticData diagnosticData, Date currentTime, TimestampWrapper timestamp, ValidationPolicy validationPolicy) {
        super(diagnosticData, timestamp, currentTime, validationPolicy);
    }

    @Override
    protected void initChain() {
        ChainItem<XmlSAV> item = this.firstItem = this.timestampCryptographic();
        item = item.setNextItem(this.messageImprintDataFound());
        item = item.setNextItem(this.messageImprintDataIntact());
    }

    private ChainItem<XmlSAV> timestampCryptographic() {
        CryptographicConstraint constraint = this.validationPolicy.getSignatureCryptographicConstraint(Context.TIMESTAMP);
        return new CryptographicCheck<XmlConstraintsConclusion>(this.result, (TokenProxy)this.token, this.currentTime, constraint);
    }

    private ChainItem<XmlSAV> messageImprintDataFound() {
        LevelConstraint constraint = this.validationPolicy.getMessageImprintDataFoundConstraint();
        return new TimestampMessageImprintDataFoundCheck((XmlSAV)this.result, (TimestampWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> messageImprintDataIntact() {
        LevelConstraint constraint = this.validationPolicy.getMessageImprintDataIntactConstraint();
        return new TimestampMessageImprintDataIntactCheck((XmlSAV)this.result, (TimestampWrapper)this.token, constraint);
    }
}

