/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv;

import eu.europa.esig.dss.jaxb.detailedreport.XmlSubXCV;
import eu.europa.esig.dss.jaxb.detailedreport.XmlXCV;
import eu.europa.esig.dss.jaxb.diagnostic.XmlChainItem;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.policy.Context;
import eu.europa.esig.dss.validation.policy.SubContext;
import eu.europa.esig.dss.validation.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.xcv.checks.CheckSubXCVResult;
import eu.europa.esig.dss.validation.process.bbb.xcv.checks.ProspectiveCertificateChainCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.checks.TrustedServiceStatusCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.checks.TrustedServiceTypeIdentifierCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.SubX509CertificateValidation;
import eu.europa.esig.dss.validation.reports.wrapper.CertificateWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.DiagnosticData;
import eu.europa.esig.jaxb.policy.LevelConstraint;
import eu.europa.esig.jaxb.policy.MultiValuesConstraint;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class X509CertificateValidation
extends Chain<XmlXCV> {
    private final DiagnosticData diagnosticData;
    private final CertificateWrapper currentCertificate;
    private final Date currentTime;
    private final Date usageTime;
    private final Context context;
    private final ValidationPolicy validationPolicy;

    public X509CertificateValidation(DiagnosticData diagnosticData, CertificateWrapper currentCertificate, Date currentTime, Date usageTime, Context context, ValidationPolicy validationPolicy) {
        super(new XmlXCV());
        this.diagnosticData = diagnosticData;
        this.currentCertificate = currentCertificate;
        this.currentTime = currentTime;
        this.usageTime = usageTime;
        this.context = context;
        this.validationPolicy = validationPolicy;
    }

    @Override
    protected void initChain() {
        ChainItem<XmlXCV> item = this.firstItem = this.prospectiveCertificateChain();
        item = item.setNextItem(this.trustedServiceWithExpectedTypeIdentifier());
        item = item.setNextItem(this.trustedServiceWithExpectedStatus());
        SubX509CertificateValidation certificateValidation = new SubX509CertificateValidation(this.currentCertificate, this.currentTime, this.context, SubContext.SIGNING_CERT, this.validationPolicy);
        XmlSubXCV subXCV = (XmlSubXCV)certificateValidation.execute();
        ((XmlXCV)this.result).getSubXCV().add(subXCV);
        List certificateChainList = this.currentCertificate.getCertificateChain();
        if (Utils.isCollectionNotEmpty((Collection)certificateChainList)) {
            for (XmlChainItem chainCertificate : certificateChainList) {
                CertificateWrapper certificate = this.diagnosticData.getUsedCertificateByIdNullSafe(chainCertificate.getId());
                certificateValidation = new SubX509CertificateValidation(certificate, this.currentTime, this.context, SubContext.CA_CERTIFICATE, this.validationPolicy);
                subXCV = (XmlSubXCV)certificateValidation.execute();
                ((XmlXCV)this.result).getSubXCV().add(subXCV);
            }
        }
        for (XmlSubXCV subXCVresult : ((XmlXCV)this.result).getSubXCV()) {
            item = item.setNextItem(this.checkSubXCVResult(subXCVresult));
        }
    }

    private ChainItem<XmlXCV> prospectiveCertificateChain() {
        LevelConstraint constraint = this.validationPolicy.getProspectiveCertificateChainConstraint(this.context);
        return new ProspectiveCertificateChainCheck((XmlXCV)this.result, this.currentCertificate, this.diagnosticData, this.context, constraint);
    }

    private ChainItem<XmlXCV> trustedServiceWithExpectedTypeIdentifier() {
        MultiValuesConstraint constraint = this.validationPolicy.getTrustedServiceTypeIdentifierConstraint(this.context);
        return new TrustedServiceTypeIdentifierCheck((XmlXCV)this.result, this.currentCertificate, this.usageTime, this.context, constraint);
    }

    private ChainItem<XmlXCV> trustedServiceWithExpectedStatus() {
        MultiValuesConstraint constraint = this.validationPolicy.getTrustedServiceStatusConstraint(this.context);
        return new TrustedServiceStatusCheck((XmlXCV)this.result, this.currentCertificate, this.usageTime, this.context, constraint);
    }

    private ChainItem<XmlXCV> checkSubXCVResult(XmlSubXCV subXCVresult) {
        return new CheckSubXCVResult((XmlXCV)this.result, subXCVresult, this.getFailLevelConstraint());
    }
}

