/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks;

import eu.europa.esig.dss.jaxb.detailedreport.XmlSubXCV;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.policy.rules.Indication;
import eu.europa.esig.dss.validation.policy.rules.SubIndication;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.MessageTag;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.pseudo.JoinedPseudoStrategy;
import eu.europa.esig.dss.validation.reports.wrapper.CertificateWrapper;
import eu.europa.esig.jaxb.policy.LevelConstraint;
import java.text.MessageFormat;

public class PseudoUsageCheck
extends ChainItem<XmlSubXCV> {
    private final CertificateWrapper certificate;
    private String pseudo;

    public PseudoUsageCheck(XmlSubXCV result, CertificateWrapper certificate, LevelConstraint constraint) {
        super(result, constraint);
        this.certificate = certificate;
    }

    @Override
    protected boolean process() {
        JoinedPseudoStrategy pseudoStrategy = new JoinedPseudoStrategy();
        this.pseudo = pseudoStrategy.getPseudo(this.certificate);
        return Utils.isStringEmpty((String)this.pseudo);
    }

    @Override
    protected String getAdditionalInfo() {
        if (Utils.isStringNotEmpty((String)this.pseudo)) {
            Object[] params = new Object[]{this.pseudo};
            return MessageFormat.format("Pseudo : {0}", params);
        }
        return null;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_XCV_PSEUDO_USE;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_XCV_PSEUDO_USE_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.SIG_CONSTRAINTS_FAILURE;
    }
}

