/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qmatrix.qualification.checks;

import eu.europa.esig.dss.utils.Utils;
import java.util.List;

public final class AdditionalServiceInformation {
    public static final String FOR_ESIGNATURES = "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/ForeSignatures";
    public static final String FOR_ESEALS = "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/ForeSeals";
    public static final String FOR_WEB_AUTHENTICATION = "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/ForWebSiteAuthentication";

    private AdditionalServiceInformation() {
    }

    public static boolean isForeSignatures(List<String> additionalServiceInfos) {
        return additionalServiceInfos.contains(FOR_ESIGNATURES);
    }

    public static boolean isForeSeals(List<String> additionalServiceInfos) {
        return additionalServiceInfos.contains(FOR_ESEALS);
    }

    public static boolean isForeSealsOnly(List<String> additionalServiceInfos) {
        return Utils.collectionSize(additionalServiceInfos) == 1 && AdditionalServiceInformation.isForeSeals(additionalServiceInfos);
    }

    public static boolean isForWebAuth(List<String> additionalServiceInfos) {
        return additionalServiceInfos.contains(FOR_WEB_AUTHENTICATION);
    }

    public static boolean isForWebAuthOnly(List<String> additionalServiceInfos) {
        return Utils.collectionSize(additionalServiceInfos) == 1 && AdditionalServiceInformation.isForWebAuth(additionalServiceInfos);
    }
}

