/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qmatrix.qualification.checks;

import eu.europa.esig.dss.jaxb.detailedreport.XmlValidationSignatureQualification;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.policy.rules.Indication;
import eu.europa.esig.dss.validation.policy.rules.SubIndication;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.MessageTag;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.AdditionalServiceInformation;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.QCTypeIdentifiers;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.ServiceQualification;
import eu.europa.esig.dss.validation.reports.wrapper.CertificateWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.TrustedServiceWrapper;
import eu.europa.esig.jaxb.policy.LevelConstraint;
import java.util.List;

public class CertificateAndServiceConsistencyCheck
extends ChainItem<XmlValidationSignatureQualification> {
    private final CertificateWrapper signingCertificate;
    private final List<TrustedServiceWrapper> trustedServices;
    private MessageTag errorMessage;

    public CertificateAndServiceConsistencyCheck(XmlValidationSignatureQualification result, CertificateWrapper signingCertificate, List<TrustedServiceWrapper> trustedServices, LevelConstraint constraint) {
        super(result, constraint);
        this.signingCertificate = signingCertificate;
        this.trustedServices = trustedServices;
    }

    @Override
    protected boolean process() {
        if (Utils.isCollectionNotEmpty(this.trustedServices)) {
            boolean esign = QCTypeIdentifiers.isQCTypeEsign(this.signingCertificate);
            boolean eseal = QCTypeIdentifiers.isQCTypeEseal(this.signingCertificate);
            boolean web = QCTypeIdentifiers.isQCTypeWeb(this.signingCertificate);
            for (TrustedServiceWrapper trustedService : this.trustedServices) {
                List qualifiers = trustedService.getCapturedQualifiers();
                List<String> usageQualifiers = ServiceQualification.getUsageQualifiers(qualifiers);
                if (!Utils.isCollectionEmpty(usageQualifiers)) continue;
                List asis = trustedService.getAdditionalServiceInfos();
                if (esign && !AdditionalServiceInformation.isForeSignatures(asis)) {
                    this.errorMessage = MessageTag.QUAL_TL_CERT_CONS_ANS3;
                    return false;
                }
                if (eseal && !AdditionalServiceInformation.isForeSeals(asis)) {
                    this.errorMessage = MessageTag.QUAL_TL_CERT_CONS_ANS1;
                    return false;
                }
                if (!web || AdditionalServiceInformation.isForWebAuth(asis)) continue;
                this.errorMessage = MessageTag.QUAL_TL_CERT_CONS_ANS2;
                return false;
            }
        }
        return true;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.QUAL_TL_CERT_CONS;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return this.errorMessage;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return null;
    }
}

