/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qmatrix.qualification.checks;

import eu.europa.esig.dss.jaxb.detailedreport.XmlValidationSignatureQualification;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.policy.rules.Indication;
import eu.europa.esig.dss.validation.policy.rules.SubIndication;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.MessageTag;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.consistency.TrustedServiceChecker;
import eu.europa.esig.dss.validation.reports.wrapper.TrustedServiceWrapper;
import eu.europa.esig.jaxb.policy.LevelConstraint;
import java.util.List;

public class ServiceConsistencyCheck
extends ChainItem<XmlValidationSignatureQualification> {
    private final List<TrustedServiceWrapper> trustedServices;
    private MessageTag errorMessage;

    public ServiceConsistencyCheck(XmlValidationSignatureQualification result, List<TrustedServiceWrapper> trustedServices, LevelConstraint constraint) {
        super(result, constraint);
        this.trustedServices = trustedServices;
    }

    @Override
    protected boolean process() {
        if (Utils.isCollectionEmpty(this.trustedServices)) {
            this.errorMessage = MessageTag.QUAL_TL_SERV_CONS_ANS0;
            return false;
        }
        for (TrustedServiceWrapper trustedService : this.trustedServices) {
            if (!TrustedServiceChecker.isQCStatementConsistent(trustedService)) {
                this.errorMessage = MessageTag.QUAL_TL_SERV_CONS_ANS1;
                return false;
            }
            if (!TrustedServiceChecker.isLegalPersonConsistent(trustedService)) {
                this.errorMessage = MessageTag.QUAL_TL_SERV_CONS_ANS2;
                return false;
            }
            if (!TrustedServiceChecker.isQSCDConsistent(trustedService)) {
                this.errorMessage = MessageTag.QUAL_TL_SERV_CONS_ANS3;
                return false;
            }
            if (!TrustedServiceChecker.isUsageConsistent(trustedService)) {
                this.errorMessage = MessageTag.QUAL_TL_SERV_CONS_ANS4;
                return false;
            }
            if (!TrustedServiceChecker.isPreEIDASConsistent(trustedService)) {
                this.errorMessage = MessageTag.QUAL_TL_SERV_CONS_ANS5;
                return false;
            }
            if (TrustedServiceChecker.isQualifierAndAdditionalServiceInfoConsistent(trustedService)) continue;
            this.errorMessage = MessageTag.QUAL_TL_SERV_CONS_ANS6;
            return false;
        }
        return true;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.QUAL_TL_SERV_CONS;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return this.errorMessage;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return null;
    }
}

