/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.filter;

import eu.europa.esig.dss.validation.process.qmatrix.EIDASUtils;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.ServiceQualification;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.TrustedServiceStatus;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.filter.AbstractTrustedServiceFilter;
import eu.europa.esig.dss.validation.reports.wrapper.TrustedServiceWrapper;

public class AcceptableCAQCServiceFilter
extends AbstractTrustedServiceFilter {
    @Override
    boolean isAcceptable(TrustedServiceWrapper service) {
        if (EIDASUtils.isPostEIDAS(service.getStartDate())) {
            return this.isCaQc(service) && this.hasAcceptableStatusAfterEIDAS(service);
        }
        return this.isCaQc(service) && this.hasAcceptableStatusBeforeEIDAS(service);
    }

    private boolean isCaQc(TrustedServiceWrapper service) {
        return ServiceQualification.isCaQc(service.getType());
    }

    private boolean hasAcceptableStatusAfterEIDAS(TrustedServiceWrapper service) {
        return TrustedServiceStatus.isAcceptableStatusAfterEIDAS(service.getStatus());
    }

    private boolean hasAcceptableStatusBeforeEIDAS(TrustedServiceWrapper service) {
        return TrustedServiceStatus.isAcceptableStatusBeforeEIDAS(service.getStatus());
    }
}

