/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.qscd;

import eu.europa.esig.dss.validation.process.Condition;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.filter.TrustedServiceFilter;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.filter.TrustedServicesFilterFactory;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.qscd.AbstractQSCDCondition;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.qscd.QSCDConditionFactory;
import eu.europa.esig.dss.validation.reports.wrapper.CertificateWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.TrustedServiceWrapper;
import java.util.Date;
import java.util.List;

public class QSCDFromCertAndTL
extends AbstractQSCDCondition {
    private final CertificateWrapper signingCertificate;
    private final List<TrustedServiceWrapper> caqcServices;
    private final Condition qualified;
    private final Date date;

    public QSCDFromCertAndTL(CertificateWrapper signingCertificate, List<TrustedServiceWrapper> caqcServices, Condition qualified, Date date) {
        this.signingCertificate = signingCertificate;
        this.caqcServices = caqcServices;
        this.qualified = qualified;
        this.date = date;
    }

    @Override
    public boolean check() {
        TrustedServiceFilter filterByDate = TrustedServicesFilterFactory.createFilterByDate(this.date);
        List<TrustedServiceWrapper> servicesAtGivenDate = filterByDate.filter(this.caqcServices);
        Condition qscdInCert = QSCDConditionFactory.createQSCDFromCert(this.signingCertificate);
        Condition qscdFromCertAndTL = QSCDConditionFactory.createQSCDFromTL(servicesAtGivenDate, this.qualified, qscdInCert);
        return qscdFromCertAndTL.check();
    }
}

