/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.qualified;

import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.filter.TrustedServiceFilter;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.filter.TrustedServicesFilterFactory;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.qualified.AbstractQualificationCondition;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.qualified.QualificationStrategy;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.qualified.QualificationStrategyFactory;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.qualified.QualifiedStatus;
import eu.europa.esig.dss.validation.reports.wrapper.CertificateWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.TrustedServiceWrapper;
import java.util.Date;
import java.util.List;

public class QualificationFromCertAndTL
extends AbstractQualificationCondition {
    private final CertificateWrapper signingCertificate;
    private final List<TrustedServiceWrapper> caqcServices;
    private final Date date;

    public QualificationFromCertAndTL(CertificateWrapper signingCertificate, List<TrustedServiceWrapper> caqcServices, Date date) {
        this.signingCertificate = signingCertificate;
        this.caqcServices = caqcServices;
        this.date = date;
    }

    @Override
    public QualifiedStatus getQualifiedStatus() {
        TrustedServiceFilter filterByDate = TrustedServicesFilterFactory.createFilterByDate(this.date);
        List<TrustedServiceWrapper> servicesAtGivenDate = filterByDate.filter(this.caqcServices);
        QualificationStrategy qualificationInCert = QualificationStrategyFactory.createQualificationFromCert(this.signingCertificate);
        QualificationStrategy qualificationFromCertAndTL = QualificationStrategyFactory.createQualificationFromTL(servicesAtGivenDate, qualificationInCert);
        return qualificationFromCertAndTL.getQualifiedStatus();
    }
}

