/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.qualified.tl;

import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.ServiceQualification;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.qualified.AbstractQualificationCondition;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.qualified.QualificationStrategy;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.qualified.QualifiedStatus;
import eu.europa.esig.dss.validation.reports.wrapper.TrustedServiceWrapper;
import java.util.Collection;
import java.util.List;

public class QualificationByTL
extends AbstractQualificationCondition {
    private final List<TrustedServiceWrapper> trustedServices;
    private final QualificationStrategy qualifiedInCert;

    public QualificationByTL(List<TrustedServiceWrapper> trustedServices, QualificationStrategy qualifiedInCert) {
        this.trustedServices = trustedServices;
        this.qualifiedInCert = qualifiedInCert;
    }

    @Override
    public QualifiedStatus getQualifiedStatus() {
        if (Utils.isCollectionEmpty(this.trustedServices)) {
            return QualifiedStatus.NOT_QC;
        }
        for (TrustedServiceWrapper trustedService : this.trustedServices) {
            List capturedQualifiers = trustedService.getCapturedQualifiers();
            if (!Utils.isCollectionNotEmpty((Collection)capturedQualifiers)) continue;
            if (ServiceQualification.isNotQualified(capturedQualifiers)) {
                return QualifiedStatus.NOT_QC;
            }
            if (!ServiceQualification.isQcStatement(capturedQualifiers)) continue;
            return QualifiedStatus.QC;
        }
        return this.qualifiedInCert.getQualifiedStatus();
    }
}

