/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.type.cert;

import eu.europa.esig.dss.validation.process.QCStatementPolicyIdentifiers;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.QCTypeIdentifiers;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.type.Type;
import eu.europa.esig.dss.validation.process.qmatrix.qualification.checks.type.TypeStrategy;
import eu.europa.esig.dss.validation.reports.wrapper.CertificateWrapper;

public class TypeByCertificatePostEIDAS
implements TypeStrategy {
    private final CertificateWrapper signingCertificate;

    public TypeByCertificatePostEIDAS(CertificateWrapper signingCertificate) {
        this.signingCertificate = signingCertificate;
    }

    @Override
    public Type getType() {
        boolean noneType;
        boolean qcCompliant = QCStatementPolicyIdentifiers.isQCCompliant(this.signingCertificate);
        boolean esign = QCTypeIdentifiers.isQCTypeEsign(this.signingCertificate);
        boolean eseal = QCTypeIdentifiers.isQCTypeEseal(this.signingCertificate);
        boolean web = QCTypeIdentifiers.isQCTypeWeb(this.signingCertificate);
        boolean bl = noneType = !esign && !eseal && !web;
        if (qcCompliant && (noneType || esign)) {
            return Type.ESIGN;
        }
        if (qcCompliant && (eseal || web)) {
            return Type.ESEAL;
        }
        return Type.UNKNOWN;
    }
}

