/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qmatrix.tl;

import eu.europa.esig.dss.jaxb.detailedreport.XmlTLAnalysis;
import eu.europa.esig.dss.jaxb.diagnostic.XmlTrustedList;
import eu.europa.esig.dss.validation.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.qmatrix.tl.checks.TLFreshnessCheck;
import eu.europa.esig.dss.validation.process.qmatrix.tl.checks.TLNotExpiredCheck;
import eu.europa.esig.dss.validation.process.qmatrix.tl.checks.TLVersionCheck;
import eu.europa.esig.dss.validation.process.qmatrix.tl.checks.TLWellSignedCheck;
import eu.europa.esig.jaxb.policy.LevelConstraint;
import eu.europa.esig.jaxb.policy.TimeConstraint;
import eu.europa.esig.jaxb.policy.ValueConstraint;
import java.util.Date;

public class TLValidationBlock
extends Chain<XmlTLAnalysis> {
    private final XmlTrustedList currentTL;
    private final Date currentTime;
    private final ValidationPolicy policy;

    public TLValidationBlock(XmlTrustedList currentTL, Date currentTime, ValidationPolicy policy) {
        super(new XmlTLAnalysis());
        ((XmlTLAnalysis)this.result).setCountryCode(currentTL.getCountryCode());
        this.currentTL = currentTL;
        this.currentTime = currentTime;
        this.policy = policy;
    }

    @Override
    protected void initChain() {
        ChainItem<XmlTLAnalysis> item = this.firstItem = this.tlFreshness();
        item = item.setNextItem(this.tlNotExpired());
        item = item.setNextItem(this.tlVersion());
        item = item.setNextItem(this.tlWellSigned());
    }

    @Override
    protected void addAdditionalInfo() {
        this.collectErrorsWarnsInfos();
    }

    private ChainItem<XmlTLAnalysis> tlFreshness() {
        TimeConstraint constraint = this.policy.getTLFreshnessConstraint();
        return new TLFreshnessCheck((XmlTLAnalysis)this.result, this.currentTL, this.currentTime, constraint);
    }

    private ChainItem<XmlTLAnalysis> tlNotExpired() {
        LevelConstraint constraint = this.policy.getTLNotExpiredConstraint();
        return new TLNotExpiredCheck((XmlTLAnalysis)this.result, this.currentTL, this.currentTime, constraint);
    }

    private ChainItem<XmlTLAnalysis> tlVersion() {
        ValueConstraint constraint = this.policy.getTLVersionConstraint();
        return new TLVersionCheck((XmlTLAnalysis)this.result, this.currentTL, this.currentTime, constraint);
    }

    private ChainItem<XmlTLAnalysis> tlWellSigned() {
        LevelConstraint constraint = this.policy.getTLWellSignedConstraint();
        return new TLWellSignedCheck((XmlTLAnalysis)this.result, this.currentTL, constraint);
    }
}

