/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfltvd;

import eu.europa.esig.dss.jaxb.detailedreport.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.jaxb.detailedreport.XmlConclusion;
import eu.europa.esig.dss.jaxb.detailedreport.XmlConstraint;
import eu.europa.esig.dss.jaxb.detailedreport.XmlConstraintsConclusion;
import eu.europa.esig.dss.jaxb.detailedreport.XmlSignature;
import eu.europa.esig.dss.jaxb.detailedreport.XmlStatus;
import eu.europa.esig.dss.jaxb.detailedreport.XmlValidationProcessLongTermData;
import eu.europa.esig.dss.jaxb.detailedreport.XmlValidationProcessTimestamps;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.policy.Context;
import eu.europa.esig.dss.validation.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.policy.rules.Indication;
import eu.europa.esig.dss.validation.policy.rules.SubIndication;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CryptographicCheck;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.AcceptableBasicSignatureValidationCheck;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.BestSignatureTimeNotBeforeCertificateIssuanceCheck;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.RevocationBasicBuildingBlocksCheck;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.RevocationDateAfterBestSignatureTimeCheck;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.SigningTimeAttributePresentCheck;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.TimestampCoherenceOrderCheck;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.TimestampDelayCheck;
import eu.europa.esig.dss.validation.reports.wrapper.CertificateWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.DiagnosticData;
import eu.europa.esig.dss.validation.reports.wrapper.RevocationWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.SignatureWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.TimestampWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.TokenProxy;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationProcessForSignaturesWithLongTermValidationData
extends Chain<XmlValidationProcessLongTermData> {
    private static final Logger LOG = LoggerFactory.getLogger(ValidationProcessForSignaturesWithLongTermValidationData.class);
    private final XmlConstraintsConclusion basicSignatureValidation;
    private final List<XmlValidationProcessTimestamps> timestampValidations;
    private final DiagnosticData diagnosticData;
    private final SignatureWrapper currentSignature;
    private final Map<String, XmlBasicBuildingBlocks> bbbs;
    private final ValidationPolicy policy;
    private final Date currentDate;

    public ValidationProcessForSignaturesWithLongTermValidationData(XmlSignature signatureAnalysis, DiagnosticData diagnosticData, SignatureWrapper currentSignature, Map<String, XmlBasicBuildingBlocks> bbbs, ValidationPolicy policy, Date currentDate) {
        super(new XmlValidationProcessLongTermData());
        this.basicSignatureValidation = signatureAnalysis.getValidationProcessBasicSignatures();
        this.timestampValidations = signatureAnalysis.getValidationProcessTimestamps();
        this.diagnosticData = diagnosticData;
        this.currentSignature = currentSignature;
        this.bbbs = bbbs;
        this.policy = policy;
        this.currentDate = currentDate;
    }

    @Override
    protected void initChain() {
        XmlConclusion xmlConclusion;
        Set<TimestampWrapper> allowedTimestamps;
        Date bestSignatureTime = this.currentDate;
        ChainItem<XmlValidationProcessLongTermData> item = this.firstItem = this.isAcceptableBasicSignatureValidation();
        Set<RevocationWrapper> revocationData = this.getLinkedRevocationData();
        if (Utils.isCollectionNotEmpty(revocationData)) {
            for (RevocationWrapper revocationWrapper : revocationData) {
                XmlBasicBuildingBlocks revocationBBB = this.bbbs.get(revocationWrapper.getId());
                if (revocationBBB != null) {
                    item = item.setNextItem(this.revocationBasicBuildingBlocksValid(revocationBBB));
                    continue;
                }
                LOG.warn("No BBB found for revocation " + revocationWrapper.getId());
            }
        }
        if (Utils.isCollectionNotEmpty(allowedTimestamps = this.filterInvalidTimestamps(this.currentSignature.getTimestampList()))) {
            for (TimestampWrapper timestampWrapper : allowedTimestamps) {
                Date productionTime = timestampWrapper.getProductionTime();
                if (!productionTime.before(bestSignatureTime)) continue;
                bestSignatureTime = productionTime;
            }
        }
        if (Indication.INDETERMINATE.equals((Object)(xmlConclusion = this.basicSignatureValidation.getConclusion()).getIndication()) && SubIndication.REVOKED_NO_POE.equals((Object)xmlConclusion.getSubIndication())) {
            item = item.setNextItem(this.revocationDateAfterBestSignatureDate(bestSignatureTime));
        }
        if (Indication.INDETERMINATE.equals((Object)xmlConclusion.getIndication()) && SubIndication.OUT_OF_BOUNDS_NO_POE.equals((Object)xmlConclusion.getSubIndication())) {
            item = item.setNextItem(this.bestSignatureTimeNotBeforeCertificateIssuance(bestSignatureTime));
        }
        if (Indication.INDETERMINATE.equals((Object)xmlConclusion.getIndication()) && SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE.equals((Object)xmlConclusion.getSubIndication())) {
            item = item.setNextItem(this.algorithmReliableAtBestSignatureTime(bestSignatureTime));
        }
        if (Utils.isCollectionNotEmpty(allowedTimestamps)) {
            item = item.setNextItem(this.timestampCoherenceOrder(allowedTimestamps));
            item = item.setNextItem(this.signingTimeAttributePresent());
            item = item.setNextItem(this.timestampDelay(bestSignatureTime));
        }
    }

    private Set<RevocationWrapper> getLinkedRevocationData() {
        HashSet<RevocationWrapper> result = new HashSet<RevocationWrapper>();
        this.extractRevocationDataFromCertificateChain(result, this.currentSignature.getCertificateChainIds());
        List timestampList = this.currentSignature.getTimestampList();
        for (TimestampWrapper timestamp : timestampList) {
            this.extractRevocationDataFromCertificateChain(result, timestamp.getCertificateChainIds());
        }
        return result;
    }

    private void extractRevocationDataFromCertificateChain(Set<RevocationWrapper> result, List<String> certificateChainIds) {
        for (String certificateId : certificateChainIds) {
            CertificateWrapper certificate = this.diagnosticData.getUsedCertificateById(certificateId);
            if (certificate == null || certificate.getRevocationData() == null) continue;
            result.addAll(certificate.getRevocationData());
        }
    }

    private Set<TimestampWrapper> filterInvalidTimestamps(List<TimestampWrapper> allTimestamps) {
        HashSet<TimestampWrapper> result = new HashSet<TimestampWrapper>();
        for (TimestampWrapper timestampWrapper : allTimestamps) {
            boolean foundValidationTSP = false;
            block1: for (XmlValidationProcessTimestamps timestampValidation : this.timestampValidations) {
                List constraints = timestampValidation.getConstraint();
                for (XmlConstraint tspValidation : constraints) {
                    if (!Utils.areStringsEqual((String)timestampWrapper.getId(), (String)tspValidation.getId())) continue;
                    foundValidationTSP = true;
                    if (!XmlStatus.OK.equals((Object)tspValidation.getStatus())) continue;
                    result.add(timestampWrapper);
                    continue block1;
                }
            }
            if (foundValidationTSP) continue;
            LOG.warn("Cannot find tsp validation info for tsp " + timestampWrapper.getId());
        }
        return result;
    }

    private ChainItem<XmlValidationProcessLongTermData> isAcceptableBasicSignatureValidation() {
        return new AcceptableBasicSignatureValidationCheck((XmlValidationProcessLongTermData)this.result, this.basicSignatureValidation, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationProcessLongTermData> revocationBasicBuildingBlocksValid(XmlBasicBuildingBlocks revocationBBB) {
        return new RevocationBasicBuildingBlocksCheck((XmlValidationProcessLongTermData)this.result, revocationBBB, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationProcessLongTermData> revocationDateAfterBestSignatureDate(Date bestSignatureTime) {
        CertificateWrapper signingCertificate = this.diagnosticData.getUsedCertificateById(this.currentSignature.getSigningCertificateId());
        return new RevocationDateAfterBestSignatureTimeCheck((XmlValidationProcessLongTermData)this.result, signingCertificate, bestSignatureTime, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationProcessLongTermData> bestSignatureTimeNotBeforeCertificateIssuance(Date bestSignatureTime) {
        CertificateWrapper signingCertificate = this.diagnosticData.getUsedCertificateById(this.currentSignature.getSigningCertificateId());
        return new BestSignatureTimeNotBeforeCertificateIssuanceCheck((XmlValidationProcessLongTermData)this.result, bestSignatureTime, signingCertificate, this.policy.getBestSignatureTimeBeforeIssuanceDateOfSigningCertificateConstraint());
    }

    private ChainItem<XmlValidationProcessLongTermData> timestampCoherenceOrder(Set<TimestampWrapper> allowedTimestamps) {
        return new TimestampCoherenceOrderCheck((XmlValidationProcessLongTermData)this.result, allowedTimestamps, this.policy.getTimestampCoherenceConstraint());
    }

    private ChainItem<XmlValidationProcessLongTermData> signingTimeAttributePresent() {
        return new SigningTimeAttributePresentCheck((XmlValidationProcessLongTermData)this.result, this.currentSignature, this.policy.getSigningTimeConstraint());
    }

    private ChainItem<XmlValidationProcessLongTermData> timestampDelay(Date bestSignatureTime) {
        return new TimestampDelayCheck((XmlValidationProcessLongTermData)this.result, this.currentSignature, bestSignatureTime, this.policy.getTimestampDelaySigningTimePropertyConstraint());
    }

    private ChainItem<XmlValidationProcessLongTermData> algorithmReliableAtBestSignatureTime(Date bestSignatureTime) {
        return new CryptographicCheck<XmlConstraintsConclusion>(this.result, (TokenProxy)this.currentSignature, bestSignatureTime, this.policy.getSignatureCryptographicConstraint(Context.SIGNATURE));
    }
}

