/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp;

import eu.europa.esig.dss.jaxb.detailedreport.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.jaxb.detailedreport.XmlConstraintsConclusion;
import eu.europa.esig.dss.jaxb.detailedreport.XmlPSV;
import eu.europa.esig.dss.jaxb.detailedreport.XmlSignature;
import eu.europa.esig.dss.jaxb.detailedreport.XmlValidationProcessArchivalData;
import eu.europa.esig.dss.jaxb.detailedreport.XmlValidationProcessTimestamps;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.policy.Context;
import eu.europa.esig.dss.validation.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.policy.rules.Indication;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEExtraction;
import eu.europa.esig.dss.validation.process.vpfswatsp.TimestampComparator;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.LongTermValidationCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.PastSignatureValidationCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.PastSignatureValidation;
import eu.europa.esig.dss.validation.reports.wrapper.DiagnosticData;
import eu.europa.esig.dss.validation.reports.wrapper.SignatureWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.TimestampWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.TokenProxy;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationProcessForSignaturesWithArchivalData
extends Chain<XmlValidationProcessArchivalData> {
    private static final Logger LOG = LoggerFactory.getLogger(ValidationProcessForSignaturesWithArchivalData.class);
    private final XmlConstraintsConclusion validationProcessLongTermData;
    private final List<XmlValidationProcessTimestamps> validationProcessTimestamps;
    private final SignatureWrapper signature;
    private final DiagnosticData diagnosticData;
    private final Map<String, XmlBasicBuildingBlocks> bbbs;
    private final ValidationPolicy policy;
    private final Date currentTime;
    private final POEExtraction poe = new POEExtraction();

    public ValidationProcessForSignaturesWithArchivalData(XmlSignature signatureAnalysis, SignatureWrapper signature, DiagnosticData diagnosticData, Map<String, XmlBasicBuildingBlocks> bbbs, ValidationPolicy policy, Date currentTime) {
        super(new XmlValidationProcessArchivalData());
        this.validationProcessLongTermData = signatureAnalysis.getValidationProcessLongTermData();
        this.validationProcessTimestamps = signatureAnalysis.getValidationProcessTimestamps();
        this.signature = signature;
        this.diagnosticData = diagnosticData;
        this.bbbs = bbbs;
        this.policy = policy;
        this.currentTime = currentTime;
    }

    @Override
    protected void initChain() {
        Context currentContext = Context.SIGNATURE;
        if (this.signature.isCounterSignature()) {
            currentContext = Context.COUNTER_SIGNATURE;
        }
        this.poe.init(this.diagnosticData, this.currentTime);
        ChainItem<XmlValidationProcessArchivalData> item = this.firstItem = this.longTermValidation();
        if (this.isValid(this.validationProcessLongTermData)) {
            return;
        }
        List timestampsList = this.signature.getTimestampList();
        if (Utils.isCollectionNotEmpty((Collection)timestampsList)) {
            Collections.sort(timestampsList, new TimestampComparator());
            for (TimestampWrapper newestTimestamp : timestampsList) {
                XmlBasicBuildingBlocks bbbTsp = this.bbbs.get(newestTimestamp.getId());
                XmlConstraintsConclusion timestampValidation = this.getTimestampValidation(newestTimestamp);
                if (timestampValidation != null && bbbTsp != null) {
                    if (this.isValid(timestampValidation)) {
                        this.poe.extractPOE(newestTimestamp, this.diagnosticData);
                        continue;
                    }
                    PastSignatureValidation psv = new PastSignatureValidation((TokenProxy)newestTimestamp, this.diagnosticData, bbbTsp, this.poe, this.currentTime, this.policy, Context.TIMESTAMP);
                    XmlPSV psvResult = (XmlPSV)psv.execute();
                    bbbTsp.setPSV(psvResult);
                    if (!this.isValid((XmlConstraintsConclusion)psvResult)) continue;
                    this.poe.extractPOE(newestTimestamp, this.diagnosticData);
                    continue;
                }
                LOG.error("No timestamp validation found for timestamp " + newestTimestamp.getId());
            }
        }
        item = item.setNextItem(this.pastSignatureValidation(currentContext));
    }

    private ChainItem<XmlValidationProcessArchivalData> pastSignatureValidation(Context currentContext) {
        XmlBasicBuildingBlocks bbbSig = this.bbbs.get(this.signature.getId());
        return new PastSignatureValidationCheck((XmlValidationProcessArchivalData)this.result, this.signature, this.diagnosticData, bbbSig, this.poe, this.currentTime, this.policy, currentContext, this.getFailLevelConstraint());
    }

    private XmlConstraintsConclusion getTimestampValidation(TimestampWrapper newestTimestamp) {
        for (XmlValidationProcessTimestamps tspValidation : this.validationProcessTimestamps) {
            if (!Utils.areStringsEqual((String)tspValidation.getId(), (String)newestTimestamp.getId())) continue;
            return tspValidation;
        }
        return null;
    }

    private ChainItem<XmlValidationProcessArchivalData> longTermValidation() {
        return new LongTermValidationCheck((XmlValidationProcessArchivalData)this.result, this.validationProcessLongTermData, this.getFailLevelConstraint());
    }

    private boolean isValid(XmlConstraintsConclusion xmlConstraintConclusion) {
        return xmlConstraintConclusion != null && xmlConstraintConclusion.getConclusion() != null && Indication.PASSED.equals((Object)xmlConstraintConclusion.getConclusion().getIndication());
    }
}

