/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpftsp;

import eu.europa.esig.dss.jaxb.detailedreport.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.jaxb.detailedreport.XmlValidationProcessTimestamps;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.vpftsp.checks.TimestampBasicBuildingBlocksCheck;
import eu.europa.esig.dss.validation.reports.wrapper.TimestampWrapper;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationProcessForTimeStamps
extends Chain<XmlValidationProcessTimestamps> {
    private static final Logger LOG = LoggerFactory.getLogger(ValidationProcessForTimeStamps.class);
    private final TimestampWrapper timestamp;
    private final Map<String, XmlBasicBuildingBlocks> bbbs;

    public ValidationProcessForTimeStamps(TimestampWrapper timestamp, Map<String, XmlBasicBuildingBlocks> bbbs) {
        super(new XmlValidationProcessTimestamps());
        this.timestamp = timestamp;
        this.bbbs = bbbs;
    }

    @Override
    protected void initChain() {
        XmlBasicBuildingBlocks tspBBB = this.bbbs.get(this.timestamp.getId());
        if (tspBBB != null) {
            this.firstItem = this.timestampBasicBuildingBlocksValid(tspBBB);
        } else {
            LOG.error("Basic Building Blocks for timestamp " + this.timestamp.getId() + " not found!");
        }
    }

    @Override
    protected void addAdditionalInfo() {
        ((XmlValidationProcessTimestamps)this.result).setId(this.timestamp.getId());
        ((XmlValidationProcessTimestamps)this.result).setType(this.timestamp.getType());
    }

    private ChainItem<XmlValidationProcessTimestamps> timestampBasicBuildingBlocksValid(XmlBasicBuildingBlocks timestampBBB) {
        return new TimestampBasicBuildingBlocksCheck((XmlValidationProcessTimestamps)this.result, timestampBBB, this.getFailLevelConstraint());
    }
}

