/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.executor;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.jaxb.detailedreport.DetailedReport;
import eu.europa.esig.dss.jaxb.detailedreport.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.jaxb.detailedreport.XmlConclusion;
import eu.europa.esig.dss.jaxb.detailedreport.XmlSignature;
import eu.europa.esig.dss.jaxb.detailedreport.XmlValidationProcessArchivalData;
import eu.europa.esig.dss.jaxb.detailedreport.XmlValidationProcessBasicSignatures;
import eu.europa.esig.dss.jaxb.detailedreport.XmlValidationProcessLongTermData;
import eu.europa.esig.dss.jaxb.detailedreport.XmlValidationSignatureQualification;
import eu.europa.esig.dss.validation.executor.AbstractDetailedReportBuilder;
import eu.europa.esig.dss.validation.executor.ValidationLevel;
import eu.europa.esig.dss.validation.policy.Context;
import eu.europa.esig.dss.validation.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.process.qualification.signature.SignatureQualificationBlock;
import eu.europa.esig.dss.validation.process.vpfbs.ValidationProcessForBasicSignatures;
import eu.europa.esig.dss.validation.process.vpfltvd.ValidationProcessForSignaturesWithLongTermValidationData;
import eu.europa.esig.dss.validation.process.vpfswatsp.ValidationProcessForSignaturesWithArchivalData;
import eu.europa.esig.dss.validation.process.vpftsp.ValidationProcessForTimeStamps;
import eu.europa.esig.dss.validation.reports.wrapper.CertificateWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.DiagnosticData;
import eu.europa.esig.dss.validation.reports.wrapper.SignatureWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.TimestampWrapper;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetailedReportBuilder
extends AbstractDetailedReportBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(DetailedReportBuilder.class);
    private final ValidationLevel validationLevel;

    public DetailedReportBuilder(Date currentTime, ValidationPolicy policy, ValidationLevel validationLevel, DiagnosticData diagnosticData) {
        super(diagnosticData, policy, currentTime);
        this.validationLevel = validationLevel;
    }

    DetailedReport build() {
        DetailedReport detailedReport = this.init();
        Map<String, XmlBasicBuildingBlocks> bbbs = this.executeAllBasicBuildingBlocks();
        detailedReport.getBasicBuildingBlocks().addAll(bbbs.values());
        for (SignatureWrapper signature : this.diagnosticData.getSignatures()) {
            XmlSignature signatureAnalysis = new XmlSignature();
            signatureAnalysis.setId(signature.getId());
            if (signature.isCounterSignature()) {
                signatureAnalysis.setCounterSignature(Boolean.valueOf(true));
            }
            Date bestSignatureTime = this.currentTime;
            XmlConclusion conlusion = this.executeBasicValidation(signatureAnalysis, signature, bbbs);
            if (ValidationLevel.TIMESTAMPS.equals((Object)this.validationLevel)) {
                this.executeTimestampsValidation(signatureAnalysis, signature, bbbs);
            } else if (ValidationLevel.LONG_TERM_DATA.equals((Object)this.validationLevel)) {
                this.executeTimestampsValidation(signatureAnalysis, signature, bbbs);
                XmlValidationProcessLongTermData ltvResult = this.executeLongTermValidation(signatureAnalysis, signature, bbbs);
                conlusion = ltvResult.getConclusion();
                bestSignatureTime = ltvResult.getBestSignatureTime();
            } else if (ValidationLevel.ARCHIVAL_DATA.equals((Object)this.validationLevel)) {
                this.executeTimestampsValidation(signatureAnalysis, signature, bbbs);
                this.executeLongTermValidation(signatureAnalysis, signature, bbbs);
                XmlValidationProcessArchivalData archivalResult = this.executeArchiveValidation(signatureAnalysis, signature, bbbs);
                conlusion = archivalResult.getConclusion();
                bestSignatureTime = archivalResult.getBestSignatureTime();
            }
            if (this.policy.isEIDASConstraintPresent()) {
                try {
                    CertificateWrapper signingCertificate = this.diagnosticData.getUsedCertificateById(signature.getSigningCertificateId());
                    if (signingCertificate != null) {
                        CertificateWrapper rootCertificate = this.diagnosticData.getUsedCertificateById(signingCertificate.getLastChainCertificateId());
                        SignatureQualificationBlock qualificationBlock = new SignatureQualificationBlock(conlusion, bestSignatureTime, signingCertificate, rootCertificate, detailedReport.getTLAnalysis(), this.diagnosticData.getLOTLCountryCode());
                        signatureAnalysis.setValidationSignatureQualification((XmlValidationSignatureQualification)qualificationBlock.execute());
                    }
                }
                catch (Exception e) {
                    LOG.error("Unable to determine the signature qualification", (Throwable)e);
                }
            }
            detailedReport.getSignatures().add(signatureAnalysis);
        }
        return detailedReport;
    }

    private XmlConclusion executeBasicValidation(XmlSignature signatureAnalysis, SignatureWrapper signature, Map<String, XmlBasicBuildingBlocks> bbbs) {
        ValidationProcessForBasicSignatures vpfbs = new ValidationProcessForBasicSignatures(this.diagnosticData, signature, bbbs);
        XmlValidationProcessBasicSignatures bs = (XmlValidationProcessBasicSignatures)vpfbs.execute();
        bs.setBestSignatureTime(this.currentTime);
        signatureAnalysis.setValidationProcessBasicSignatures(bs);
        return bs.getConclusion();
    }

    private void executeTimestampsValidation(XmlSignature signatureAnalysis, SignatureWrapper signature, Map<String, XmlBasicBuildingBlocks> bbbs) {
        List allTimestamps = signature.getTimestampList();
        for (TimestampWrapper timestamp : allTimestamps) {
            ValidationProcessForTimeStamps vpftsp = new ValidationProcessForTimeStamps(timestamp, bbbs);
            signatureAnalysis.getValidationProcessTimestamps().add(vpftsp.execute());
        }
    }

    private XmlValidationProcessLongTermData executeLongTermValidation(XmlSignature signatureAnalysis, SignatureWrapper signature, Map<String, XmlBasicBuildingBlocks> bbbs) {
        ValidationProcessForSignaturesWithLongTermValidationData vpfltvd = new ValidationProcessForSignaturesWithLongTermValidationData(signatureAnalysis, this.diagnosticData, signature, bbbs, this.policy, this.currentTime);
        XmlValidationProcessLongTermData vpfltvdResult = (XmlValidationProcessLongTermData)vpfltvd.execute();
        signatureAnalysis.setValidationProcessLongTermData(vpfltvdResult);
        return vpfltvdResult;
    }

    private XmlValidationProcessArchivalData executeArchiveValidation(XmlSignature signatureAnalysis, SignatureWrapper signature, Map<String, XmlBasicBuildingBlocks> bbbs) {
        ValidationProcessForSignaturesWithArchivalData vpfswad = new ValidationProcessForSignaturesWithArchivalData(signatureAnalysis, signature, this.diagnosticData, bbbs, this.policy, this.currentTime);
        XmlValidationProcessArchivalData vpfswadResult = (XmlValidationProcessArchivalData)vpfswad.execute();
        signatureAnalysis.setValidationProcessArchivalData(vpfswadResult);
        return vpfswadResult;
    }

    private Map<String, XmlBasicBuildingBlocks> executeAllBasicBuildingBlocks() {
        HashMap<String, XmlBasicBuildingBlocks> bbbs = new HashMap<String, XmlBasicBuildingBlocks>();
        switch (this.validationLevel) {
            case ARCHIVAL_DATA: 
            case LONG_TERM_DATA: {
                this.process(this.diagnosticData.getAllRevocationData(), Context.REVOCATION, bbbs);
                this.process(this.diagnosticData.getAllTimestamps(), Context.TIMESTAMP, bbbs);
                this.process(this.diagnosticData.getAllSignatures(), Context.SIGNATURE, bbbs);
                this.process(this.diagnosticData.getAllCounterSignatures(), Context.COUNTER_SIGNATURE, bbbs);
                break;
            }
            case TIMESTAMPS: {
                this.process(this.diagnosticData.getAllTimestamps(), Context.TIMESTAMP, bbbs);
                this.process(this.diagnosticData.getAllSignatures(), Context.SIGNATURE, bbbs);
                this.process(this.diagnosticData.getAllCounterSignatures(), Context.COUNTER_SIGNATURE, bbbs);
                break;
            }
            case BASIC_SIGNATURES: {
                this.process(this.diagnosticData.getAllSignatures(), Context.SIGNATURE, bbbs);
                this.process(this.diagnosticData.getAllCounterSignatures(), Context.COUNTER_SIGNATURE, bbbs);
                break;
            }
            default: {
                throw new DSSException("Unsupported validation level " + (Object)((Object)this.validationLevel));
            }
        }
        return bbbs;
    }
}

