/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.checks;

import eu.europa.esig.dss.jaxb.detailedreport.XmlConstraintsConclusion;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.policy.rules.Indication;
import eu.europa.esig.dss.validation.policy.rules.SubIndication;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.MessageTag;
import eu.europa.esig.dss.validation.reports.wrapper.TokenProxy;
import eu.europa.esig.jaxb.policy.Algo;
import eu.europa.esig.jaxb.policy.AlgoExpirationDate;
import eu.europa.esig.jaxb.policy.CryptographicConstraint;
import eu.europa.esig.jaxb.policy.LevelConstraint;
import eu.europa.esig.jaxb.policy.ListAlgo;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptographicCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private static final Logger LOG = LoggerFactory.getLogger(CryptographicCheck.class);
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private final Date validationDate;
    private final TokenProxy token;
    private final CryptographicConstraint constraint;
    private MessageTag errorMessage = MessageTag.EMPTY;

    public CryptographicCheck(T result, TokenProxy token, Date currentTime, CryptographicConstraint constraint) {
        super(result, (LevelConstraint)constraint);
        this.validationDate = currentTime;
        this.token = token;
        this.constraint = constraint;
    }

    @Override
    protected boolean process() {
        AlgoExpirationDate algoExpirationDate;
        ListAlgo acceptableEncryptionAlgo = this.constraint.getAcceptableEncryptionAlgo();
        if (acceptableEncryptionAlgo != null && Utils.isCollectionNotEmpty((Collection)acceptableEncryptionAlgo.getAlgo()) && !this.isIn(this.token.getEncryptionAlgoUsedToSignThisToken(), acceptableEncryptionAlgo.getAlgo())) {
            this.errorMessage = MessageTag.ASCCM_ANS_1;
            return false;
        }
        ListAlgo acceptableDigestAlgo = this.constraint.getAcceptableDigestAlgo();
        if (acceptableDigestAlgo != null && Utils.isCollectionNotEmpty((Collection)acceptableDigestAlgo.getAlgo()) && !this.isIn(this.token.getDigestAlgoUsedToSignThisToken(), acceptableDigestAlgo.getAlgo())) {
            this.errorMessage = MessageTag.ASCCM_ANS_2;
            return false;
        }
        ListAlgo miniPublicKeySize = this.constraint.getMiniPublicKeySize();
        if (miniPublicKeySize != null && Utils.isCollectionNotEmpty((Collection)miniPublicKeySize.getAlgo())) {
            int expectedMinimumKeySize;
            String keySize = this.token.getKeyLengthUsedToSignThisToken();
            int tokenKeySize = 0;
            if (Utils.isStringDigits((String)keySize)) {
                tokenKeySize = Integer.parseInt(keySize);
            }
            if (tokenKeySize < (expectedMinimumKeySize = this.getExpectedKeySize(this.token.getEncryptionAlgoUsedToSignThisToken(), miniPublicKeySize.getAlgo()))) {
                this.errorMessage = MessageTag.ASCCM_ANS_3;
                return false;
            }
        }
        if ((algoExpirationDate = this.constraint.getAlgoExpirationDate()) != null && Utils.isCollectionNotEmpty((Collection)algoExpirationDate.getAlgo())) {
            Date expirationDate = this.getExpirationDate(this.token.getDigestAlgoUsedToSignThisToken(), algoExpirationDate.getAlgo(), algoExpirationDate.getFormat());
            if (expirationDate == null) {
                this.errorMessage = MessageTag.ASCCM_ANS_4;
                return false;
            }
            if (expirationDate.before(this.validationDate)) {
                this.errorMessage = MessageTag.ASCCM_ANS_5;
                return false;
            }
            String algoToFind = this.token.getEncryptionAlgoUsedToSignThisToken() + this.token.getKeyLengthUsedToSignThisToken();
            expirationDate = this.getExpirationDate(algoToFind, algoExpirationDate.getAlgo(), algoExpirationDate.getFormat());
            if (expirationDate == null) {
                this.errorMessage = MessageTag.ASCCM_ANS_4;
                return false;
            }
            if (expirationDate.before(this.validationDate)) {
                this.errorMessage = MessageTag.ASCCM_ANS_5;
                return false;
            }
        }
        return true;
    }

    private Date getExpirationDate(String algoToFind, List<Algo> algos, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(Utils.isStringEmpty((String)format) ? DATE_FORMAT : format);
        Date result = null;
        for (Algo algo : algos) {
            if (!Utils.areStringsEqual((String)algoToFind, (String)algo.getValue()) || !Utils.isStringNotEmpty((String)algo.getDate())) continue;
            try {
                result = dateFormat.parse(algo.getDate());
            }
            catch (Exception e) {
                LOG.warn("Unable to parse date with pattern '{}' : {}", (Object)dateFormat.toPattern(), (Object)e.getMessage());
            }
        }
        return result;
    }

    private int getExpectedKeySize(String encryptionAlgo, List<Algo> algos) {
        int expectedSize = 0;
        for (Algo algo : algos) {
            String size;
            if (!Utils.areStringsEqual((String)algo.getValue(), (String)encryptionAlgo) || !Utils.isStringDigits((String)(size = algo.getSize()))) continue;
            expectedSize = Integer.parseInt(size);
        }
        return expectedSize;
    }

    private boolean isIn(String algoToFind, List<Algo> algos) {
        for (Algo algo : algos) {
            if (!Utils.areStringsEqual((String)algo.getValue(), (String)algoToFind)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.ASCCM;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return this.errorMessage;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE;
    }

    @Override
    protected String getAdditionalInfo() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        Object[] params = new Object[]{sdf.format(this.validationDate)};
        return MessageFormat.format("Validation time : {0}", params);
    }
}

