/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.checks;

import eu.europa.esig.dss.jaxb.detailedreport.XmlXCV;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.policy.Context;
import eu.europa.esig.dss.validation.policy.rules.Indication;
import eu.europa.esig.dss.validation.policy.rules.SubIndication;
import eu.europa.esig.dss.validation.process.MessageTag;
import eu.europa.esig.dss.validation.process.bbb.AbstractMultiValuesCheckItem;
import eu.europa.esig.dss.validation.reports.wrapper.CertificateWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.TrustedServiceWrapper;
import eu.europa.esig.dss.x509.CertificateSourceType;
import eu.europa.esig.jaxb.policy.MultiValuesConstraint;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class TrustedServiceStatusCheck
extends AbstractMultiValuesCheckItem<XmlXCV> {
    private final CertificateWrapper certificate;
    private final Date usageTime;
    private final Context context;
    private String serviceStatusStr;

    public TrustedServiceStatusCheck(XmlXCV result, CertificateWrapper certificate, Date usageTime, Context context, MultiValuesConstraint constraint) {
        super(result, constraint);
        this.certificate = certificate;
        this.usageTime = usageTime;
        this.context = context;
    }

    @Override
    protected boolean process() {
        String trustedSource = this.certificate.getLastChainCertificateSource();
        if (CertificateSourceType.TRUSTED_STORE.name().equals(trustedSource)) {
            return true;
        }
        List trustedServices = this.certificate.getTrustedServices();
        if (Utils.isCollectionNotEmpty((Collection)trustedServices)) {
            for (TrustedServiceWrapper trustedService : trustedServices) {
                this.serviceStatusStr = Utils.trim((String)trustedService.getStatus());
                Date statusStartDate = trustedService.getStartDate();
                if (!this.processValueCheck(this.serviceStatusStr) || statusStartDate == null) continue;
                Date statusEndDate = trustedService.getEndDate();
                if (this.usageTime.compareTo(statusStartDate) < 0 || statusEndDate != null && !this.usageTime.before(statusEndDate)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected String getAdditionalInfo() {
        if (Utils.isStringNotEmpty((String)this.serviceStatusStr)) {
            Object[] params = new Object[]{this.serviceStatusStr};
            return MessageFormat.format("Status : {0}", params);
        }
        return null;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.XCV_TSL_ESP;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        switch (this.context) {
            case SIGNATURE: {
                return MessageTag.XCV_TSL_ESP_SIG_ANS;
            }
            case COUNTER_SIGNATURE: {
                return MessageTag.XCV_TSL_ESP_SIG_ANS;
            }
            case TIMESTAMP: {
                return MessageTag.XCV_TSL_ESP_TSP_ANS;
            }
            case REVOCATION: {
                return MessageTag.XCV_TSL_ESP_REV_ANS;
            }
        }
        return MessageTag.XCV_TSL_ESP_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.NO_CERTIFICATE_CHAIN_FOUND;
    }
}

