/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.rfc.checks;

import eu.europa.esig.dss.jaxb.detailedreport.XmlRFC;
import eu.europa.esig.dss.validation.policy.rules.Indication;
import eu.europa.esig.dss.validation.policy.rules.SubIndication;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.MessageTag;
import eu.europa.esig.dss.validation.reports.wrapper.RevocationWrapper;
import eu.europa.esig.jaxb.policy.LevelConstraint;
import java.util.Date;

public class NextUpdateCheck
extends ChainItem<XmlRFC> {
    private final RevocationWrapper revocationData;

    public NextUpdateCheck(XmlRFC result, RevocationWrapper revocationData, LevelConstraint constraint) {
        super(result, constraint);
        this.revocationData = revocationData;
    }

    @Override
    protected boolean process() {
        if (this.revocationData != null) {
            Date nextUpdate = this.revocationData.getNextUpdate();
            return nextUpdate != null;
        }
        return false;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_RFC_NUP;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_RFC_NUP_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.TRY_LATER;
    }
}

