/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.rfc.checks;

import eu.europa.esig.dss.jaxb.detailedreport.XmlRFC;
import eu.europa.esig.dss.validation.policy.RuleUtils;
import eu.europa.esig.dss.validation.policy.rules.Indication;
import eu.europa.esig.dss.validation.policy.rules.SubIndication;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.MessageTag;
import eu.europa.esig.dss.validation.reports.wrapper.RevocationWrapper;
import eu.europa.esig.jaxb.policy.LevelConstraint;
import eu.europa.esig.jaxb.policy.TimeConstraint;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class RevocationDataFreshCheck
extends ChainItem<XmlRFC> {
    private final RevocationWrapper revocationData;
    private final Date validationDate;
    private final TimeConstraint timeConstraint;

    public RevocationDataFreshCheck(XmlRFC result, RevocationWrapper revocationData, Date validationDate, TimeConstraint constraint) {
        super(result, (LevelConstraint)constraint);
        this.revocationData = revocationData;
        this.validationDate = validationDate;
        this.timeConstraint = constraint;
    }

    @Override
    protected boolean process() {
        if (this.revocationData != null) {
            long maxFreshness = this.getMaxFreshness();
            long validationDateTime = this.validationDate.getTime();
            long limit = validationDateTime - maxFreshness;
            Date productionDate = this.revocationData.getProductionDate();
            return productionDate != null && productionDate.after(new Date(limit));
        }
        return false;
    }

    private long getMaxFreshness() {
        return RuleUtils.convertDuration(this.timeConstraint);
    }

    @Override
    protected String getAdditionalInfo() {
        String nextUpdateString = "not defined";
        if (this.revocationData != null && this.revocationData.getNextUpdate() != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            nextUpdateString = sdf.format(this.revocationData.getNextUpdate());
        }
        Object[] params = new Object[]{nextUpdateString};
        return MessageFormat.format("Next update : {0}", params);
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_RFC_IRIF;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_RFC_IRIF_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.TRY_LATER;
    }
}

