/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate.checks;

import eu.europa.esig.dss.jaxb.detailedreport.XmlValidationCertificateQualification;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.policy.rules.Indication;
import eu.europa.esig.dss.validation.policy.rules.SubIndication;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.MessageTag;
import eu.europa.esig.dss.validation.reports.wrapper.CertificateWrapper;
import eu.europa.esig.dss.validation.reports.wrapper.TrustedServiceWrapper;
import eu.europa.esig.jaxb.policy.LevelConstraint;
import java.util.Arrays;
import java.util.List;

public class TrustedCertificateMatchTrustServiceCheck
extends ChainItem<XmlValidationCertificateQualification> {
    private final CertificateWrapper signingCertificate;
    private final CertificateWrapper rootCertificate;
    private final TrustedServiceWrapper trustService;
    private MessageTag errorMessage = MessageTag.EMPTY;

    public TrustedCertificateMatchTrustServiceCheck(XmlValidationCertificateQualification result, CertificateWrapper signingCertificate, CertificateWrapper rootCertificate, TrustedServiceWrapper trustService, LevelConstraint constraint) {
        super(result, constraint);
        this.signingCertificate = signingCertificate;
        this.rootCertificate = rootCertificate;
        this.trustService = trustService;
    }

    @Override
    protected boolean process() {
        CertificateWrapper trustedCert = this.getTrustedCert();
        if (trustedCert == null) {
            this.errorMessage = MessageTag.QUAL_IS_TRUST_CERT_MATCH_SERVICE_ANS0;
            return false;
        }
        String organizationName = trustedCert.getOrganizationName();
        if (Utils.isStringBlank((String)organizationName)) {
            this.errorMessage = MessageTag.QUAL_IS_TRUST_CERT_MATCH_SERVICE_ANS1;
            return false;
        }
        if (!this.isMatch(trustedCert)) {
            this.errorMessage = MessageTag.QUAL_IS_TRUST_CERT_MATCH_SERVICE_ANS2;
            return false;
        }
        return true;
    }

    private CertificateWrapper getTrustedCert() {
        if (this.rootCertificate != null && this.rootCertificate.isTrusted()) {
            return this.rootCertificate;
        }
        if (this.signingCertificate != null && this.signingCertificate.isTrusted()) {
            return this.signingCertificate;
        }
        return null;
    }

    private boolean isMatch(CertificateWrapper trustedCert) {
        List<String> candidates = Arrays.asList(trustedCert.getOrganizationName(), trustedCert.getCommonName(), trustedCert.getOrganizationalUnit(), trustedCert.getCertificateDN());
        List<String> possibleMatchers = Arrays.asList(this.trustService.getTspName(), this.trustService.getServiceName());
        for (String candidate : candidates) {
            if (Utils.isStringBlank((String)candidate)) continue;
            for (String matcher : possibleMatchers) {
                if (!Utils.areStringsEqualIgnoreCase((String)candidate, (String)matcher)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.QUAL_IS_TRUST_CERT_MATCH_SERVICE;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return this.errorMessage;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return null;
    }
}

